#TRUSTED 41227ad032781de2c367503a51a90a1aab553586f59a9b7be5542c9fe02767aa8efdde07bc3e6324d0f2cd76192c6b3f66de572d220b16d7d8fc13b1bf950d2baf6189b1a5aba4290b6315bba9bda18e903da74f3c324bed699f29a8a0b62acd32c6f988d62e90a0278a7c00975fafed14e99ea10505418e26e4ebc8c6ed456e48d41ae2e567eae39679cd66b3cdbdd26e5ad04a95bf615d4d5f10994eb8e1e802c35ba90508d349276e4b521eb967f5195403b651c78c4b4f794cab3cefa359eb5e03c041aa49afbded2b5e7ebb65ce8066ebd358334d46252e8fc5a73528ead4793286588b2efd828aa8d3c9847e4646e16a810ddd4b69dae0281742eb3d562c5611604465408364970494d5e707c8788401d6bedebb424f01d1abe3fd008177e24b8f40e38196f7e953cb114a2dd9482ac561d1a4afa7ed7745a8c5439b415fdd5c77392de44db4baeb77fa91895b4571f85f5d6598b85199e3af3bb24a869d5dcbc9ff3804b5f731eec0e6746c075ad960bca522fdd30bf1e2e41886a17298236c9db2e1d3c4f097e1e0b1988c7c6d2055755a93157efd0285b31e9281feefec93483ae77a8bd79782f167f419483735403bc46f9708568fb89d31f9b1b0dc1ceaa2d84de19d217738ccf275316a32b50f7e414df2ffb56868e6508abdb4b8d040a56146711b8883d47a48092001e34a89c5aa57381ca1254f167c6dc495
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15868);
 script_version ("1.1");
 name["english"] = "Hydra (NASL wrappers options)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin sets options for the Hydra(1) tests.
Hydra finds passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force authentication protocols";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SETTINGS);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");

 script_add_preference(name: "Logins file : ", value: "", type: "file");
 script_add_preference(name: "Passwords file : ", value: "", type: "file");
 script_add_preference(name: "Number of parallel tasks :", value: "16", type: "entry");
 script_add_preference(name: "Timeout (in seconds) :", value: "30", type: "entry");
 script_add_preference(name: "Try empty passwords", type:"checkbox", value: "no");
 script_add_preference(name: "Try login as password", type:"checkbox", value: "no");
 script_add_preference(name: "Exit as soon as an account is found", type:"checkbox", value: "no");
 script_add_preference(name: "Add accounts found by other plugins to login file",
	type:"checkbox", value: "yes");

 exit(0);
}

#

function mk_login_file(logins)
{
  local_var	tmp1,tmp2, dir, list, i, u;
  dir = get_tmp_dir();
  if (! dir) return logins;	# Abnormal condition
  for (i = 1; TRUE; i ++)
  {
    u = get_kb_item("SMB/Users/"+i);
    if (! u) break;
    list = strcat(list, u, '\n');
  }
# Add here results from other plugins
  if (! list) return logins;
  tmp1 = strcat(dir, 'tmp'+ rand());
  tmp2 = strcat(dir, 'tmp'+ rand());
  if (fwrite(data: list, file: tmp1) <= 0)	# File creation failed
    return logins;
  if (! logins) return tmp1;
  pread(cmd: "sort", argv: make_list("sort", "-u", tmp1, logins, "-o", tmp2));
  unlink(tmp1);
  return tmp2;
}


p = script_get_preference_file_location("Passwords file : ");
if (!p ) exit(0);
set_kb_item(name: "Secret/hydra/passwords_file", value: p);

# No login file is necessary for SNMP, VNC and Cisco; and a login file 
# may be made from other plugins results. So we do not exit if this
# option is void.
a = script_get_preference("Add accounts found by other plugins to login file");
p = script_get_preference_file_location("Logins file : ");
if ("no" >!< a) p = mk_login_file(logins: p);
set_kb_item(name: "Secret/hydra/logins_file", value: p);

p = script_get_preference("Timeout (in seconds) :");
t = int(p);
if (t <= 0) t = 30;
set_kb_item(name: "/tmp/hydra/timeout", value: t);

p = script_get_preference("Number of parallel tasks :");
t = int(p);
if (t <= 0) t = 16;
set_kb_item(name: "/tmp/hydra/tasks", value: t);

p = script_get_preference("Try empty passwords");
set_kb_item(name: "/tmp/hydra/empty_password", value: "yes" >< p);

p = script_get_preference("Try login as password");
set_kb_item(name: "/tmp/hydra/login_password", value: "yes" >< p);

p = script_get_preference("Exit as soon as an account is found");
set_kb_item(name: "/tmp/hydra/exit_ASAP", value: "yes" >< p);

