#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14389);
 script_bugtraq_id(10848);
 script_version ("$Revision: 1.4 $");
 if ( defined_func("script_xref") ) {
	script_xref(name:"OSVDB", value:"8287");
  }
 name["english"] = "FreeBSD Ports: ripmime < 1.3.2.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of ripmime which is older than 1.3.2.3.

ripmime is a utility which extracts files out of MIME encoded messages.
The remote version of ripmime may prematurely terminate decoding base64
encoded messages when encountering multiple blank lines in a row.

If the remote host is using an antivirus program which uses ripmime,
an attacker may exploit this flaw to inject viruses on the remote
network by sending specially crafted mime messages.


Solution : http://www.vuxml.org/freebsd/85e19dff-e606-11d8-9b0a-000347a4fa7d.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ripmime package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ripmime-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ripmime-1.3.2.3") < 0 ) 
	security_warning(0);
