#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12558);
 script_bugtraq_id(9712);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0158");
 name["english"] = "FreeBSD Ports : lbreakout2 < 2.2.2_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the lbreakout2 package which is
older than 2.2.2_1.

lbreakout2 is a game. The remote version of this software contains
several problems which may allow a local user to elevate his privileges
to obtain the 'games' group uid.

Solution : http://www.vuxml.org/freebsd/ad4f6ca4-6720-11d8-9fb5-000a95bc6fae.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of lbreakout2 packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^lbreakout2-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"lbreakout2-2.2.2_1") < 0 ) 
	security_warning(0);
