#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14594);
 script_bugtraq_id(11078, 11079);
 script_cve_id("CAN-2004-0642", "CAN-2004-0643", "CAN-2004-0644", "CAN-2004-0772");
 name["english"] = "FreeBSD Ports : krb5 <= 1.3.4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the krb5 package which is
older than or as old as  version 1.3.4.

There are two flaws in the remote version of this package :
- The ASN.1 decoder library is vulnerable to a denial of service
attack which may allow an attacker to crash the KDC remotely

- There is a double free vulnerability in the KDC which might allow an attacker
to execute arbitrary code remotely.

Solution : 
- http://www.vuxml.org/freebsd/86a98b57-fb8e-11d8-9343-000a95bc6fae.html
- http://www.vuxml.org/freebsd/bd60922b-fb8d-11d8-a13e-000a95bc6fae.html

Risk Factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^krb5-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"krb5-1.3.4") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
