#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15802);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 10609 );
 script_cve_id ("CAN-2004-0623");
 name["english"] = "FreeBSD Ports : gnats < 4.0_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

4.* <= gnats <= 4.0_2
gnats <= 3.113.1_9 

Gnats suffers from a format string bug, which may enable an  attacker to 
execute arbitary code.

Solution : http://www.vuxml.org/freebsd/fc99c736-3499-11d9-98a7-0090962cff2a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnats package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^gnats-[0-3]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnats-3.113.1_9") <= 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^gnats-4\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnats-4.0_2") <= 0  )
	{
	security_hole(0);
	exit(0);
	}
