#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12646);
 script_bugtraq_id(10672);
 script_version ("$Revision: 1.3 $");
 if ( defined_func("script_xref") ) {
	script_xref(name:"OSVDB", value:"7536");
 	script_xref(name:"OSVDB", value:"7537");
 	script_xref(name:"OSVDB", value:"7538");
 }
 script_cve_id("CAN-2004-0633", "CAN-2004-0634", "CAN-2004-0635");
 name["english"] = "FreeBSD Ports: ethereal < 0.10.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the ethereal package which is
older than 0.10.5.

ethereal is a powerful network sniffer which interprets packets
protocols. There are three flaws in the remote version of this software,
which may allow an attacker to disable it remotely by sending
malformed iSNS, SMB or SNMP packets.

Solution : http://www.vuxml.org/freebsd/265c8b00-d2d0-11d8-b479-02e0185c0b53.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ethereal-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"ethereal-0.10.5") < 0 ) 
	security_warning(0);
