#TRUSTED 3bac400464504ea62efb145f876c6dd74c9a05426a614eb77cb853ff10a5f6ab81173bb3b1bd10cc2e3154cd536796f69ffa9aa72e01bbd3e89e003c824a1f94fea62894df45d1a3a75eb65fd3d5a8a229eb609a8dc2cab1ad5f51c7195eb831546085535ee5fbafb9a47537a6ce6d5d01a4ba739351c52c97353c9ee65750e603e375cb15f9d40d5b66ea1d45a74786b9a77e5043798e8dafa289b4fa27fe36157e6f569c4ee2ab9a863cb5496aa5e8b89131bf95833aadc5fd9bdfb207f211ce4007ed07b24dbe063b80c7261a730d471f7ab874b0dc02626142d2afc1abd53486af6b20490c7c48da7aae2f921f348ff7bc1fcdecd8a7ae3ead595ebb81c318a5a2af6102e46e2753c1fef5a6bf478fd50512611b61e3ac2873a8d94d846662e445214a9a3f8c89d4da8678cff493f5507b066f2ec59b0eb0bdc548720c0a778dd2b0cf1267f7bdf379b25906482df26d0f72fa94c5dc9f98e09573fbdd4aab843afe4a2b11431fe503501685dda900226dc130847a1182d2040a6f1d9231e744020b73cb6dfeaf6f5212a0e40b24030351d89be45d56804c93faae17d3502cbdb13ff99e80029930b6bbf52d2bc0e48ff70e2b2415d1f61afc0462d3b91e8f4cbd5a73e435a57c41c0a5fde2c7f8bcb4dc45a780d7a8f8ab17bad557bd7aa644e7cd955910af154c78228fc1a41ec4acd2054062b85662896db441265b09
#
# (C) Tenable Network Security
#
# Modified by Nicolas Pouvesle to actually test for the bug
# actual test will *not* DoS dropbear
if (description) {
  script_id(14234);
  script_version("1.9");
  script_bugtraq_id(10803);

  if (defined_func("script_xref")) {
    script_xref(name:"OSVDB", value:"8137");
  }

  name["english"] = "Dropbear remote DSS SSH vuln";
  script_name(english:name["english"]);
 
  desc["english"] = "
The remote host is running Dropbear prior to version 0.43.  
There is a flaw in this version of Dropbear which would
enable a remote attacker to gain control of the system
from a remote location.

Solution : Upgrade to at least version 0.43 of Dropbear. 

See also : http://www.securityfocus.com/bid/10803 
 
Risk factor : High";
  script_description(english:desc["english"]);
 
  summary["english"] = "Dropbear remote DSS SSH vuln check";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) Tenable Network Security");
  family["english"] = "Gain root remotely";
  script_family(english:family["english"]);

  script_require_ports("Services/ssh", 22);
  script_dependencie("ssh_detect.nasl");
  exit(0);
}


include ('ssh_func.inc');

port = get_kb_item ("Services/ssh");
if (!port)
  port = 22;
if (!get_port_state (port))
  exit (0);

login = kb_ssh_login ();
pub = kb_ssh_publickey ();
priv = kb_ssh_privatekey ();
pass = kb_ssh_passphrase ();

if (login && pub && priv)
{
 soc = open_sock_tcp (port);
 if ( ! soc ) exit(0);
 ret = ssh_login (socket: soc, login: login, password: NULL, pub: pub, priv: priv, passphrase:pass);

 close (soc);

 if (ret == 0)
 {
	authenticated = 0;
  	socket = open_sock_tcp (port);
	if ( ! socket ) exit(0);
  	if (socket)
  	{
   		server_user = tolower (login);
   		init ();
   		server_version = ssh_exchange_identification (socket:socket);
   
   		# Like ssh_login has succeeded we don't need to test return
   		# It means SSH server is not vulnerable.
   		# However I prefer let if (!xxx) {close();exit()} ...

   		if (!server_version)
   		{
     			close (socket);
     			exit(0);
   		}
   
   		ret = ssh_kex2 (socket: socket, server_version:server_version);
   		if (ret!= 0)
   		{
     			close (socket);
     			exit(0);
   		}

   		payload = putstring (buffer:"ssh-userauth");
   		send_ssh_packet (socket: socket, payload: payload, code:raw_string (0x05));
   		payload = recv_ssh_packet (socket:socket);
   		if (ord (payload[0]) != 6)
   		{
     			close (socket);
     			exit(0);
   		}

   		payload = putstring (buffer: server_user) + putstring (buffer: "ssh-connection") + putstring (buffer:"none");
   		send_ssh_packet (socket: socket, payload: payload, code: raw_int8 (i:50));

   		payload = recv_ssh_packet (socket:socket);
   		if (ord (payload[0]) != 51)
   		{
     			close (socket);
     			exit(0);
   		}

   		support = getstring (buffer: payload, pos:1);
   		if (!ereg (string: support, pattern:"publickey"))
   		{
     			close (socket);
     			exit(0);
   		}

   		blobpub = base64decode (str:pub);
   		payload = putstring (buffer: server_user) + putstring (buffer: "ssh-connection") + putstring (buffer: "publickey") + raw_int8 (i:1);
   		to_hash = putstring (buffer: session_id) + raw_int8 (i:50);
   		typestr = getstring (buffer: blobpub, pos:0);

   		### We must not quit here because user provide a RSA key !!!
   		if (typestr >< "ssh-dss")
   		{
    			next = 4 + strlen (typestr);
    			p = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (p);
    			q = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (q);
    			g = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (g);
    			pub_key = getstring (buffer: blobpub, pos:next);
    			privkey = pem_to_dsa (priv: priv, passphrase:passphrase);
    			if (!privkey)
    			{
      				close (socket);
      				exit(0);
    			}

    			payload += putstring (buffer: "ssh-dss") + putstring (buffer:blobpub);
    			to_hash += payload;
    			hash = SHA1 (to_hash);
    			signature = dsa_do_sign (p: p, q: q, g: g, pub: pub_key, priv: privkey, data:hash);
 
    			if (!signature)
    			{
      				close (socket);
      				exit(0);
    			}
           
    			signature = putstring (buffer: "ssh-dss") + crap (data: raw_string (0x00), length:44);
    			payload += putstring (buffer:signature);
    			send_ssh_packet (socket: socket, payload: payload, code: raw_int8 (i:50));
    			payload = recv_ssh_packet (socket:socket);

    			if (strlen (payload) > 1)
      				authenticated = 1;
            
    			close (socket);
           
    			if (!authenticated)
     				security_hole (port);
    			exit(0);
   		}
  	}
 }
  close (socket);
}


##### If we can not test flaw, we can test banner ######

#[root@f00dikator dropbear-0.43]# telnet localhost 22
#Trying 127.0.0.1...
#Connected to localhost.
#Escape character is '^]'.
#SSH-2.0-dropbear_0.43

banner = get_kb_item("SSH/banner/" + port );

if (! banner)
  exit(0);

  desc = "
The remote host is running Dropbear prior to version 0.43.  
There is a flaw in this version of Dropbear which would
enable a remote attacker to gain control of the system
from a remote location.

*** Nessus reports this vulnerability using only
*** information that was gathered. To really test
*** the vulnerability Nessus need an SSH account with
*** correct dsa keys.

Solution : Upgrade to at least version 0.43 of Dropbear. 

See also : http://www.securityfocus.com/bid/10803 
 
Risk factor : High";

# version 0.28 thru 0.42 are vulnerable
if (egrep(string:banner, pattern:"-dropbear_0\.(2[89]|3[0-9]|4[0-2])") )
	security_hole(port:port, data:desc);

