#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12582);
 script_bugtraq_id(9641);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0078");
 name["english"] = "FreeBSD Ports : mutt < 1.4.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of mutt (or ja-mutt) installed.

mutt is a mail user agent. There is a buffer overflow in the remote version
of this software which may allow an attacker to prevent a mutt user on this
system from reading his mail, and possibly to execute arbitrary code with
the privileges of a mutt user.

To exploit this flaw, an attacker would need to send a specially crafter
email message to a victim on this system, and wait for him to use mutt
to read his mailbox.

Solution : http://www.vuxml.org/freebsd/67c05283-5d62-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mutt", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mutt-1.4.2") < 0 ) 
	security_hole(0);

package = egrep(pattern:"^ja-mutt", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ja-mutt-1.4.2") < 0 ) 
	security_hole(0);
