#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15804);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : horde < 2.2.7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

horde < 2.2.7
horde-devel < 2.2.7

A Horde Team announcement states that a potential cross-site  scripting 
vulnerability in the help window has been  corrected. The vulnerability 
appears to involve the handling  of the topic and module parameters of 
the help window template.

Solution : http://www.vuxml.org/freebsd/ed1d404d-2784-11d9-b954-000bdb1444a4.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the horde package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^horde-[0-2]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"horde-2.2.7") < 0  )
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^horde-devel-[0-2]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"horde-devel-2.2.7") < 0  )
	{
	security_warning(0);
	exit(0);
	}
