#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15797);
 script_version ("$Revision: 1.1 $");
 script_cve_id ( "CAN-2004-0940" );
 name["english"] = "FreeBSD Ports : apache < 1.3.33";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

apache < 1.3.33
apache+mod_ssl < 1.3.32+2.8.21_1
apache+mod_ssl+ipv6 < 1.3.32+2.8.21_1
apache+mod_perl <= 1.3.31
apache+ipv6 < 1.3.33
apache+ssl <= 1.3.29.1.55
ru-apache < 1.3.33+30.21
ru-apache+mod_ssl < 1.3.33+30.21+2.8.22

There is a buffer overflow in a function used by mod_include  that may enable 
a local user to gain privileges of a httpd  child. Only users that are able to 
create SSI documents can  take advantage of that vulnerability.

Solution : http://www.vuxml.org/freebsd/6e6a6b8a-2fde-11d9-b3a2-0050fc56d258.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^apache-1.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache-1.3.33") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^apache+mod_ssl-1.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+mod_ssl-1.3.32+2.8.12_1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^apache+mod_ssl+ipv6", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+mod_ssl+ipv6-1.3.32+2.8.12_1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^apache+mod_perl", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+mod_perl-1.3.31") <= 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^apache+ipv6", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+ipv6-1.3.33") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^apache+ssl", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache+ssl-1.3.29.1.55") <= 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^ru-apache-1\.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ru-apache-1.3.33+30.21") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^ru-apache+mod_ssl-1\.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ru-apache+mod_ssl+1.3.33+30.21+2.8.22") < 0  )
	{
	security_hole(0);
	exit(0);
	}
