#
# (C) Tenable Network Security
#

if(description)
{
 script_id(13855);
 script_version("$Revision: 1.4 $");

 name["english"] = "Installed Windows Hotfixes";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script enumerates the list of installed hotfixes on the remote host
and store them in the knowledge base for the other SMB scripts to use, to
avoid useless connections to the remote registry.

This script required credentials to log into the remote host.";


 script_description(english:desc["english"]);
 
 summary["english"] = "Fills the KB with the list of installed hotfixes";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl", "smb_login.nasl","smb_registry_full_access.nasl", "smb_reg_service_pack.nasl","smb_reg_service_pack_W2K.nasl", "smb_reg_service_pack_XP.nasl");
 if ( defined_func("bn_random") ) script_dependencies("ssh_get_info.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",  "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}

if ( get_kb_item("SMB/samba") ) exit(0);
if ( get_kb_item("SMB/Registry/Enumerated") ) exit(0);
include("smb_nt.inc");

global_var handle;

function crawl(key, level, maxlevel)
{
 local_var mylist, entries, l, list;
 list = make_list();
 entries = make_list();

 if ( level >= maxlevel ) return make_list();

 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
 if(key_h)
 {
  entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
  registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 }

 foreach l (entries)
  {
  list = make_list(list, key + "\" + l );
  }


 entries = make_list();
 foreach l (list)
 {
  entries = make_list(entries, crawl(key:l, level:level + 1, maxlevel:maxlevel));
 }

 return make_list(list, entries);
}


x_name = kb_smb_name();
if(!x_name)exit(0);

_smb_port = kb_smb_transport();
if(!_smb_port)exit(0);

if(!get_port_state(_smb_port)) exit(0);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

if(!login)login = "";
if(!pass) pass = "";

	  
soc = open_sock_tcp(_smb_port);
if(!soc) exit(0);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:x_name);
if(!r) { close(soc); exit(0); }

#
# Negociate the protocol
#
prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); exit(0); }


r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r){ close(soc); exit(0); }
uid = session_extract_uid(reply:r);

r = smb_tconx(soc:soc, name:x_name, uid:uid, share:"IPC$");
tid = tconx_extract_tid(reply:r);
if(!tid){ close(soc); exit(0); }


r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
if(!r){ close(soc); exit(0);}
pipe = smbntcreatex_extract_pipe(reply:r);

r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r){ close(soc); exit(0); }
handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);


location1 = "SOFTWARE\Microsoft\Updates";
location2 = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix";

list = make_list(crawl(key:location1, level:0, maxlevel:3), 
	         crawl(key:location2, level:0, maxlevel:1));
		 
if ( max_index(list) > 0 )
{
  set_kb_item(name:"SMB/Registry/Enumerated", value:TRUE);
}
foreach l ( list ) 
{
 l = str_replace(find:"\", replace:"/", string:l);
 name = "SMB/Registry/HKLM/" + l;
 # Maybe we want to improve that in Nessus 2.1.x by storing everything as a huge string...
 set_kb_item(name:name, value:TRUE);
}



#
# Check for common registry values other plugins are likely to look at
# 
key = "SYSTEM\CurrentControlSet\Control\ProductOptions";
item = "ProductType";

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 data = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 value = registry_decode_sz(data:data);
 registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 if ( value ) set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions", value:value);
}


key = "SYSTEM\CurrentControlSet\Services\W3SVC";
item = "ImagePath";

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 data = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 value = registry_decode_sz(data:data);
 registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe,  reply:key_h);
 if ( value ) set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/W3SVC/ImagePath", value:value);
}

key = "SOFTWARE\Microsoft\DataAccess";
item = "Version";

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 data = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 if ( data ) value = registry_decode_sz(data:data);
 registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe,  reply:key_h);
 if ( value ) set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/DataAccess/Version", value:value);
}

key = "SOFTWARE\Microsoft\Exchange\Setup";
item = "ServicePackBuild";

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 data = registry_get_item_dword(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 if ( data ) value = registry_decode_dword(data:data);
 registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe,  reply:key_h);
 if ( value ) set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/Exchange/Setup/ServicePackBuild", value:value);
}


key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
 data = registry_get_item_dword(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
 if ( data ) value = registry_decode_dword(data:data);
 registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe,  reply:key_h);
 if ( value ) set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/WINS/DisplayName", value:value);
}
