#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12001);
 script_version("$Revision: 1.3 $");

 name["english"] = "SaveNOW detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the SaveNOW program.  
You should ensure that:
- the user intended to install SaveNOW (it is sometimes silently installed)
- the use of SaveNOW matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check
out ad-aware or spybot. 

Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "SaveNOW detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");
# start the script

key = "Software\Microsoft\Windows\CurrentVersion\Run";
item = "SaveNow";
regx = "SaveNow";

value = registry_get_sz(key:key, item:item);
if ( regx >< value ) { security_hole(kb_smb_transport()); exit(0); }

path[1] = "Software\Microsoft\Windows\CurrentVersion\WhenUSave";

path[2] = "software\classes\clsid\{08351226-6472-43bd-8a40-d9221ff1c4ce}";
path[3] = "software\classes\clsid\{9f95f736-0f62-4214-a4b4-caa6738d4c07}";
path[4] = "software\classes\interface\{c285d18d-43a2-4aef-83fb-bf280e660a97}";
path[5] = "software\microsoft\windows\currentversion\uninstall\savenow";
path[6] = "software\whenusave";


if ( ! get_kb_item("SMB/registry_access") ) exit(0);

for (i=1; path[i]; i++) {
       val = registry_key_exists(key:path[i]);
       if(val != NULL) { display(path[i], "\n"); security_hole(kb_smb_transport()); exit(0); } 
}


