#
# (C) Tenable Network Security
#

if(description)
{
 script_id(15779);

 script_version("$Revision: 1.1 $");
 name["english"] = "phpBB Detection";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin detects if the phpBB bulletin board system is installed
on the remote host and stores its location and version in the KB.

See also : http://www.phpbb.org
Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for phpBB version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

function check(dir)
{
  req = http_get(item:dir + "/index.php", port:port);
  buf = http_keepalive_send_recv(port:port, data:req);
  if(buf == NULL)exit(0);

  line = egrep(pattern:"Powered by .*phpBB.*", string:buf);
  if ( line )
  	{
        line = chomp(line);
	version = ereg_replace(pattern:".*Powered by.*phpBB</a> ([0-9\.]*)", string:line, replace:"\1");
	if ( version == line ) version = "unknown";
        if ( version )
	{
	 if ( dir == "" ) dir = "/";
	 set_kb_item(name:"www/" + port + "/phpBB", value:version + " under " + dir);
	 security_note( port:port, data:'The remote host is running phpBB ' + version + ' under ' + dir);
	}
   }
 return(0);
}

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);



foreach dir (make_list("/phpBB", cgi_dirs()))
{
 check(dir:dir);
}
