#TRUSTED 5a42f16264df66d01522b4e9d24dd85888e7b67c1af4af76b4c5fca2e5a5ab4cb20f82b5a50fc1c823e0b98666daeeaad312a1b533e5bbd2deb1ad23867bccedbb6ff3e073d0ce7063ac8785d7544b53ed235bc3af2ec8df5b75733133e171947ad2f2291c5be12edb5d9fa537f5d341c142dc93498784b5d49ef9affcdd1cd7fe01b05046e79452e6b6b2b314282aa8f6e730998001403e9d3374b861dce802ebac960207c3a208774f3adb2734803b26eb8d2bef22db4163d4618c90d012449c2704259c2ad49fee314f6b877e39753be942cd5e274ccbcae6d5ecd9bb69c7eaebbbe8a69ec1e130a6a875b83a85561b0b265107d0baa9e12dd8441416f627f18c6b507102404b32d11a537d01fd18755f29c34069cafd4734ee647b87ccd2c04d53959930ab76b30a92cdf9dc88068beb9ab024fd8c153e53417910dc023a132d394c636e688f36878f3a74586c5c88f315e9a4d9d4a4574a90607d839fd55fb34149aef26c9c9d93873e202a85b6f6449dca519351e2156e53829de64b20b1900f0b5f71ecc1ba771b12bb2f4380ebae9c4067f6d2074b7bcd6bf9c17c9723a8068bb5eefb5e0edfd59b745ff254b813fea61fa39f1fd2c5cf7c771b02538f82280f56d11376ca56257abfc701a22b0122db41c3a509ae4e3c7ddd96737f235f9a3120f5076a0af0d22ad1ad22600097c36db9150cfc37a0e67e8195fe29
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread")) exit(0);
if ( ! find_in_path("nikto.pl") ) exit(0);


if(description)
{
 script_id(14260);
 script_version ("1.5");
 name["english"] = "Nikto (NASL wrapper)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs nikto(1) to find CGI.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find CGI with Nikto";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("find_service.nes", "httpver.nasl", "logins.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

 script_add_preference(name:"Force scan all possible CGI directories",
                       type:"checkbox", value:"no");
 script_add_preference(name:"Force full (generic) scan", 
                      type:"checkbox", value:"no");
 exit(0);
}

#

if (! defined_func("pread"))
{
  set_kb_item(name: "/tmp/UnableToRun/14254", value: TRUE);
  display("Script #14254 (nikto_wrapper) cannot run\n");
  exit(0);
}

user = get_kb_item("http/login");
pass = get_kb_item("http/login");
ids = get_kb_item("/Settings/Whisker/NIDS");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

# Nikto will generate many false positives if the web server is broken
no404 = get_kb_item("www/no404/" + port);
if (no404 || no404 !~ '^[ \t\n\r]*$') exit(0);

i = 0;
argv[i++] = "nikto.pl";

httpver = get_kb_item("http/"+port);
if (httpver == "11")
{
  argv[i++] = "-vhost";
  argv[i++] = get_host_name();
}

argv[i++] = "-h"; argv[i++] = get_host_ip();
argv[i++] = "-p"; argv[i++] = port;

encaps = get_port_transport(port);
if (encaps > 1) argv[i++] = "-ssl";

p = script_get_preference("Force scan all possible CGI directories");
if ("yes" >< p) argv[i++] = "-allcgi";
p = script_get_preference("Force full (generic) scan");
if ("yes" >< p) argv[i++] = "-gener";

if (idx && idx != "X")
{
  argv[i++] = "-evasion";
  argv[i++] = ids[0];
}

if (user)
{
  if (pass)
    s = strcat(user, ':', pass);
  else
    s = user;
  argv[i++] = "-id";
  argv[i++] = s;
}

r = pread(cmd: "nikto.pl", argv: argv, cd: 1);
if (! r) exit(0);	# error

report = 'Here is the Nikto report:\n';
foreach l (split(r))
{
  display(j ++, "\n");
  l = ereg_replace(string: l, pattern: '^[ \t]+', replace: '');
  if (l[0] == '+' || l[0] == '-' || ! match(pattern: "ERROR*", string: l))
    report += l;
}

security_note(port: port, data: report);
