#
#  (C) Tenable Network Security
#

if(description)
{
 script_id(15821);
 script_bugtraq_id(11726);
 script_cve_id("CAN-2004-1029");
 script_version("$Revision: 1.2 $");

 name["english"] = "Sun JRE Java Plug-in JavaScript Security Restriction Bypass";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using a vulnerable version of Sun Java Runtime
Plug-in, an addon to many web browser like Internet Explorer to
display java applets.

It has been reported that the Java JRE Plug-in Security can be bypassed.
As a result, an attacker may be able to exploit it by creating a malicious
Java applet to compromise the computer.

Solution: Upgrade to JRE 1.4.2_06 or 1.3.1_13
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Java JRE plugin";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");
port = get_kb_item("SMB/transport");
if(!port)port = 139;


version = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer\AdvancedOptions\JAVA_SUN\SELECT", item:"Text");
if (version)
{
  if(egrep(pattern:"^Use JRE 1\.(3\.(0.*|1[^_].*|1_[0-9][^0-9].*|1_1[0-2].*)|4\.([0-1]\..*|2_0[0-5].*)) for", string:version))
  {
    security_hole(port);
    exit(0);
  }
}


		
