# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200411-36.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(15840);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200411-36");
 script_cve_id("CAN-2004-1055");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200411-36
(phpMyAdmin: Multiple XSS vulnerabilities)


    Cedric Cochin has discovered multiple cross-site scripting
    vulnerabilities in phpMyAdmin. These vulnerabilities can be exploited
    through the PmaAbsoluteUri parameter, the zero_rows parameter in
    read_dump.php, the confirm form, or an error message generated by the
    internal phpMyAdmin parser.
  
Impact

    By sending a specially-crafted request, an attacker can inject and
    execute malicious script code, potentially compromising the victim\'s
    browser.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2004-1055
    http://www.phpmyadmin.net/home_page/security.php?issue=PMASA-2004-3
    http://www.netvigilance.com/html/advisory0005.htm


Solution: 
    All phpMyAdmin users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/phpmyadmin-2.6.0_p3"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200411-36] phpMyAdmin: Multiple XSS vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'phpMyAdmin: Multiple XSS vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/phpmyadmin", unaffected: make_list("ge 2.6.0_p3"), vulnerable: make_list("lt 2.6.0_p3")
)) { security_warning(0); exit(0); }
