#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12630);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : zh-cce < 0.40";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of zh-cce installed.

zh-cce is a chinese console software. It contains several exploitable
buffer overflows which may allow a local user to gain superuser privileges.

Solution : http://www.vuxml.org/freebsd/a736deab-5d7d-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^zh-cce", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"zh-cce-0.40") < 0 ) 
	security_hole(0);

