#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12610);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0426");
 name["english"] = "FreeBSD Ports : rsync < 2.6.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of rsync installed.

If rsync is run in daemon mode, an attacker may abuse this service to read or
write outside of a module path, thus gaining access to the filesystem of the
remote host.

Solution : http://www.vuxml.org/freebsd/73ea0706-9c57-11d8-9366-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rsync package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^rsync", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"rsync-2.6.1") < 0 ) 
	security_hole(0);
