#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15865);
 script_bugtraq_id(11734);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports: prozilla <= 1.3.6_3 ";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following package(s) installed :

prozilla <= 1.3.6_3

prozilla is a download accelerator. The remote version of this software
contains several buffer overflow vulnerabilities which may allow an attacker
to execute arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/1a32e8ee-3edb-11d9-8699-00065be4b5b6.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the prozilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^prozilla-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"prozilla-1.3.6_3") <= 0 ) 
	security_hole(0);
