#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12604);
 script_bugtraq_id(10252);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0432");
 name["english"] = "FreeBSD Ports : ProFTPD < 1.2.10r1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of ProFTPD installed.

ProFTPD is an alternative FTP server. There is a bug in the remote version
of ProFTPd which breaks the handling of ACLs.

Solution : http://www.vuxml.org/freebsd/cb6c6c29-9c4f-11d8-9366-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the proftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^proftpd", string:pkgs);
if ( ! package ) exit(0);

if ( pkg_cmp(pkg:package, reference:"proftpd-1.2.9") >= 0 &&
     pkg_cmp(pkg:package, reference:"proftpd-1.2.10.r1") ) 
	security_warning(0);
