#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12597);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : phpnuke < 6.9";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the package phpnuke installed.

There is a design error in the installed version of this software which
may allow an attacker to execute arbitrary SQL commands on the database
php-nuke is connected to, by using SQL injections vulnerabilities in the
php-nuke installation.

Solution : Disable PHP-Nuke. Do not use this software, it's insecure.
See also : http://www.vuxml.org/freebsd/75770425-67a2-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpnuke package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^phpnuke-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"phpnuke-6.9_1") < 0 ) 
	security_hole(0);
