#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15574);
 script_bugtraq_id(11391);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : phpMyAdmin < 2.6.0.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of phpMyAdmin installed (older than 2.6.0.2)

phpMyAdmin is a set of PHP-scripts to administer a MySQL database over the web.
The remote version of this software is vulnerable to arbitrary
command execution due to a lack of user-supplied data
sanitization.


Solution : http://www.vuxml.org/freebsd/fc07c9ca-22ce-11d9-814e-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpMyAdmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^phpMyAdmin-", string:pkgs, icase:TRUE);

if ( package && pkg_cmp(pkg:package, reference:"phpMyAdmin-2.6.0.2") < 0 ) 
	security_hole(0);
