#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12571);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : mathopd < 1.4p2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mathopd package installed.

mathopd is a web server. There is a flaw in the remote version of this software
which may allow an attacker to execute arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/96fdbf5b-2cfd-11d8-9355-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mathopd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mathopd", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mathopd-1.4p2") < 0 ) 
	security_hole(0);
