#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14813);
 script_bugtraq_id(10354);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0694", "CAN-2004-0745", "CAN-2004-0769", "CAN-2004-0771");
 name["english"] = "FreeBSD Ports : lha < 1.14i_6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the LHA package which is older
than 1.14i_6.

LHA is an archiving and compression utility for LHarc format archives.

There are multiple flaws affecting the remote version of this package
which may allow an attacker to execute arbitrary code on the remote host.

To exploit these flaws, an attacker would need to a send a specially crafted
lha archive to a victim on the remote host and wait for him to uncompress
it using the lha utility.


Solution : http://www.vuxml.org/freebsd/273cc1a3-0d6b-11d9-8a8a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lha package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^lha-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"lha-1.14i_6") < 0 ) 
	security_hole(0);
