#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12553);
 script_bugtraq_id(10192);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0408");
 name["english"] = "FreeBSD Ports : ident2 <= 1.04";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the ident2 package which is older
than 1.04_1.

ident2 is an RFC1413 server. The remote version of this software contains
a double byte buffer overflow which may allow an attacker to execute
arbitrary code on this host, with the privileges of the ident2 daemon
(usually 'nobody' in the group id 'wheel').

Solution : http://www.vuxml.org/freebsd/99230277-8fb4-11d8-8b29-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ident2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ident2-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"ident2-1.04_1") < 0 ) 
        security_hole(0);
