#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14384);
 script_bugtraq_id(10864);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0494");
 name["english"] = "FreeBSD Ports : gnome-vfs2 < 2.6.2_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the gnome-vfs or mc packages installed.

Gnome VFS is the GNOME virtual file system, which provides a modular 
architecture and ships with modules that implement support for file systems,
HTTP, FTP and more.

mc is a console-based file manager.

There is a flaw in the remote version of this software which fails to properly
validate user-supplied input. As a result, if an attacker can cause a victim
to process a specially crafted URI, he can get the ability to execute arbitrary
commands on  the remote host.

Solution : http://www.vuxml.org/freebsd/7884d56f-f7a1-11d8-9837-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnome-vfs and mc packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^gnomevfs-1\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnomevfs-1.0.5_6") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
package = egrep(pattern:"^gnomevfs2-2\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gnomevfs2-2.6.2_1") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }

package = egrep(pattern:"^mc-[0-4]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mc-4.6.0_12") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
