#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15489);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id(11224);
 script_cve_id("CAN-2004-0881");
 name["english"] = "FreeBSD Ports : getmail < 3.2.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has version of the 'getmail' package which is older than version
3.2.5.

getmail is a POP3 mail retriever with reliable Maildir/command delivery.

There is a flaw in the remote version of this software which may allow a local
user to force it to write to arbitrary files using a symlink attack.

Solution : http://www.vuxml.org/freebsd/8c33b299-163b-11d9-ac1b-000d614f7fad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the getmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^getmail-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"getmail-3.55") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
