#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14762);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0809");
 name["english"] = "FreeBSD Ports : Apache < 2.0.50_3 / mod_dav <= 1.0.3_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

2.0 <= apache < 2.0.50_3
       mod_dav <= 1.0.3_1


There is a flaw in the remote version of these packages which may allow
an attacker to crash the httpd process remotely

Solution : http://www.vuxml.org/freebsd/013fa252-0724-11d9-b45d-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache-2", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"apache-2.0.48_4") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^mod_dav-[0-9]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"mod_dav-1.0.3_1") <= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
