#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12522);
 script_bugtraq_id(9735);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0169");
 name["english"] = "FreeBSD Ports : DarwinStreamingServer < 4.1.3g";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the DarwinStreamingServer package 
which is older than 4.1.3g

Darwin Streaming Server is a MP3, MPEG4 and Quicktime streaming server. 
There is a flaw in this software which may allow an attacker to cause
this program to exit remotely, thus creating a denial of service.

Solution : http://www.vuxml.org/freebsd/c7cad0f0-671a-11d8-bdeb-000a95bc6fae.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the DarwinStreamingServer package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^DarwinStreamingServer-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"DarwinStreamingServer-4.1.4") < 0 ) 
	security_warning(0);
