#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12612);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : seti@home < 3.0.8";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of seti@home installed.

seti@home is a program which donates CPU cycle to the search for space aliens.
There is a buffer overflow in the code of this program which handles HTTP
responses. To exploit this flaw, an attacker would need to spoof a seti@home
server and send malformed replies to HTTP requests sent by this program.

Solution : http://www.vuxml.org/freebsd/0e154a9c-5d7a-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the seti@home package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^setiathome-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"setiathome-3.08") < 0 ) 
	security_hole(0);

