#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12537);
 script_bugtraq_id(9952);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0176", "CAN-2004-0365", "CAN-2004-0367");
 name["english"] = "FreeBSD Ports: ethereal < 0.10.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the ethereal package which is
older than 0.10.3.

ethereal is a powerful network sniffer which interprets packets
protocols. There are several flaws in the remote version of 
this software when it decodes the following protocols :

- NetFlow
- IGAP
- EIGRP
- PGM
- IRDA
- BGP
- ISUP
- TCAP
- UCP
- RADIUS

An exploited could exploit these flaws to execute arbitrary code
on this host, with the superuser privileges. To exploit this flaw,
an attacker would need to send a specially crafted packet of the
kind of any of the protocols above to the remote host, while a user
runs ethereal to capture traffic.


Solution : http://www.vuxml.org/freebsd/cdf18ed9-7f4a-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ethereal-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"ethereal-0.10.3") < 0 ) 
	security_hole(0);
