/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999



#ifndef _MUSIC_H
#define _MUSIC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_SMPEG
#include <smpeg/smpeg.h>
#endif

#include "sound.h"

#include <string>

namespace uta {

///
class Music : public Sound
{

public:

  ///
  Music();
private:
  /// This doesn't exist
  Music(const Music&);
public:
  ///
  Music(const std::string& );
  ///
  virtual ~Music();
  
  ///
  virtual bool load(const std::string&);  
  ///
  virtual bool play(int loops = 0) const;

  /// set volume (0..100)
  virtual int setVolume(int vol);  
  ///
  virtual void stop() const;
  ///
  virtual bool playing() const;
  ///
  virtual bool paused() const;
  ///
  virtual void pause() const;
  ///
  virtual void rewind() const;
  ///
  virtual void resume() const;
    
 protected:

  ///
  int channel_;
  ///
  static int volume_;

#ifdef HAVE_MIXER
  ///
  Mix_Music* data_;
#ifdef HAVE_SMPEG
  ///
  SMPEG* mpeg;
#else
  void* mpeg;
#endif

#endif

};

}

#endif
