/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class ButtonBorder
extends SchemeBorder {
    public static final Border BUTTON = new ButtonBorder(SCHEMES.BUTTON);
    public static final Border BUTTON_CONTRAST = new ButtonBorder(SCHEMES.BUTTON_CONTRAST);
    public static final Border BUTTON_SCROLLBAR = new ButtonBorder(SCHEMES.BUTTON_SCROLLBAR);
    public static final Border TOOLBAR = new ButtonBorder(SCHEMES.TOOLBAR);

    public ButtonBorder() {
        this.setScheme(SCHEMES.BUTTON);
    }

    public ButtonBorder(ButtonScheme scheme) {
        this.setScheme(scheme);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Color[] br;
        Color[] tl;
        Clickable clickable = (Clickable)figure;
        ButtonModel model = clickable.getModel();
        ButtonScheme colorScheme = (ButtonScheme)this.getScheme();
        if (clickable.isRolloverEnabled() && !model.isMouseOver() && !model.isSelected()) {
            return;
        }
        if (model.isSelected() || model.isArmed()) {
            tl = colorScheme.getShadowPressed();
            br = colorScheme.getHighlightPressed();
        } else {
            tl = colorScheme.getHighlight();
            br = colorScheme.getShadow();
        }
        this.paint(graphics, figure, insets, tl, br);
    }

    public static class ButtonScheme
    extends SchemeBorder.Scheme {
        private Color[] highlightPressed = null;
        private Color[] shadowPressed = null;

        public ButtonScheme(Color[] highlight, Color[] shadow) {
            this.highlight = highlight;
            this.highlightPressed = highlight;
            this.shadow = shadow;
            this.shadowPressed = shadow;
            this.init();
        }

        public ButtonScheme(Color[] hl, Color[] sh, Color[] hlp, Color[] shp) {
            this.highlight = hl;
            this.shadow = sh;
            this.highlightPressed = hlp;
            this.shadowPressed = shp;
            this.init();
        }

        protected Insets calculateInsets() {
            int br = 1 + Math.max(this.getShadow().length, this.getHighlightPressed().length);
            int tl = Math.max(this.getHighlight().length, this.getShadowPressed().length);
            return new Insets(tl, tl, br, br);
        }

        protected boolean calculateOpaque() {
            if (!super.calculateOpaque()) {
                return false;
            }
            if (this.getHighlight().length != this.getShadowPressed().length) {
                return false;
            }
            if (this.getShadow().length != this.getHighlightPressed().length) {
                return false;
            }
            Color[] colors = this.getHighlightPressed();
            int i = 0;
            while (i < colors.length) {
                if (colors[i] == null) {
                    return false;
                }
                ++i;
            }
            colors = this.getShadowPressed();
            i = 0;
            while (i < colors.length) {
                if (colors[i] == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected Color[] getHighlightPressed() {
            return this.highlightPressed;
        }

        protected Color[] getShadowPressed() {
            return this.shadowPressed;
        }
    }

    public static interface SCHEMES {
        public static final ButtonScheme BUTTON_CONTRAST = new ButtonScheme(new Color[]{ColorConstants.button, ColorConstants.buttonLightest}, SchemeBorder.DARKEST_DARKER);
        public static final ButtonScheme BUTTON = new ButtonScheme(new Color[]{ColorConstants.buttonLightest}, SchemeBorder.DARKEST_DARKER);
        public static final ButtonScheme TOOLBAR = new ButtonScheme(new Color[]{ColorConstants.buttonLightest}, new Color[]{ColorConstants.buttonDarker});
        public static final ButtonScheme BUTTON_SCROLLBAR = new ButtonScheme(new Color[]{ColorConstants.button, ColorConstants.buttonLightest}, SchemeBorder.DARKEST_DARKER, new Color[]{ColorConstants.buttonDarker}, new Color[]{ColorConstants.buttonDarker});
    }
}

