require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&TI_PCI_ID)) {
    sub TI_PCI_ID () {	 &PCI_ID_REG;}
}
unless(defined(&TI_PCI_CMDSTAT)) {
    sub TI_PCI_CMDSTAT () {	 &PCI_COMMAND_STATUS_REG;}
}
unless(defined(&TI_PCI_CLASSCODE)) {
    sub TI_PCI_CLASSCODE () {	 &PCI_CLASS_REG;}
}
unless(defined(&TI_PCI_BIST)) {
    sub TI_PCI_BIST () {	 &PCI_BHLC_REG;}
}
unless(defined(&TI_PCI_LOMEM)) {
    sub TI_PCI_LOMEM () {	 &PCI_MAPS;}
}
unless(defined(&TI_PCI_SUBSYS)) {
    sub TI_PCI_SUBSYS () {	 &PCI_SUBVEND_0;}
}
unless(defined(&TI_PCI_ROMBASE)) {
    sub TI_PCI_ROMBASE () {	0x30;}
}
unless(defined(&TI_PCI_INT)) {
    sub TI_PCI_INT () {	 &PCI_INTLINE;}
}
unless(defined(&TI_MISC_HOST_CTL)) {
    sub TI_MISC_HOST_CTL () {	0x40;}
}
unless(defined(&TI_MISC_LOCAL_CTL)) {
    sub TI_MISC_LOCAL_CTL () {	0x44;}
}
unless(defined(&TI_SEM_AB)) {
    sub TI_SEM_AB () {	0x48;}
}
unless(defined(&TI_MISC_CONF)) {
    sub TI_MISC_CONF () {	0x50;}
}
unless(defined(&TI_TIMER_BITS)) {
    sub TI_TIMER_BITS () {	0x54;}
}
unless(defined(&TI_TIMERREF)) {
    sub TI_TIMERREF () {	0x58;}
}
unless(defined(&TI_PCI_STATE)) {
    sub TI_PCI_STATE () {	0x5c;}
}
unless(defined(&TI_MAIN_EVENT_A)) {
    sub TI_MAIN_EVENT_A () {	0x60;}
}
unless(defined(&TI_MAILBOX_EVENT_A)) {
    sub TI_MAILBOX_EVENT_A () {	0x64;}
}
unless(defined(&TI_WINBASE)) {
    sub TI_WINBASE () {	0x68;}
}
unless(defined(&TI_WINDATA)) {
    sub TI_WINDATA () {	0x6c;}
}
unless(defined(&TI_MAIN_EVENT_B)) {
    sub TI_MAIN_EVENT_B () {	0x70;}
}
unless(defined(&TI_MAILBOX_EVENT_B)) {
    sub TI_MAILBOX_EVENT_B () {	0x74;}
}
unless(defined(&TI_TIMERREF_B)) {
    sub TI_TIMERREF_B () {	0x78;}
}
unless(defined(&TI_SERIAL)) {
    sub TI_SERIAL () {	0x7c;}
}
unless(defined(&TI_MHC_INTSTATE)) {
    sub TI_MHC_INTSTATE () {	0x1;}
}
unless(defined(&TI_MHC_CLEARINT)) {
    sub TI_MHC_CLEARINT () {	0x2;}
}
unless(defined(&TI_MHC_RESET)) {
    sub TI_MHC_RESET () {	0x8;}
}
unless(defined(&TI_MHC_BYTE_SWAP_ENB)) {
    sub TI_MHC_BYTE_SWAP_ENB () {	0x10;}
}
unless(defined(&TI_MHC_WORD_SWAP_ENB)) {
    sub TI_MHC_WORD_SWAP_ENB () {	0x20;}
}
unless(defined(&TI_MHC_MASK_INTS)) {
    sub TI_MHC_MASK_INTS () {	0x40;}
}
unless(defined(&TI_MHC_CHIP_REV_MASK)) {
    sub TI_MHC_CHIP_REV_MASK () {	0xf0000000;}
}
unless(defined(&TI_MHC_BIGENDIAN_INIT)) {
    sub TI_MHC_BIGENDIAN_INIT () {	( &TI_MHC_BYTE_SWAP_ENB| &TI_MHC_WORD_SWAP_ENB| &TI_MHC_CLEARINT);}
}
unless(defined(&TI_MHC_LITTLEENDIAN_INIT)) {
    sub TI_MHC_LITTLEENDIAN_INIT () {	( &TI_MHC_WORD_SWAP_ENB| &TI_MHC_CLEARINT);}
}
unless(defined(&TI_REV_TIGON_I)) {
    sub TI_REV_TIGON_I () {	0x40000000;}
}
unless(defined(&TI_REV_TIGON_II)) {
    sub TI_REV_TIGON_II () {	0x60000000;}
}
unless(defined(&TI_FIRMWARE_MAJOR)) {
    sub TI_FIRMWARE_MAJOR () {	0xc;}
}
unless(defined(&TI_FIRMWARE_MINOR)) {
    sub TI_FIRMWARE_MINOR () {	0x4;}
}
unless(defined(&TI_FIRMWARE_FIX)) {
    sub TI_FIRMWARE_FIX () {	0xd;}
}
unless(defined(&TI_MLC_EE_WRITE_ENB)) {
    sub TI_MLC_EE_WRITE_ENB () {	0x10;}
}
unless(defined(&TI_MLC_SRAM_BANK_256K)) {
    sub TI_MLC_SRAM_BANK_256K () {	0x200;}
}
unless(defined(&TI_MLC_SRAM_BANK_SIZE)) {
    sub TI_MLC_SRAM_BANK_SIZE () {	0x300;}
}
unless(defined(&TI_MLC_LOCALADDR_21)) {
    sub TI_MLC_LOCALADDR_21 () {	0x4000;}
}
unless(defined(&TI_MLC_LOCALADDR_22)) {
    sub TI_MLC_LOCALADDR_22 () {	0x8000;}
}
unless(defined(&TI_MLC_SBUS_WRITEERR)) {
    sub TI_MLC_SBUS_WRITEERR () {	0x80000;}
}
unless(defined(&TI_MLC_EE_CLK)) {
    sub TI_MLC_EE_CLK () {	0x100000;}
}
unless(defined(&TI_MLC_EE_TXEN)) {
    sub TI_MLC_EE_TXEN () {	0x200000;}
}
unless(defined(&TI_MLC_EE_DOUT)) {
    sub TI_MLC_EE_DOUT () {	0x400000;}
}
unless(defined(&TI_MLC_EE_DIN)) {
    sub TI_MLC_EE_DIN () {	0x800000;}
}
unless(defined(&TI_EE_MAC_OFFSET)) {
    sub TI_EE_MAC_OFFSET () {	0x8c;}
}
unless(defined(&TI_DMA_ASSIST)) {
    sub TI_DMA_ASSIST () {	0x11c;}
}
unless(defined(&TI_CPU_STATE)) {
    sub TI_CPU_STATE () {	0x140;}
}
unless(defined(&TI_CPU_PROGRAM_COUNTER)) {
    sub TI_CPU_PROGRAM_COUNTER () {	0x144;}
}
unless(defined(&TI_SRAM_ADDR)) {
    sub TI_SRAM_ADDR () {	0x154;}
}
unless(defined(&TI_SRAM_DATA)) {
    sub TI_SRAM_DATA () {	0x158;}
}
unless(defined(&TI_GEN_0)) {
    sub TI_GEN_0 () {	0x180;}
}
unless(defined(&TI_GEN_X)) {
    sub TI_GEN_X () {	0x1fc;}
}
unless(defined(&TI_MAC_TX_STATE)) {
    sub TI_MAC_TX_STATE () {	0x200;}
}
unless(defined(&TI_MAC_RX_STATE)) {
    sub TI_MAC_RX_STATE () {	0x220;}
}
unless(defined(&TI_CPU_CTL_B)) {
    sub TI_CPU_CTL_B () {	0x240;}
}
unless(defined(&TI_CPU_PROGRAM_COUNTER_B)) {
    sub TI_CPU_PROGRAM_COUNTER_B () {	0x244;}
}
unless(defined(&TI_SRAM_ADDR_B)) {
    sub TI_SRAM_ADDR_B () {	0x254;}
}
unless(defined(&TI_SRAM_DATA_B)) {
    sub TI_SRAM_DATA_B () {	0x258;}
}
unless(defined(&TI_GEN_B_0)) {
    sub TI_GEN_B_0 () {	0x280;}
}
unless(defined(&TI_GEN_B_X)) {
    sub TI_GEN_B_X () {	0x2fc;}
}
unless(defined(&TI_MCR_SRAM_SYNCHRONOUS)) {
    sub TI_MCR_SRAM_SYNCHRONOUS () {	0x100000;}
}
unless(defined(&TI_PCISTATE_FORCE_RESET)) {
    sub TI_PCISTATE_FORCE_RESET () {	0x1;}
}
unless(defined(&TI_PCISTATE_PROVIDE_LEN)) {
    sub TI_PCISTATE_PROVIDE_LEN () {	0x2;}
}
unless(defined(&TI_PCISTATE_READ_MAXDMA)) {
    sub TI_PCISTATE_READ_MAXDMA () {	0x1c;}
}
unless(defined(&TI_PCISTATE_WRITE_MAXDMA)) {
    sub TI_PCISTATE_WRITE_MAXDMA () {	0xe0;}
}
unless(defined(&TI_PCISTATE_MINDMA)) {
    sub TI_PCISTATE_MINDMA () {	0xff00;}
}
unless(defined(&TI_PCISTATE_FIFO_RETRY_ENB)) {
    sub TI_PCISTATE_FIFO_RETRY_ENB () {	0x10000;}
}
unless(defined(&TI_PCISTATE_USE_MEM_RD_MULT)) {
    sub TI_PCISTATE_USE_MEM_RD_MULT () {	0x20000;}
}
unless(defined(&TI_PCISTATE_NO_SWAP_READ_DMA)) {
    sub TI_PCISTATE_NO_SWAP_READ_DMA () {	0x40000;}
}
unless(defined(&TI_PCISTATE_NO_SWAP_WRITE_DMA)) {
    sub TI_PCISTATE_NO_SWAP_WRITE_DMA () {	0x80000;}
}
unless(defined(&TI_PCISTATE_66MHZ_BUS)) {
    sub TI_PCISTATE_66MHZ_BUS () {	0x80000;}
}
unless(defined(&TI_PCISTATE_32BIT_BUS)) {
    sub TI_PCISTATE_32BIT_BUS () {	0x100000;}
}
unless(defined(&TI_PCISTATE_ENB_BYTE_ENABLES)) {
    sub TI_PCISTATE_ENB_BYTE_ENABLES () {	0x800000;}
}
unless(defined(&TI_PCISTATE_READ_CMD)) {
    sub TI_PCISTATE_READ_CMD () {	0xf000000;}
}
unless(defined(&TI_PCISTATE_WRITE_CMD)) {
    sub TI_PCISTATE_WRITE_CMD () {	0xf0000000;}
}
unless(defined(&TI_PCI_READMAX_4)) {
    sub TI_PCI_READMAX_4 () {	0x4;}
}
unless(defined(&TI_PCI_READMAX_16)) {
    sub TI_PCI_READMAX_16 () {	0x8;}
}
unless(defined(&TI_PCI_READMAX_32)) {
    sub TI_PCI_READMAX_32 () {	0xc;}
}
unless(defined(&TI_PCI_READMAX_64)) {
    sub TI_PCI_READMAX_64 () {	0x10;}
}
unless(defined(&TI_PCI_READMAX_128)) {
    sub TI_PCI_READMAX_128 () {	0x14;}
}
unless(defined(&TI_PCI_READMAX_256)) {
    sub TI_PCI_READMAX_256 () {	0x18;}
}
unless(defined(&TI_PCI_READMAX_1024)) {
    sub TI_PCI_READMAX_1024 () {	0x1c;}
}
unless(defined(&TI_PCI_WRITEMAX_4)) {
    sub TI_PCI_WRITEMAX_4 () {	0x20;}
}
unless(defined(&TI_PCI_WRITEMAX_16)) {
    sub TI_PCI_WRITEMAX_16 () {	0x40;}
}
unless(defined(&TI_PCI_WRITEMAX_32)) {
    sub TI_PCI_WRITEMAX_32 () {	0x60;}
}
unless(defined(&TI_PCI_WRITEMAX_64)) {
    sub TI_PCI_WRITEMAX_64 () {	0x80;}
}
unless(defined(&TI_PCI_WRITEMAX_128)) {
    sub TI_PCI_WRITEMAX_128 () {	0xa0;}
}
unless(defined(&TI_PCI_WRITEMAX_256)) {
    sub TI_PCI_WRITEMAX_256 () {	0xc0;}
}
unless(defined(&TI_PCI_WRITEMAX_1024)) {
    sub TI_PCI_WRITEMAX_1024 () {	0xe0;}
}
unless(defined(&TI_PCI_READ_CMD)) {
    sub TI_PCI_READ_CMD () {	0x6000000;}
}
unless(defined(&TI_PCI_WRITE_CMD)) {
    sub TI_PCI_WRITE_CMD () {	0x70000000;}
}
unless(defined(&TI_DMASTATE_ENABLE)) {
    sub TI_DMASTATE_ENABLE () {	0x1;}
}
unless(defined(&TI_DMASTATE_PAUSE)) {
    sub TI_DMASTATE_PAUSE () {	0x2;}
}
unless(defined(&TI_CPUSTATE_RESET)) {
    sub TI_CPUSTATE_RESET () {	0x1;}
}
unless(defined(&TI_CPUSTATE_STEP)) {
    sub TI_CPUSTATE_STEP () {	0x2;}
}
unless(defined(&TI_CPUSTATE_ROMFAIL)) {
    sub TI_CPUSTATE_ROMFAIL () {	0x10;}
}
unless(defined(&TI_CPUSTATE_HALT)) {
    sub TI_CPUSTATE_HALT () {	0x10000;}
}
unless(defined(&TI_TXSTATE_RESET)) {
    sub TI_TXSTATE_RESET () {	0x1;}
}
unless(defined(&TI_TXSTATE_ENB)) {
    sub TI_TXSTATE_ENB () {	0x2;}
}
unless(defined(&TI_TXSTATE_STOP)) {
    sub TI_TXSTATE_STOP () {	0x4;}
}
unless(defined(&TI_RXSTATE_RESET)) {
    sub TI_RXSTATE_RESET () {	0x1;}
}
unless(defined(&TI_RXSTATE_ENB)) {
    sub TI_RXSTATE_ENB () {	0x2;}
}
unless(defined(&TI_RXSTATE_STOP)) {
    sub TI_RXSTATE_STOP () {	0x4;}
}
unless(defined(&TI_MB_HOSTINTR_HI)) {
    sub TI_MB_HOSTINTR_HI () {	0x500;}
}
unless(defined(&TI_MB_HOSTINTR_LO)) {
    sub TI_MB_HOSTINTR_LO () {	0x504;}
}
unless(defined(&TI_MB_HOSTINTR)) {
    sub TI_MB_HOSTINTR () {	 &TI_MB_HOSTINTR_LO;}
}
unless(defined(&TI_MB_CMDPROD_IDX_HI)) {
    sub TI_MB_CMDPROD_IDX_HI () {	0x508;}
}
unless(defined(&TI_MB_CMDPROD_IDX_LO)) {
    sub TI_MB_CMDPROD_IDX_LO () {	0x50c;}
}
unless(defined(&TI_MB_CMDPROD_IDX)) {
    sub TI_MB_CMDPROD_IDX () {	 &TI_MB_CMDPROD_IDX_LO;}
}
unless(defined(&TI_MB_SENDPROD_IDX_HI)) {
    sub TI_MB_SENDPROD_IDX_HI () {	0x510;}
}
unless(defined(&TI_MB_SENDPROD_IDX_LO)) {
    sub TI_MB_SENDPROD_IDX_LO () {	0x514;}
}
unless(defined(&TI_MB_SENDPROD_IDX)) {
    sub TI_MB_SENDPROD_IDX () {	 &TI_MB_SENDPROD_IDX_LO;}
}
unless(defined(&TI_MB_STDRXPROD_IDX_HI)) {
    sub TI_MB_STDRXPROD_IDX_HI () {	0x518;}
}
unless(defined(&TI_MB_STDRXPROD_IDX_LO)) {
    sub TI_MB_STDRXPROD_IDX_LO () {	0x51c;}
}
unless(defined(&TI_MB_STDRXPROD_IDX)) {
    sub TI_MB_STDRXPROD_IDX () {	 &TI_MB_STDRXPROD_IDX_LO;}
}
unless(defined(&TI_MB_JUMBORXPROD_IDX_HI)) {
    sub TI_MB_JUMBORXPROD_IDX_HI () {	0x520;}
}
unless(defined(&TI_MB_JUMBORXPROD_IDX_LO)) {
    sub TI_MB_JUMBORXPROD_IDX_LO () {	0x524;}
}
unless(defined(&TI_MB_JUMBORXPROD_IDX)) {
    sub TI_MB_JUMBORXPROD_IDX () {	 &TI_MB_JUMBORXPROD_IDX_LO;}
}
unless(defined(&TI_MB_MINIRXPROD_IDX_HI)) {
    sub TI_MB_MINIRXPROD_IDX_HI () {	0x528;}
}
unless(defined(&TI_MB_MINIRXPROD_IDX_LO)) {
    sub TI_MB_MINIRXPROD_IDX_LO () {	0x52c;}
}
unless(defined(&TI_MB_MINIRXPROD_IDX)) {
    sub TI_MB_MINIRXPROD_IDX () {	 &TI_MB_MINIRXPROD_IDX_LO;}
}
unless(defined(&TI_MB_RSVD)) {
    sub TI_MB_RSVD () {	0x530;}
}
unless(defined(&TI_GCR_BASE)) {
    sub TI_GCR_BASE () {	0x600;}
}
unless(defined(&TI_GCR_MACADDR)) {
    sub TI_GCR_MACADDR () {	0x600;}
}
unless(defined(&TI_GCR_PAR0)) {
    sub TI_GCR_PAR0 () {	0x600;}
}
unless(defined(&TI_GCR_PAR1)) {
    sub TI_GCR_PAR1 () {	0x604;}
}
unless(defined(&TI_GCR_GENINFO_HI)) {
    sub TI_GCR_GENINFO_HI () {	0x608;}
}
unless(defined(&TI_GCR_GENINFO_LO)) {
    sub TI_GCR_GENINFO_LO () {	0x60c;}
}
unless(defined(&TI_GCR_MCASTADDR)) {
    sub TI_GCR_MCASTADDR () {	0x610;}
}
unless(defined(&TI_GCR_MAR0)) {
    sub TI_GCR_MAR0 () {	0x610;}
}
unless(defined(&TI_GCR_MAR1)) {
    sub TI_GCR_MAR1 () {	0x614;}
}
unless(defined(&TI_GCR_OPMODE)) {
    sub TI_GCR_OPMODE () {	0x618;}
}
unless(defined(&TI_GCR_DMA_READCFG)) {
    sub TI_GCR_DMA_READCFG () {	0x61c;}
}
unless(defined(&TI_GCR_DMA_WRITECFG)) {
    sub TI_GCR_DMA_WRITECFG () {	0x620;}
}
unless(defined(&TI_GCR_TX_BUFFER_RATIO)) {
    sub TI_GCR_TX_BUFFER_RATIO () {	0x624;}
}
unless(defined(&TI_GCR_EVENTCONS_IDX)) {
    sub TI_GCR_EVENTCONS_IDX () {	0x628;}
}
unless(defined(&TI_GCR_CMDCONS_IDX)) {
    sub TI_GCR_CMDCONS_IDX () {	0x62c;}
}
unless(defined(&TI_GCR_TUNEPARMS)) {
    sub TI_GCR_TUNEPARMS () {	0x630;}
}
unless(defined(&TI_GCR_RX_COAL_TICKS)) {
    sub TI_GCR_RX_COAL_TICKS () {	0x630;}
}
unless(defined(&TI_GCR_TX_COAL_TICKS)) {
    sub TI_GCR_TX_COAL_TICKS () {	0x634;}
}
unless(defined(&TI_GCR_STAT_TICKS)) {
    sub TI_GCR_STAT_TICKS () {	0x638;}
}
unless(defined(&TI_GCR_TX_MAX_COAL_BD)) {
    sub TI_GCR_TX_MAX_COAL_BD () {	0x63c;}
}
unless(defined(&TI_GCR_RX_MAX_COAL_BD)) {
    sub TI_GCR_RX_MAX_COAL_BD () {	0x640;}
}
unless(defined(&TI_GCR_NIC_TRACING)) {
    sub TI_GCR_NIC_TRACING () {	0x644;}
}
unless(defined(&TI_GCR_GLINK)) {
    sub TI_GCR_GLINK () {	0x648;}
}
unless(defined(&TI_GCR_LINK)) {
    sub TI_GCR_LINK () {	0x64c;}
}
unless(defined(&TI_GCR_NICTRACE_PTR)) {
    sub TI_GCR_NICTRACE_PTR () {	0x650;}
}
unless(defined(&TI_GCR_NICTRACE_START)) {
    sub TI_GCR_NICTRACE_START () {	0x654;}
}
unless(defined(&TI_GCR_NICTRACE_LEN)) {
    sub TI_GCR_NICTRACE_LEN () {	0x658;}
}
unless(defined(&TI_GCR_IFINDEX)) {
    sub TI_GCR_IFINDEX () {	0x65c;}
}
unless(defined(&TI_GCR_IFMTU)) {
    sub TI_GCR_IFMTU () {	0x660;}
}
unless(defined(&TI_GCR_MASK_INTRS)) {
    sub TI_GCR_MASK_INTRS () {	0x664;}
}
unless(defined(&TI_GCR_GLINK_STAT)) {
    sub TI_GCR_GLINK_STAT () {	0x668;}
}
unless(defined(&TI_GCR_LINK_STAT)) {
    sub TI_GCR_LINK_STAT () {	0x66c;}
}
unless(defined(&TI_GCR_RXRETURNCONS_IDX)) {
    sub TI_GCR_RXRETURNCONS_IDX () {	0x680;}
}
unless(defined(&TI_GCR_CMDRING)) {
    sub TI_GCR_CMDRING () {	0x700;}
}
unless(defined(&TI_GCR_NIC_ADDR)) {
    sub TI_GCR_NIC_ADDR {
	local($x) = @_;
	eval q(($x -  &TI_GCR_BASE));
    }
}
unless(defined(&TI_WINDOW)) {
    sub TI_WINDOW () {	0x800;}
}
unless(defined(&TI_WINLEN)) {
    sub TI_WINLEN () {	0x800;}
}
unless(defined(&TI_TICKS_PER_SEC)) {
    sub TI_TICKS_PER_SEC () {	1000000;}
}
unless(defined(&TI_OPMODE_BYTESWAP_BD)) {
    sub TI_OPMODE_BYTESWAP_BD () {	0x2;}
}
unless(defined(&TI_OPMODE_WORDSWAP_BD)) {
    sub TI_OPMODE_WORDSWAP_BD () {	0x4;}
}
unless(defined(&TI_OPMODE_WARN_ENB)) {
    sub TI_OPMODE_WARN_ENB () {	0x8;}
}
unless(defined(&TI_OPMODE_BYTESWAP_DATA)) {
    sub TI_OPMODE_BYTESWAP_DATA () {	0x10;}
}
unless(defined(&TI_OPMODE_1_DMA_ACTIVE)) {
    sub TI_OPMODE_1_DMA_ACTIVE () {	0x40;}
}
unless(defined(&TI_OPMODE_SBUS)) {
    sub TI_OPMODE_SBUS () {	0x100;}
}
unless(defined(&TI_OPMODE_DONT_FRAG_JUMBO)) {
    sub TI_OPMODE_DONT_FRAG_JUMBO () {	0x200;}
}
unless(defined(&TI_OPMODE_INCLUDE_CRC)) {
    sub TI_OPMODE_INCLUDE_CRC () {	0x400;}
}
unless(defined(&TI_OPMODE_RX_BADFRAMES)) {
    sub TI_OPMODE_RX_BADFRAMES () {	0x800;}
}
unless(defined(&TI_OPMODE_NO_EVENT_INTRS)) {
    sub TI_OPMODE_NO_EVENT_INTRS () {	0x1000;}
}
unless(defined(&TI_OPMODE_NO_TX_INTRS)) {
    sub TI_OPMODE_NO_TX_INTRS () {	0x2000;}
}
unless(defined(&TI_OPMODE_NO_RX_INTRS)) {
    sub TI_OPMODE_NO_RX_INTRS () {	0x4000;}
}
unless(defined(&TI_OPMODE_FATAL_ENB)) {
    sub TI_OPMODE_FATAL_ENB () {	0x40000000;}
}
unless(defined(&TI_DMA_STATE_THRESH_16W)) {
    sub TI_DMA_STATE_THRESH_16W () {	0x100;}
}
unless(defined(&TI_DMA_STATE_THRESH_8W)) {
    sub TI_DMA_STATE_THRESH_8W () {	0x80;}
}
unless(defined(&TI_DMA_STATE_THRESH_4W)) {
    sub TI_DMA_STATE_THRESH_4W () {	0x40;}
}
unless(defined(&TI_DMA_STATE_THRESH_2W)) {
    sub TI_DMA_STATE_THRESH_2W () {	0x20;}
}
unless(defined(&TI_DMA_STATE_THRESH_1W)) {
    sub TI_DMA_STATE_THRESH_1W () {	0x10;}
}
unless(defined(&TI_DMA_STATE_FORCE_32_BIT)) {
    sub TI_DMA_STATE_FORCE_32_BIT () {	0x8;}
}
unless(defined(&TI_GLNK_SENSE_NO_BEG)) {
    sub TI_GLNK_SENSE_NO_BEG () {	0x2000;}
}
unless(defined(&TI_GLNK_LOOPBACK)) {
    sub TI_GLNK_LOOPBACK () {	0x4000;}
}
unless(defined(&TI_GLNK_PREF)) {
    sub TI_GLNK_PREF () {	0x8000;}
}
unless(defined(&TI_GLNK_1000MB)) {
    sub TI_GLNK_1000MB () {	0x40000;}
}
unless(defined(&TI_GLNK_FULL_DUPLEX)) {
    sub TI_GLNK_FULL_DUPLEX () {	0x80000;}
}
unless(defined(&TI_GLNK_TX_FLOWCTL_Y)) {
    sub TI_GLNK_TX_FLOWCTL_Y () {	0x200000;}
}
unless(defined(&TI_GLNK_RX_FLOWCTL_Y)) {
    sub TI_GLNK_RX_FLOWCTL_Y () {	0x800000;}
}
unless(defined(&TI_GLNK_AUTONEGENB)) {
    sub TI_GLNK_AUTONEGENB () {	0x20000000;}
}
unless(defined(&TI_GLNK_ENB)) {
    sub TI_GLNK_ENB () {	0x40000000;}
}
unless(defined(&TI_LNK_LOOPBACK)) {
    sub TI_LNK_LOOPBACK () {	0x4000;}
}
unless(defined(&TI_LNK_PREF)) {
    sub TI_LNK_PREF () {	0x8000;}
}
unless(defined(&TI_LNK_10MB)) {
    sub TI_LNK_10MB () {	0x10000;}
}
unless(defined(&TI_LNK_100MB)) {
    sub TI_LNK_100MB () {	0x20000;}
}
unless(defined(&TI_LNK_1000MB)) {
    sub TI_LNK_1000MB () {	0x40000;}
}
unless(defined(&TI_LNK_FULL_DUPLEX)) {
    sub TI_LNK_FULL_DUPLEX () {	0x80000;}
}
unless(defined(&TI_LNK_HALF_DUPLEX)) {
    sub TI_LNK_HALF_DUPLEX () {	0x100000;}
}
unless(defined(&TI_LNK_TX_FLOWCTL_Y)) {
    sub TI_LNK_TX_FLOWCTL_Y () {	0x200000;}
}
unless(defined(&TI_LNK_RX_FLOWCTL_Y)) {
    sub TI_LNK_RX_FLOWCTL_Y () {	0x800000;}
}
unless(defined(&TI_LNK_AUTONEGENB)) {
    sub TI_LNK_AUTONEGENB () {	0x20000000;}
}
unless(defined(&TI_LNK_ENB)) {
    sub TI_LNK_ENB () {	0x40000000;}
}
unless(defined(&TI_EVENT_RING_CNT)) {
    sub TI_EVENT_RING_CNT () {	256;}
}
unless(defined(&TI_CMD_RING_CNT)) {
    sub TI_CMD_RING_CNT () {	64;}
}
unless(defined(&TI_STD_RX_RING_CNT)) {
    sub TI_STD_RX_RING_CNT () {	512;}
}
unless(defined(&TI_JUMBO_RX_RING_CNT)) {
    sub TI_JUMBO_RX_RING_CNT () {	256;}
}
unless(defined(&TI_MINI_RX_RING_CNT)) {
    sub TI_MINI_RX_RING_CNT () {	1024;}
}
unless(defined(&TI_RETURN_RING_CNT)) {
    sub TI_RETURN_RING_CNT () {	2048;}
}
unless(defined(&TI_TX_RING_CNT_128)) {
    sub TI_TX_RING_CNT_128 () {	128;}
}
unless(defined(&TI_TX_RING_BASE_128)) {
    sub TI_TX_RING_BASE_128 () {	0x3800;}
}
unless(defined(&TI_TX_RING_CNT_256)) {
    sub TI_TX_RING_CNT_256 () {	256;}
}
unless(defined(&TI_TX_RING_BASE_256)) {
    sub TI_TX_RING_BASE_256 () {	0x3000;}
}
unless(defined(&TI_TX_RING_CNT_512)) {
    sub TI_TX_RING_CNT_512 () {	512;}
}
unless(defined(&TI_TX_RING_BASE_512)) {
    sub TI_TX_RING_BASE_512 () {	0x2000;}
}
unless(defined(&TI_TX_RING_CNT)) {
    sub TI_TX_RING_CNT () {	 &TI_TX_RING_CNT_512;}
}
unless(defined(&TI_TX_RING_BASE)) {
    sub TI_TX_RING_BASE () {	 &TI_TX_RING_BASE_512;}
}
unless(defined(&TI_MEM_MAX)) {
    sub TI_MEM_MAX () {	0x7fffff;}
}
unless(defined(&TI_HOSTADDR)) {
    sub TI_HOSTADDR {
	local($x) = @_;
	eval q( ($x->{ti_addr_lo}));
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
unless(defined(&TI_RCB_FLAG_TCP_UDP_CKSUM)) {
    sub TI_RCB_FLAG_TCP_UDP_CKSUM () {	0x1;}
}
unless(defined(&TI_RCB_FLAG_IP_CKSUM)) {
    sub TI_RCB_FLAG_IP_CKSUM () {	0x2;}
}
unless(defined(&TI_RCB_FLAG_NO_PHDR_CKSUM)) {
    sub TI_RCB_FLAG_NO_PHDR_CKSUM () {	0x8;}
}
unless(defined(&TI_RCB_FLAG_VLAN_ASSIST)) {
    sub TI_RCB_FLAG_VLAN_ASSIST () {	0x10;}
}
unless(defined(&TI_RCB_FLAG_COAL_UPD_ONLY)) {
    sub TI_RCB_FLAG_COAL_UPD_ONLY () {	0x20;}
}
unless(defined(&TI_RCB_FLAG_HOST_RING)) {
    sub TI_RCB_FLAG_HOST_RING () {	0x40;}
}
unless(defined(&TI_RCB_FLAG_IEEE_SNAP_CKSUM)) {
    sub TI_RCB_FLAG_IEEE_SNAP_CKSUM () {	0x80;}
}
unless(defined(&TI_RCB_FLAG_USE_EXT_RX_BD)) {
    sub TI_RCB_FLAG_USE_EXT_RX_BD () {	0x100;}
}
unless(defined(&TI_RCB_FLAG_RING_DISABLED)) {
    sub TI_RCB_FLAG_RING_DISABLED () {	0x200;}
}
unless(defined(&IF_ADMIN_STATUS_UP)) {
    sub IF_ADMIN_STATUS_UP () {	1;}
}
unless(defined(&IF_ADMIN_STATUS_DOWN)) {
    sub IF_ADMIN_STATUS_DOWN () {	2;}
}
unless(defined(&IF_ADMIN_STATUS_TESTING)) {
    sub IF_ADMIN_STATUS_TESTING () {	3;}
}
unless(defined(&IF_OPER_STATUS_UP)) {
    sub IF_OPER_STATUS_UP () {	1;}
}
unless(defined(&IF_OPER_STATUS_DOWN)) {
    sub IF_OPER_STATUS_DOWN () {	2;}
}
unless(defined(&IF_OPER_STATUS_TESTING)) {
    sub IF_OPER_STATUS_TESTING () {	3;}
}
unless(defined(&IF_OPER_STATUS_UNKNOWN)) {
    sub IF_OPER_STATUS_UNKNOWN () {	4;}
}
unless(defined(&IF_OPER_STATUS_DORMANT)) {
    sub IF_OPER_STATUS_DORMANT () {	5;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
} else {
}
unless(defined(&TI_PAGE_SIZE)) {
    sub TI_PAGE_SIZE () {	 &PAGE_SIZE;}
}
unless(defined(&TI_MIN_FRAMELEN)) {
    sub TI_MIN_FRAMELEN () {	60;}
}
unless(defined(&TI_BDERR_CRC)) {
    sub TI_BDERR_CRC () {	0x1;}
}
unless(defined(&TI_BDERR_COLLDETECT)) {
    sub TI_BDERR_COLLDETECT () {	0x2;}
}
unless(defined(&TI_BDERR_LINKLOST)) {
    sub TI_BDERR_LINKLOST () {	0x4;}
}
unless(defined(&TI_BDERR_DECODE)) {
    sub TI_BDERR_DECODE () {	0x8;}
}
unless(defined(&TI_BDERR_ODD_NIBBLES)) {
    sub TI_BDERR_ODD_NIBBLES () {	0x10;}
}
unless(defined(&TI_BDERR_MAC_ABRT)) {
    sub TI_BDERR_MAC_ABRT () {	0x20;}
}
unless(defined(&TI_BDERR_RUNT)) {
    sub TI_BDERR_RUNT () {	0x40;}
}
unless(defined(&TI_BDERR_TRUNC)) {
    sub TI_BDERR_TRUNC () {	0x80;}
}
unless(defined(&TI_BDERR_GIANT)) {
    sub TI_BDERR_GIANT () {	0x100;}
}
unless(defined(&TI_BDFLAG_TCP_UDP_CKSUM)) {
    sub TI_BDFLAG_TCP_UDP_CKSUM () {	0x1;}
}
unless(defined(&TI_BDFLAG_IP_CKSUM)) {
    sub TI_BDFLAG_IP_CKSUM () {	0x2;}
}
unless(defined(&TI_BDFLAG_END)) {
    sub TI_BDFLAG_END () {	0x4;}
}
unless(defined(&TI_BDFLAG_MORE)) {
    sub TI_BDFLAG_MORE () {	0x8;}
}
unless(defined(&TI_BDFLAG_JUMBO_RING)) {
    sub TI_BDFLAG_JUMBO_RING () {	0x10;}
}
unless(defined(&TI_BDFLAG_UCAST_PKT)) {
    sub TI_BDFLAG_UCAST_PKT () {	0x20;}
}
unless(defined(&TI_BDFLAG_MCAST_PKT)) {
    sub TI_BDFLAG_MCAST_PKT () {	0x40;}
}
unless(defined(&TI_BDFLAG_BCAST_PKT)) {
    sub TI_BDFLAG_BCAST_PKT () {	0x60;}
}
unless(defined(&TI_BDFLAG_IP_FRAG)) {
    sub TI_BDFLAG_IP_FRAG () {	0x80;}
}
unless(defined(&TI_BDFLAG_IP_FRAG_END)) {
    sub TI_BDFLAG_IP_FRAG_END () {	0x100;}
}
unless(defined(&TI_BDFLAG_VLAN_TAG)) {
    sub TI_BDFLAG_VLAN_TAG () {	0x200;}
}
unless(defined(&TI_BDFLAG_ERROR)) {
    sub TI_BDFLAG_ERROR () {	0x400;}
}
unless(defined(&TI_BDFLAG_COAL_NOW)) {
    sub TI_BDFLAG_COAL_NOW () {	0x800;}
}
unless(defined(&TI_BDFLAG_MINI_RING)) {
    sub TI_BDFLAG_MINI_RING () {	0x1000;}
}
unless(defined(&TI_BDTYPE_TYPE_NULL)) {
    sub TI_BDTYPE_TYPE_NULL () {	0x;}
}
unless(defined(&TI_BDTYPE_SEND_BD)) {
    sub TI_BDTYPE_SEND_BD () {	0x1;}
}
unless(defined(&TI_BDTYPE_RECV_BD)) {
    sub TI_BDTYPE_RECV_BD () {	0x2;}
}
unless(defined(&TI_BDTYPE_RECV_JUMBO_BD)) {
    sub TI_BDTYPE_RECV_JUMBO_BD () {	0x3;}
}
unless(defined(&TI_BDTYPE_RECV_BD_LAST)) {
    sub TI_BDTYPE_RECV_BD_LAST () {	0x4;}
}
unless(defined(&TI_BDTYPE_SEND_DATA)) {
    sub TI_BDTYPE_SEND_DATA () {	0x5;}
}
unless(defined(&TI_BDTYPE_SEND_DATA_LAST)) {
    sub TI_BDTYPE_SEND_DATA_LAST () {	0x6;}
}
unless(defined(&TI_BDTYPE_RECV_DATA)) {
    sub TI_BDTYPE_RECV_DATA () {	0x7;}
}
unless(defined(&TI_BDTYPE_RECV_DATA_LAST)) {
    sub TI_BDTYPE_RECV_DATA_LAST () {	0xb;}
}
unless(defined(&TI_BDTYPE_EVENT_RUPT)) {
    sub TI_BDTYPE_EVENT_RUPT () {	0xc;}
}
unless(defined(&TI_BDTYPE_EVENT_NO_RUPT)) {
    sub TI_BDTYPE_EVENT_NO_RUPT () {	0xd;}
}
unless(defined(&TI_BDTYPE_ODD_START)) {
    sub TI_BDTYPE_ODD_START () {	0xe;}
}
unless(defined(&TI_BDTYPE_UPDATE_STATS)) {
    sub TI_BDTYPE_UPDATE_STATS () {	0xf;}
}
unless(defined(&TI_BDTYPE_SEND_DUMMY_DMA)) {
    sub TI_BDTYPE_SEND_DUMMY_DMA () {	0x10;}
}
unless(defined(&TI_BDTYPE_EVENT_PROD)) {
    sub TI_BDTYPE_EVENT_PROD () {	0x11;}
}
unless(defined(&TI_BDTYPE_TX_CONS)) {
    sub TI_BDTYPE_TX_CONS () {	0x12;}
}
unless(defined(&TI_BDTYPE_RX_PROD)) {
    sub TI_BDTYPE_RX_PROD () {	0x13;}
}
unless(defined(&TI_BDTYPE_REFRESH_STATS)) {
    sub TI_BDTYPE_REFRESH_STATS () {	0x14;}
}
unless(defined(&TI_BDTYPE_SEND_DATA_LAST_VLAN)) {
    sub TI_BDTYPE_SEND_DATA_LAST_VLAN () {	0x15;}
}
unless(defined(&TI_BDTYPE_SEND_DATA_COAL)) {
    sub TI_BDTYPE_SEND_DATA_COAL () {	0x16;}
}
unless(defined(&TI_BDTYPE_SEND_DATA_LAST_COAL)) {
    sub TI_BDTYPE_SEND_DATA_LAST_COAL () {	0x17;}
}
unless(defined(&TI_BDTYPE_SEND_DATA_LAST_VLAN_COAL)) {
    sub TI_BDTYPE_SEND_DATA_LAST_VLAN_COAL () {	0x18;}
}
unless(defined(&TI_BDTYPE_TX_CONS_NO_INTR)) {
    sub TI_BDTYPE_TX_CONS_NO_INTR () {	0x19;}
}
unless(defined(&TI_CMD_CMD)) {
    sub TI_CMD_CMD {
	local($cmd) = @_;
	eval q(((((($cmd)-> &ti_cmdx)) >> 24) & 0xff));
    }
}
unless(defined(&TI_CMD_CODE)) {
    sub TI_CMD_CODE {
	local($cmd) = @_;
	eval q(((((($cmd)-> &ti_cmdx)) >> 12) & 0xfff));
    }
}
unless(defined(&TI_CMD_IDX)) {
    sub TI_CMD_IDX {
	local($cmd) = @_;
	eval q((((($cmd)-> &ti_cmdx)) & 0xfff));
    }
}
unless(defined(&TI_CMD_HOST_STATE)) {
    sub TI_CMD_HOST_STATE () {	0x1;}
}
unless(defined(&TI_CMD_CODE_STACK_UP)) {
    sub TI_CMD_CODE_STACK_UP () {	0x1;}
}
unless(defined(&TI_CMD_CODE_STACK_DOWN)) {
    sub TI_CMD_CODE_STACK_DOWN () {	0x2;}
}
unless(defined(&TI_CMD_FDR_FILTERING)) {
    sub TI_CMD_FDR_FILTERING () {	0x2;}
}
unless(defined(&TI_CMD_CODE_FILT_ENB)) {
    sub TI_CMD_CODE_FILT_ENB () {	0x1;}
}
unless(defined(&TI_CMD_CODE_FILT_DIS)) {
    sub TI_CMD_CODE_FILT_DIS () {	0x2;}
}
unless(defined(&TI_CMD_SET_RX_PROD_IDX)) {
    sub TI_CMD_SET_RX_PROD_IDX () {	0x3;}
}
unless(defined(&TI_CMD_UPDATE_GENCOM)) {
    sub TI_CMD_UPDATE_GENCOM () {	0x4;}
}
unless(defined(&TI_CMD_RESET_JUMBO_RING)) {
    sub TI_CMD_RESET_JUMBO_RING () {	0x5;}
}
unless(defined(&TI_CMD_SET_PARTIAL_RX_CNT)) {
    sub TI_CMD_SET_PARTIAL_RX_CNT () {	0x6;}
}
unless(defined(&TI_CMD_ADD_MCAST_ADDR)) {
    sub TI_CMD_ADD_MCAST_ADDR () {	0x8;}
}
unless(defined(&TI_CMD_DEL_MCAST_ADDR)) {
    sub TI_CMD_DEL_MCAST_ADDR () {	0x9;}
}
unless(defined(&TI_CMD_SET_PROMISC_MODE)) {
    sub TI_CMD_SET_PROMISC_MODE () {	0xa;}
}
unless(defined(&TI_CMD_CODE_PROMISC_ENB)) {
    sub TI_CMD_CODE_PROMISC_ENB () {	0x1;}
}
unless(defined(&TI_CMD_CODE_PROMISC_DIS)) {
    sub TI_CMD_CODE_PROMISC_DIS () {	0x2;}
}
unless(defined(&TI_CMD_LINK_NEGOTIATION)) {
    sub TI_CMD_LINK_NEGOTIATION () {	0xb;}
}
unless(defined(&TI_CMD_CODE_NEGOTIATE_BOTH)) {
    sub TI_CMD_CODE_NEGOTIATE_BOTH () {	0x;}
}
unless(defined(&TI_CMD_CODE_NEGOTIATE_GIGABIT)) {
    sub TI_CMD_CODE_NEGOTIATE_GIGABIT () {	0x1;}
}
unless(defined(&TI_CMD_CODE_NEGOTIATE_10_100)) {
    sub TI_CMD_CODE_NEGOTIATE_10_100 () {	0x2;}
}
unless(defined(&TI_CMD_SET_MAC_ADDR)) {
    sub TI_CMD_SET_MAC_ADDR () {	0xc;}
}
unless(defined(&TI_CMD_CLR_PROFILE)) {
    sub TI_CMD_CLR_PROFILE () {	0xd;}
}
unless(defined(&TI_CMD_SET_ALLMULTI)) {
    sub TI_CMD_SET_ALLMULTI () {	0xe;}
}
unless(defined(&TI_CMD_CODE_ALLMULTI_ENB)) {
    sub TI_CMD_CODE_ALLMULTI_ENB () {	0x1;}
}
unless(defined(&TI_CMD_CODE_ALLMULTI_DIS)) {
    sub TI_CMD_CODE_ALLMULTI_DIS () {	0x2;}
}
unless(defined(&TI_CMD_CLR_STATS)) {
    sub TI_CMD_CLR_STATS () {	0xf;}
}
unless(defined(&TI_CMD_SET_RX_JUMBO_PROD_IDX)) {
    sub TI_CMD_SET_RX_JUMBO_PROD_IDX () {	0x10;}
}
unless(defined(&TI_CMD_RFRSH_STATS)) {
    sub TI_CMD_RFRSH_STATS () {	0x11;}
}
unless(defined(&TI_CMD_EXT_ADD_MCAST)) {
    sub TI_CMD_EXT_ADD_MCAST () {	0x12;}
}
unless(defined(&TI_CMD_EXT_DEL_MCAST)) {
    sub TI_CMD_EXT_DEL_MCAST () {	0x13;}
}
unless(defined(&TI_DO_CMD)) {
    sub TI_DO_CMD {
	local($x, $y, $z) = @_;
	eval q( ($cmd->{ti_cmdx}) = ((($x) << 24) | (($y) << 12) | (($z)));  &ti_cmd( &sc,  &cmd););
    }
}
unless(defined(&TI_DO_CMD_EXT)) {
    sub TI_DO_CMD_EXT {
	local($x, $y, $z, $v, $w) = @_;
	eval q( ($cmd->{ti_cmdx}) = ((($x) << 24) | (($y) << 12) | (($z)));  &ti_cmd_ext( &sc,  &cmd, $v, $w););
    }
}
unless(defined(&TI_INC)) {
    sub TI_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&TI_UPDATE_JUMBOPROD)) {
    sub TI_UPDATE_JUMBOPROD {
	local($x, $y) = @_;
	eval q( &if ( ($x->{ti_hwrev}) ==  &TI_HWREV_TIGON) {  &TI_DO_CMD( &TI_CMD_SET_RX_JUMBO_PROD_IDX, 0, $y); }  &else {  &CSR_WRITE_4($x,  &TI_MB_JUMBORXPROD_IDX, $y); });
    }
}
unless(defined(&TI_UPDATE_MINIPROD)) {
    sub TI_UPDATE_MINIPROD {
	local($x, $y) = @_;
	eval q( &CSR_WRITE_4($x,  &TI_MB_MINIRXPROD_IDX, $y););
    }
}
unless(defined(&TI_UPDATE_STDPROD)) {
    sub TI_UPDATE_STDPROD {
	local($x, $y) = @_;
	eval q( &if ( ($x->{ti_hwrev}) ==  &TI_HWREV_TIGON) {  &TI_DO_CMD( &TI_CMD_SET_RX_PROD_IDX, 0, $y); }  &else {  &CSR_WRITE_4($x,  &TI_MB_STDRXPROD_IDX, $y); });
    }
}
unless(defined(&TI_EVENT_EVENT)) {
    sub TI_EVENT_EVENT {
	local($e) = @_;
	eval q(((((($e)-> &ti_eventx)) >> 24) & 0xff));
    }
}
unless(defined(&TI_EVENT_CODE)) {
    sub TI_EVENT_CODE {
	local($e) = @_;
	eval q(((((($e)-> &ti_eventx)) >> 12) & 0xfff));
    }
}
unless(defined(&TI_EVENT_IDX)) {
    sub TI_EVENT_IDX {
	local($e) = @_;
	eval q(((((($e)-> &ti_eventx))) & 0xfff));
    }
}
unless(defined(&TI_EV_FIRMWARE_UP)) {
    sub TI_EV_FIRMWARE_UP () {	0x1;}
}
unless(defined(&TI_EV_STATS_UPDATED)) {
    sub TI_EV_STATS_UPDATED () {	0x4;}
}
unless(defined(&TI_EV_LINKSTAT_CHANGED)) {
    sub TI_EV_LINKSTAT_CHANGED () {	0x6;}
}
unless(defined(&TI_EV_CODE_GIG_LINK_UP)) {
    sub TI_EV_CODE_GIG_LINK_UP () {	0x1;}
}
unless(defined(&TI_EV_CODE_LINK_DOWN)) {
    sub TI_EV_CODE_LINK_DOWN () {	0x2;}
}
unless(defined(&TI_EV_CODE_LINK_UP)) {
    sub TI_EV_CODE_LINK_UP () {	0x3;}
}
unless(defined(&TI_EV_ERROR)) {
    sub TI_EV_ERROR () {	0x7;}
}
unless(defined(&TI_EV_CODE_ERR_INVAL_CMD)) {
    sub TI_EV_CODE_ERR_INVAL_CMD () {	0x1;}
}
unless(defined(&TI_EV_CODE_ERR_UNIMP_CMD)) {
    sub TI_EV_CODE_ERR_UNIMP_CMD () {	0x2;}
}
unless(defined(&TI_EV_CODE_ERR_BADCFG)) {
    sub TI_EV_CODE_ERR_BADCFG () {	0x3;}
}
unless(defined(&TI_EV_MCAST_UPDATED)) {
    sub TI_EV_MCAST_UPDATED () {	0x8;}
}
unless(defined(&TI_EV_CODE_MCAST_ADD)) {
    sub TI_EV_CODE_MCAST_ADD () {	0x1;}
}
unless(defined(&TI_EV_CODE_MCAST_DEL)) {
    sub TI_EV_CODE_MCAST_DEL () {	0x2;}
}
unless(defined(&TI_EV_RESET_JUMBO_RING)) {
    sub TI_EV_RESET_JUMBO_RING () {	0x9;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{ti_btag}),  ($sc->{ti_bhandle}), ($reg), ($val)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{ti_btag}),  ($sc->{ti_bhandle}), ($reg)));
    }
}
unless(defined(&TI_SETBIT)) {
    sub TI_SETBIT {
	local($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, ($reg), ( &CSR_READ_4($sc, ($reg)) | ($x))));
    }
}
unless(defined(&TI_CLRBIT)) {
    sub TI_CLRBIT {
	local($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, ($reg), ( &CSR_READ_4($sc, ($reg)) & ~($x))));
    }
}
unless(defined(&TI_SSLOTS)) {
    sub TI_SSLOTS () {	256;}
}
unless(defined(&TI_MSLOTS)) {
    sub TI_MSLOTS () {	256;}
}
unless(defined(&TI_JSLOTS)) {
    sub TI_JSLOTS () {	384;}
}
unless(defined(&TI_JRAWLEN)) {
    sub TI_JRAWLEN () {	( &ETHER_MAX_LEN_JUMBO +  &ETHER_ALIGN);}
}
unless(defined(&TI_JLEN)) {
    sub TI_JLEN () {	( &TI_JRAWLEN + ($sizeof{ &u_int64_t} - ( &TI_JRAWLEN % $sizeof{ &u_int64_t})));}
}
unless(defined(&TI_JPAGESZ)) {
    sub TI_JPAGESZ () {	 &PAGE_SIZE;}
}
unless(defined(&TI_RESID)) {
    sub TI_RESID () {	( &TI_JPAGESZ - ( &TI_JLEN *  &TI_JSLOTS) %  &TI_JPAGESZ);}
}
unless(defined(&TI_JMEM)) {
    sub TI_JMEM () {	(( &TI_JLEN *  &TI_JSLOTS) +  &TI_RESID);}
}
unless(defined(&TI_RING_DMA_ADDR)) {
    sub TI_RING_DMA_ADDR {
	local($sc, $offset) = @_;
	eval q((($sc)-> ($ti_ring_map->{dm_segs[0]}->{ds_addr}) +  &offsetof('struct ti_ring_data', $offset)));
    }
}
unless(defined(&TI_RING_DMASYNC)) {
    sub TI_RING_DMASYNC {
	local($sc, $offset, $op) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmatag, ($sc)-> &ti_ring_map,  &offsetof('struct ti_ring_data', $offset), $sizeof{(0)->$offset}, ($op)));
    }
}
if(defined(&__LP64__)) {
    eval 'sub TI_NTXSEG () {30;}' unless defined(&TI_NTXSEG);
} else {
    eval 'sub TI_NTXSEG () {31;}' unless defined(&TI_NTXSEG);
}
unless(defined(&TI_JUMBO_DMA_ADDR)) {
    sub TI_JUMBO_DMA_ADDR {
	local($sc, $m) = @_;
	eval q((-> ($ti_cdata->{ti_rx_jumbo_map}->{d$m_segs[0]}->{ds_addr}) + ( &mtod(, 'char' *) - ($sc)-> ($ti_cdata->{ti_jumbo_buf}))));
    }
}
unless(defined(&TI_HWREV_TIGON)) {
    sub TI_HWREV_TIGON () {	0x1;}
}
unless(defined(&TI_HWREV_TIGON_II)) {
    sub TI_HWREV_TIGON_II () {	0x2;}
}
unless(defined(&TI_TIMEOUT)) {
    sub TI_TIMEOUT () {	1000;}
}
unless(defined(&TI_TXCONS_UNSET)) {
    sub TI_TXCONS_UNSET () {	0xffff;}
}
unless(defined(&ti_ev_prodidx)) {
    sub ti_ev_prodidx () {	 ($ti_rdata->{ti_ev_prodidx_r});}
}
unless(defined(&ti_return_prodidx)) {
    sub ti_return_prodidx () {	 ($ti_rdata->{ti_return_prodidx_r});}
}
unless(defined(&ti_tx_considx)) {
    sub ti_tx_considx () {	 ($ti_rdata->{ti_tx_considx_r});}
}
unless(defined(&EEPROM_CTL_READ)) {
    sub EEPROM_CTL_READ () {	0xa1;}
}
unless(defined(&EEPROM_CTL_WRITE)) {
    sub EEPROM_CTL_WRITE () {	0xa0;}
}
unless(defined(&EEPROM_START)) {
    sub EEPROM_START () {	 &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);;}
}
unless(defined(&EEPROM_STOP)) {
    sub EEPROM_STOP () {	 &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap(( &vm_offset_t)$va));
    }' unless defined(&vtophys);
}
unless(defined(&ETHER_CRC_LEN)) {
    eval 'sub ETHER_CRC_LEN () {4;}' unless defined(&ETHER_CRC_LEN);
}
unless(defined(&ETHER_HDR_LEN)) {
    eval 'sub ETHER_HDR_LEN () {14;}' unless defined(&ETHER_HDR_LEN);
}
1;
