require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&RAL_TX_RING_COUNT)) {
    sub RAL_TX_RING_COUNT () {	48;}
}
unless(defined(&RAL_ATIM_RING_COUNT)) {
    sub RAL_ATIM_RING_COUNT () {	4;}
}
unless(defined(&RAL_PRIO_RING_COUNT)) {
    sub RAL_PRIO_RING_COUNT () {	16;}
}
unless(defined(&RAL_BEACON_RING_COUNT)) {
    sub RAL_BEACON_RING_COUNT () {	1;}
}
unless(defined(&RAL_RX_RING_COUNT)) {
    sub RAL_RX_RING_COUNT () {	32;}
}
unless(defined(&RAL_TX_DESC_SIZE)) {
    sub RAL_TX_DESC_SIZE () {	($sizeof{'struct ral_tx_desc'});}
}
unless(defined(&RAL_RX_DESC_SIZE)) {
    sub RAL_RX_DESC_SIZE () {	($sizeof{'struct ral_rx_desc'});}
}
unless(defined(&RAL_MAX_SCATTER)) {
    sub RAL_MAX_SCATTER () {	1;}
}
unless(defined(&RAL_CSR0)) {
    sub RAL_CSR0 () {	0x;}
}
unless(defined(&RAL_CSR1)) {
    sub RAL_CSR1 () {	0x4;}
}
unless(defined(&RAL_CSR2)) {
    sub RAL_CSR2 () {	0x8;}
}
unless(defined(&RAL_CSR3)) {
    sub RAL_CSR3 () {	0xc;}
}
unless(defined(&RAL_CSR4)) {
    sub RAL_CSR4 () {	0x10;}
}
unless(defined(&RAL_CSR5)) {
    sub RAL_CSR5 () {	0x14;}
}
unless(defined(&RAL_CSR6)) {
    sub RAL_CSR6 () {	0x18;}
}
unless(defined(&RAL_CSR7)) {
    sub RAL_CSR7 () {	0x1c;}
}
unless(defined(&RAL_CSR8)) {
    sub RAL_CSR8 () {	0x20;}
}
unless(defined(&RAL_CSR9)) {
    sub RAL_CSR9 () {	0x24;}
}
unless(defined(&RAL_CSR11)) {
    sub RAL_CSR11 () {	0x2c;}
}
unless(defined(&RAL_CSR12)) {
    sub RAL_CSR12 () {	0x30;}
}
unless(defined(&RAL_CSR13)) {
    sub RAL_CSR13 () {	0x34;}
}
unless(defined(&RAL_CSR14)) {
    sub RAL_CSR14 () {	0x38;}
}
unless(defined(&RAL_CSR15)) {
    sub RAL_CSR15 () {	0x3c;}
}
unless(defined(&RAL_CSR16)) {
    sub RAL_CSR16 () {	0x40;}
}
unless(defined(&RAL_CSR17)) {
    sub RAL_CSR17 () {	0x44;}
}
unless(defined(&RAL_CSR18)) {
    sub RAL_CSR18 () {	0x48;}
}
unless(defined(&RAL_CSR19)) {
    sub RAL_CSR19 () {	0x4c;}
}
unless(defined(&RAL_CSR20)) {
    sub RAL_CSR20 () {	0x50;}
}
unless(defined(&RAL_CSR21)) {
    sub RAL_CSR21 () {	0x54;}
}
unless(defined(&RAL_CSR22)) {
    sub RAL_CSR22 () {	0x58;}
}
unless(defined(&RAL_SECCSR0)) {
    sub RAL_SECCSR0 () {	0x28;}
}
unless(defined(&RAL_SECCSR1)) {
    sub RAL_SECCSR1 () {	0x158;}
}
unless(defined(&RAL_SECCSR3)) {
    sub RAL_SECCSR3 () {	0xfc;}
}
unless(defined(&RAL_TXCSR0)) {
    sub RAL_TXCSR0 () {	0x60;}
}
unless(defined(&RAL_TXCSR1)) {
    sub RAL_TXCSR1 () {	0x64;}
}
unless(defined(&RAL_TXCSR2)) {
    sub RAL_TXCSR2 () {	0x68;}
}
unless(defined(&RAL_TXCSR3)) {
    sub RAL_TXCSR3 () {	0x6c;}
}
unless(defined(&RAL_TXCSR4)) {
    sub RAL_TXCSR4 () {	0x70;}
}
unless(defined(&RAL_TXCSR5)) {
    sub RAL_TXCSR5 () {	0x74;}
}
unless(defined(&RAL_TXCSR6)) {
    sub RAL_TXCSR6 () {	0x78;}
}
unless(defined(&RAL_TXCSR7)) {
    sub RAL_TXCSR7 () {	0x7c;}
}
unless(defined(&RAL_TXCSR8)) {
    sub RAL_TXCSR8 () {	0x98;}
}
unless(defined(&RAL_TXCSR9)) {
    sub RAL_TXCSR9 () {	0x94;}
}
unless(defined(&RAL_RXCSR0)) {
    sub RAL_RXCSR0 () {	0x80;}
}
unless(defined(&RAL_RXCSR1)) {
    sub RAL_RXCSR1 () {	0x84;}
}
unless(defined(&RAL_RXCSR2)) {
    sub RAL_RXCSR2 () {	0x88;}
}
unless(defined(&RAL_RXCSR3)) {
    sub RAL_RXCSR3 () {	0x90;}
}
unless(defined(&RAL_ARCSR1)) {
    sub RAL_ARCSR1 () {	0x9c;}
}
unless(defined(&RAL_PCICSR)) {
    sub RAL_PCICSR () {	0x8c;}
}
unless(defined(&RAL_CNT0)) {
    sub RAL_CNT0 () {	0xa0;}
}
unless(defined(&RAL_CNT1)) {
    sub RAL_CNT1 () {	0xac;}
}
unless(defined(&RAL_CNT2)) {
    sub RAL_CNT2 () {	0xb0;}
}
unless(defined(&RAL_CNT3)) {
    sub RAL_CNT3 () {	0xb8;}
}
unless(defined(&RAL_CNT4)) {
    sub RAL_CNT4 () {	0xbc;}
}
unless(defined(&RAL_CNT5)) {
    sub RAL_CNT5 () {	0xc0;}
}
unless(defined(&RAL_PWRCSR0)) {
    sub RAL_PWRCSR0 () {	0xc4;}
}
unless(defined(&RAL_PSCSR0)) {
    sub RAL_PSCSR0 () {	0xc8;}
}
unless(defined(&RAL_PSCSR1)) {
    sub RAL_PSCSR1 () {	0xcc;}
}
unless(defined(&RAL_PSCSR2)) {
    sub RAL_PSCSR2 () {	0xd0;}
}
unless(defined(&RAL_PSCSR3)) {
    sub RAL_PSCSR3 () {	0xd4;}
}
unless(defined(&RAL_PWRCSR1)) {
    sub RAL_PWRCSR1 () {	0xd8;}
}
unless(defined(&RAL_TIMECSR)) {
    sub RAL_TIMECSR () {	0xdc;}
}
unless(defined(&RAL_MACCSR0)) {
    sub RAL_MACCSR0 () {	0xe0;}
}
unless(defined(&RAL_MACCSR1)) {
    sub RAL_MACCSR1 () {	0xe4;}
}
unless(defined(&RAL_RALINKCSR)) {
    sub RAL_RALINKCSR () {	0xe8;}
}
unless(defined(&RAL_BCNCSR)) {
    sub RAL_BCNCSR () {	0xec;}
}
unless(defined(&RAL_BBPCSR)) {
    sub RAL_BBPCSR () {	0xf0;}
}
unless(defined(&RAL_RFCSR)) {
    sub RAL_RFCSR () {	0xf4;}
}
unless(defined(&RAL_LEDCSR)) {
    sub RAL_LEDCSR () {	0xf8;}
}
unless(defined(&RAL_TXACKCSR0)) {
    sub RAL_TXACKCSR0 () {	0x110;}
}
unless(defined(&RAL_ACKCNT0)) {
    sub RAL_ACKCNT0 () {	0x114;}
}
unless(defined(&RAL_ACKCNT1)) {
    sub RAL_ACKCNT1 () {	0x118;}
}
unless(defined(&RAL_GPIOCSR)) {
    sub RAL_GPIOCSR () {	0x120;}
}
unless(defined(&RAL_FIFOCSR0)) {
    sub RAL_FIFOCSR0 () {	0x128;}
}
unless(defined(&RAL_FIFOCSR1)) {
    sub RAL_FIFOCSR1 () {	0x12c;}
}
unless(defined(&RAL_BCNCSR1)) {
    sub RAL_BCNCSR1 () {	0x130;}
}
unless(defined(&RAL_MACCSR2)) {
    sub RAL_MACCSR2 () {	0x134;}
}
unless(defined(&RAL_TESTCSR)) {
    sub RAL_TESTCSR () {	0x138;}
}
unless(defined(&RAL_ARCSR2)) {
    sub RAL_ARCSR2 () {	0x13c;}
}
unless(defined(&RAL_ARCSR3)) {
    sub RAL_ARCSR3 () {	0x140;}
}
unless(defined(&RAL_ARCSR4)) {
    sub RAL_ARCSR4 () {	0x144;}
}
unless(defined(&RAL_ARCSR5)) {
    sub RAL_ARCSR5 () {	0x148;}
}
unless(defined(&RAL_ARTCSR0)) {
    sub RAL_ARTCSR0 () {	0x14c;}
}
unless(defined(&RAL_ARTCSR1)) {
    sub RAL_ARTCSR1 () {	0x150;}
}
unless(defined(&RAL_ARTCSR2)) {
    sub RAL_ARTCSR2 () {	0x154;}
}
unless(defined(&RAL_SECCSR1)) {
    sub RAL_SECCSR1 () {	0x158;}
}
unless(defined(&RAL_BBPCSR1)) {
    sub RAL_BBPCSR1 () {	0x15c;}
}
unless(defined(&RAL_CSR1_SOFT_RESET)) {
    sub RAL_CSR1_SOFT_RESET () {	(1<< 0);}
}
unless(defined(&RAL_CSR1_HOST_READY)) {
    sub RAL_CSR1_HOST_READY () {	(1<< 2);}
}
unless(defined(&RAL_CSR21_93C46)) {
    sub RAL_CSR21_93C46 () {	(1<< 5);}
}
unless(defined(&RAL_TXCSR0_KICK_TX)) {
    sub RAL_TXCSR0_KICK_TX () {	(1<< 0);}
}
unless(defined(&RAL_TXCSR0_KICK_ATIM)) {
    sub RAL_TXCSR0_KICK_ATIM () {	(1<< 1);}
}
unless(defined(&RAL_TXCSR0_KICK_PRIO)) {
    sub RAL_TXCSR0_KICK_PRIO () {	(1<< 2);}
}
unless(defined(&RAL_TXCSR0_ABORT)) {
    sub RAL_TXCSR0_ABORT () {	(1<< 3);}
}
unless(defined(&RAL_RXCSR0_DISABLE)) {
    sub RAL_RXCSR0_DISABLE () {	(1<< 0);}
}
unless(defined(&RAL_RXCSR0_DROP_CRC)) {
    sub RAL_RXCSR0_DROP_CRC () {	(1<< 1);}
}
unless(defined(&RAL_RXCSR0_DROP_PHY)) {
    sub RAL_RXCSR0_DROP_PHY () {	(1<< 2);}
}
unless(defined(&RAL_RXCSR0_DROP_CTL)) {
    sub RAL_RXCSR0_DROP_CTL () {	(1<< 3);}
}
unless(defined(&RAL_RXCSR0_DROP_NOT_TO_ME)) {
    sub RAL_RXCSR0_DROP_NOT_TO_ME () {	(1<< 4);}
}
unless(defined(&RAL_RXCSR0_DROP_TODS)) {
    sub RAL_RXCSR0_DROP_TODS () {	(1<< 5);}
}
unless(defined(&RAL_RXCSR0_DROP_BAD_VERSION)) {
    sub RAL_RXCSR0_DROP_BAD_VERSION () {	(1<< 6);}
}
unless(defined(&RAL_SECCSR0_KICK)) {
    sub RAL_SECCSR0_KICK () {	(1<< 0);}
}
unless(defined(&RAL_SECCSR1_KICK)) {
    sub RAL_SECCSR1_KICK () {	(1<< 0);}
}
unless(defined(&RAL_CSR7_BEACON_EXPIRE)) {
    sub RAL_CSR7_BEACON_EXPIRE () {	0x1;}
}
unless(defined(&RAL_CSR7_WAKEUP_EXPIRE)) {
    sub RAL_CSR7_WAKEUP_EXPIRE () {	0x2;}
}
unless(defined(&RAL_CSR7_ATIM_EXPIRE)) {
    sub RAL_CSR7_ATIM_EXPIRE () {	0x4;}
}
unless(defined(&RAL_CSR7_TX_DONE)) {
    sub RAL_CSR7_TX_DONE () {	0x8;}
}
unless(defined(&RAL_CSR7_ATIM_DONE)) {
    sub RAL_CSR7_ATIM_DONE () {	0x10;}
}
unless(defined(&RAL_CSR7_PRIO_DONE)) {
    sub RAL_CSR7_PRIO_DONE () {	0x20;}
}
unless(defined(&RAL_CSR7_RX_DONE)) {
    sub RAL_CSR7_RX_DONE () {	0x40;}
}
unless(defined(&RAL_CSR7_DECRYPTION_DONE)) {
    sub RAL_CSR7_DECRYPTION_DONE () {	0x80;}
}
unless(defined(&RAL_CSR7_ENCRYPTION_DONE)) {
    sub RAL_CSR7_ENCRYPTION_DONE () {	0x100;}
}
unless(defined(&RAL_CSR8_MASK)) {
    sub RAL_CSR8_MASK () {	(~( &RAL_CSR7_BEACON_EXPIRE |  &RAL_CSR7_WAKEUP_EXPIRE |  &RAL_CSR7_TX_DONE |  &RAL_CSR7_PRIO_DONE |  &RAL_CSR7_RX_DONE |  &RAL_CSR7_DECRYPTION_DONE |  &RAL_CSR7_ENCRYPTION_DONE));}
}
unless(defined(&RAL_CSR14_TSF_AUTOCOUNT)) {
    sub RAL_CSR14_TSF_AUTOCOUNT () {	(1<< 0);}
}
unless(defined(&RAL_CSR14_TSF_SYNC_BSS)) {
    sub RAL_CSR14_TSF_SYNC_BSS () {	(1<< 1);}
}
unless(defined(&RAL_CSR14_TSF_SYNC_IBSS)) {
    sub RAL_CSR14_TSF_SYNC_IBSS () {	(2<< 1);}
}
unless(defined(&RAL_CSR14_BCN_RELOAD)) {
    sub RAL_CSR14_BCN_RELOAD () {	(1<< 3);}
}
unless(defined(&RAL_CSR14_GENERATE_BEACON)) {
    sub RAL_CSR14_GENERATE_BEACON () {	(1<< 6);}
}
unless(defined(&RAL_CSR14_PRELOAD_SHIFT)) {
    sub RAL_CSR14_PRELOAD_SHIFT () {	16;}
}
unless(defined(&RAL_TX_BUSY)) {
    sub RAL_TX_BUSY () {	(1<< 0);}
}
unless(defined(&RAL_TX_VALID)) {
    sub RAL_TX_VALID () {	(1<< 1);}
}
unless(defined(&RAL_TX_RESULT_MASK)) {
    sub RAL_TX_RESULT_MASK () {	0x1c;}
}
unless(defined(&RAL_TX_SUCCESS)) {
    sub RAL_TX_SUCCESS () {	(0<< 2);}
}
unless(defined(&RAL_TX_SUCCESS_RETRY)) {
    sub RAL_TX_SUCCESS_RETRY () {	(1<< 2);}
}
unless(defined(&RAL_TX_FAIL_RETRY)) {
    sub RAL_TX_FAIL_RETRY () {	(2<< 2);}
}
unless(defined(&RAL_TX_FAIL_INVALID)) {
    sub RAL_TX_FAIL_INVALID () {	(3<< 2);}
}
unless(defined(&RAL_TX_FAIL_OTHER)) {
    sub RAL_TX_FAIL_OTHER () {	(4<< 2);}
}
unless(defined(&RAL_TX_NOT_LAST)) {
    sub RAL_TX_NOT_LAST () {	(1<< 8);}
}
unless(defined(&RAL_TX_NEED_ACK)) {
    sub RAL_TX_NEED_ACK () {	(1<< 9);}
}
unless(defined(&RAL_TX_INSERT_TIMESTAMP)) {
    sub RAL_TX_INSERT_TIMESTAMP () {	(1<< 10);}
}
unless(defined(&RAL_TX_OFDM)) {
    sub RAL_TX_OFDM () {	(1<< 11);}
}
unless(defined(&RAL_TX_CIPHER_BUSY)) {
    sub RAL_TX_CIPHER_BUSY () {	(1<< 12);}
}
unless(defined(&RAL_TX_IFS_MASK)) {
    sub RAL_TX_IFS_MASK () {	0x6000;}
}
unless(defined(&RAL_TX_IFS_BACKOFF)) {
    sub RAL_TX_IFS_BACKOFF () {	(0<< 13);}
}
unless(defined(&RAL_TX_IFS_SIFS)) {
    sub RAL_TX_IFS_SIFS () {	(1<< 13);}
}
unless(defined(&RAL_TX_IFS_NEW_BACKOFF)) {
    sub RAL_TX_IFS_NEW_BACKOFF () {	(2<< 13);}
}
unless(defined(&RAL_TX_IFS_NONE)) {
    sub RAL_TX_IFS_NONE () {	(3<< 13);}
}
unless(defined(&RAL_TX_LONG_RETRY)) {
    sub RAL_TX_LONG_RETRY () {	(1<< 15);}
}
unless(defined(&RAL_TX_CIPHER_MASK)) {
    sub RAL_TX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RAL_TX_CIPHER_NONE)) {
    sub RAL_TX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RAL_TX_CIPHER_WEP40)) {
    sub RAL_TX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RAL_TX_CIPHER_WEP104)) {
    sub RAL_TX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RAL_TX_CIPHER_TKIP)) {
    sub RAL_TX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RAL_TX_CIPHER_AES)) {
    sub RAL_TX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RAL_WME_CWMAX_BITS_SHIFT)) {
    sub RAL_WME_CWMAX_BITS_SHIFT () {	12;}
}
unless(defined(&RAL_WME_CWMIN_BITS_SHIFT)) {
    sub RAL_WME_CWMIN_BITS_SHIFT () {	8;}
}
unless(defined(&RAL_WME_AIFSN_BITS_SHIFT)) {
    sub RAL_WME_AIFSN_BITS_SHIFT () {	6;}
}
unless(defined(&RAL_PLCP_LENGEXT)) {
    sub RAL_PLCP_LENGEXT () {	0x80;}
}
unless(defined(&RAL_RX_BUSY)) {
    sub RAL_RX_BUSY () {	(1<< 0);}
}
unless(defined(&RAL_RX_CRC_ERROR)) {
    sub RAL_RX_CRC_ERROR () {	(1<< 5);}
}
unless(defined(&RAL_RX_PHY_ERROR)) {
    sub RAL_RX_PHY_ERROR () {	(1<< 7);}
}
unless(defined(&RAL_RX_CIPHER_BUSY)) {
    sub RAL_RX_CIPHER_BUSY () {	(1<< 8);}
}
unless(defined(&RAL_RX_ICV_ERROR)) {
    sub RAL_RX_ICV_ERROR () {	(1<< 9);}
}
unless(defined(&RAL_RX_CIPHER_MASK)) {
    sub RAL_RX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RAL_RX_CIPHER_NONE)) {
    sub RAL_RX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RAL_RX_CIPHER_WEP40)) {
    sub RAL_RX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RAL_RX_CIPHER_WEP104)) {
    sub RAL_RX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RAL_RX_CIPHER_TKIP)) {
    sub RAL_RX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RAL_RX_CIPHER_AES)) {
    sub RAL_RX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RAL_RF1)) {
    sub RAL_RF1 () {	0;}
}
unless(defined(&RAL_RF2)) {
    sub RAL_RF2 () {	2;}
}
unless(defined(&RAL_RF3)) {
    sub RAL_RF3 () {	1;}
}
unless(defined(&RAL_RF4)) {
    sub RAL_RF4 () {	3;}
}
unless(defined(&RAL_RF1_AUTOTUNE)) {
    sub RAL_RF1_AUTOTUNE () {	0x8000;}
}
unless(defined(&RAL_RF3_AUTOTUNE)) {
    sub RAL_RF3_AUTOTUNE () {	0x40;}
}
unless(defined(&RAL_BBP_BUSY)) {
    sub RAL_BBP_BUSY () {	(1<< 15);}
}
unless(defined(&RAL_BBP_WRITE)) {
    sub RAL_BBP_WRITE () {	(1<< 16);}
}
unless(defined(&RAL_RF_BUSY)) {
    sub RAL_RF_BUSY () {	(1<< 31);}
}
unless(defined(&RAL_RF_20BIT)) {
    sub RAL_RF_20BIT () {	(20<< 24);}
}
unless(defined(&RAL_RF_2522)) {
    sub RAL_RF_2522 () {	0x;}
}
unless(defined(&RAL_RF_2523)) {
    sub RAL_RF_2523 () {	0x1;}
}
unless(defined(&RAL_RF_2524)) {
    sub RAL_RF_2524 () {	0x2;}
}
unless(defined(&RAL_RF_2525)) {
    sub RAL_RF_2525 () {	0x3;}
}
unless(defined(&RAL_RF_2525E)) {
    sub RAL_RF_2525E () {	0x4;}
}
unless(defined(&RAL_RF_5222)) {
    sub RAL_RF_5222 () {	0x10;}
}
unless(defined(&RAL_BBP_VERSION)) {
    sub RAL_BBP_VERSION () {	0;}
}
unless(defined(&RAL_LED_MODE_DEFAULT)) {
    sub RAL_LED_MODE_DEFAULT () {	0;}
}
unless(defined(&RAL_LED_MODE_TXRX_ACTIVITY)) {
    sub RAL_LED_MODE_TXRX_ACTIVITY () {	1;}
}
unless(defined(&RAL_LED_MODE_SINGLE)) {
    sub RAL_LED_MODE_SINGLE () {	2;}
}
unless(defined(&RAL_LED_MODE_ASUS)) {
    sub RAL_LED_MODE_ASUS () {	3;}
}
unless(defined(&RAL_JAPAN_FILTER)) {
    sub RAL_JAPAN_FILTER () {	0x8;}
}
unless(defined(&RAL_EEPROM_ANTENNA)) {
    sub RAL_EEPROM_ANTENNA () {	16;}
}
unless(defined(&RAL_EEPROM_CONFIG)) {
    sub RAL_EEPROM_CONFIG () {	17;}
}
unless(defined(&RAL_EEPROM_COUNTRY)) {
    sub RAL_EEPROM_COUNTRY () {	18;}
}
unless(defined(&RAL_EEPROM_BBP_BASE)) {
    sub RAL_EEPROM_BBP_BASE () {	19;}
}
unless(defined(&RAL_EEPROM_TXPOWER_BASE)) {
    sub RAL_EEPROM_TXPOWER_BASE () {	35;}
}
unless(defined(&RAL_EEPROM_TSSI_BASE)) {
    sub RAL_EEPROM_TSSI_BASE () {	42;}
}
unless(defined(&RAL_EEPROM_RSSITODBM)) {
    sub RAL_EEPROM_RSSITODBM () {	62;}
}
unless(defined(&RAL_EEPROM_VERSION)) {
    sub RAL_EEPROM_VERSION () {	63;}
}
unless(defined(&RAL_EEPROM_DELAY)) {
    sub RAL_EEPROM_DELAY () {	1;}
}
unless(defined(&RAL_EEPROM_C)) {
    sub RAL_EEPROM_C () {	(1<< 1);}
}
unless(defined(&RAL_EEPROM_S)) {
    sub RAL_EEPROM_S () {	(1<< 2);}
}
unless(defined(&RAL_EEPROM_D)) {
    sub RAL_EEPROM_D () {	(1<< 3);}
}
unless(defined(&RAL_EEPROM_Q)) {
    sub RAL_EEPROM_Q () {	(1<< 4);}
}
unless(defined(&RAL_EEPROM_SHIFT_D)) {
    sub RAL_EEPROM_SHIFT_D () {	3;}
}
unless(defined(&RAL_EEPROM_SHIFT_Q)) {
    sub RAL_EEPROM_SHIFT_Q () {	4;}
}
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RAL_EEPROM_CTL)) {
    sub RAL_EEPROM_CTL {
	local($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RAL_CSR21, ($val));  &DELAY( &RAL_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
