require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_UVM_UVM_MAP_H_)) {
    eval 'sub _UVM_UVM_MAP_H_ () {1;}' unless defined(&_UVM_UVM_MAP_H_);
    if(defined(&_KERNEL)) {
	eval 'sub UVM_MAP_CLIP_START {
	    local($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) > ($ENTRY)-> &start)  &uvm_map_clip_start($MAP,$ENTRY,$VA); });
	}' unless defined(&UVM_MAP_CLIP_START);
	eval 'sub UVM_MAP_CLIP_END {
	    local($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) < ($ENTRY)-> &end)  &uvm_map_clip_end($MAP,$ENTRY,$VA); });
	}' unless defined(&UVM_MAP_CLIP_END);
	eval 'sub UVM_EXTRACT_REMOVE () {0x1;}' unless defined(&UVM_EXTRACT_REMOVE);
	eval 'sub UVM_EXTRACT_CONTIG () {0x2;}' unless defined(&UVM_EXTRACT_CONTIG);
	eval 'sub UVM_EXTRACT_QREF () {0x4;}' unless defined(&UVM_EXTRACT_QREF);
	eval 'sub UVM_EXTRACT_FIXPROT () {0x8;}' unless defined(&UVM_EXTRACT_FIXPROT);
    }
    require 'uvm/uvm_anon.ph';
    eval 'sub uvm_map_entry_stop_copy () { &flags;}' unless defined(&uvm_map_entry_stop_copy);
    eval 'sub UVM_MAP_STATIC () {0x1;}' unless defined(&UVM_MAP_STATIC);
    eval 'sub UVM_MAP_KMEM () {0x2;}' unless defined(&UVM_MAP_KMEM);
    eval 'sub VM_MAPENT_ISWIRED {
        local($entry) = @_;
	    eval q((($entry)-> &wired_count != 0));
    }' unless defined(&VM_MAPENT_ISWIRED);
    eval 'sub min_offset () { ($header->{start});}' unless defined(&min_offset);
    eval 'sub max_offset () { ($header->{end});}' unless defined(&max_offset);
    eval 'sub VM_MAP_PAGEABLE () {0x1;}' unless defined(&VM_MAP_PAGEABLE);
    eval 'sub VM_MAP_INTRSAFE () {0x2;}' unless defined(&VM_MAP_INTRSAFE);
    eval 'sub VM_MAP_WIREFUTURE () {0x4;}' unless defined(&VM_MAP_WIREFUTURE);
    eval 'sub VM_MAP_BUSY () {0x8;}' unless defined(&VM_MAP_BUSY);
    eval 'sub VM_MAP_WANTLOCK () {0x10;}' unless defined(&VM_MAP_WANTLOCK);
    if(defined( &__i386__) || defined( &__amd64__) || defined ( &__sparc64__)) {
	eval 'sub _MAX_KMAPENT () {2000;}' unless defined(&_MAX_KMAPENT);
    } else {
	eval 'sub _MAX_KMAPENT () {1000;}' unless defined(&_MAX_KMAPENT);
    }
    if(!defined( &MAX_KMAPENT)) {
	if((50+ (2* (defined(&NPROC) ? &NPROC : 0)) > (defined(&_MAX_KMAPENT) ? &_MAX_KMAPENT : 0))) {
	    eval 'sub MAX_KMAPENT () {(50+ (2*  &NPROC));}' unless defined(&MAX_KMAPENT);
	} else {
	    eval 'sub MAX_KMAPENT () { &_MAX_KMAPENT;}' unless defined(&MAX_KMAPENT);
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub vm_map_modflags {
	    local($map, $set, $clear) = @_;
    	    eval q( &do {  &simple_lock(($map)-> &flags_lock); ($map)-> &flags = (($map)-> &flags | ($set)) & ~($clear);  &simple_unlock(($map)-> &flags_lock); }  &while (0));
	}' unless defined(&vm_map_modflags);
    }
    if(defined(&_KERNEL)) {
	eval 'sub vmi_list_lock {
	    eval q({ \'int\'  &s;  &s =  &splhigh();  &simple_lock( &vmi_list_slock); ( &s); });
	}' unless defined(&vmi_list_lock);
	eval 'sub vmi_list_unlock {
	    local($s) = @_;
    	    eval q(; {  &simple_unlock( &vmi_list_slock);  &splx($s); });
	}' unless defined(&vmi_list_unlock);
    }
    if(defined(&UVM_MAP_INLINE)) {
	eval 'sub MAP_INLINE () { &static  &__inline;}' unless defined(&MAP_INLINE);
    } else {
	eval 'sub MAP_INLINE () {1;}' unless defined(&MAP_INLINE);
    }
    if(defined(&_KERNEL)) {
	if(defined(&PMAP_GROWKERNEL)) {
	}
    }
    if(defined(&_KERNEL)) {
	require 'sys/time.ph';
	require 'sys/proc.ph';
	require 'sys/systm.ph';
	eval 'sub vm_map_lock_try {
	    local($map) = @_;
    	    eval q(; {  &boolean_t  &rv;  &if ( ($map->{flags}) &  &VM_MAP_INTRSAFE)  &rv =  &simple_lock_try( ($map->{lock}->{lk_interlock}));  &else {  &simple_lock( ($map->{flags_lock}));  &if ( ($map->{flags}) &  &VM_MAP_BUSY) {  &simple_unlock( ($map->{flags_lock})); ( &FALSE); }  &rv = ( &lockmgr( ($map->{lock}),  &LK_EXCLUSIVE| &LK_NOWAIT| &LK_INTERLOCK,  ($map->{flags_lock}),  &curproc) == 0); }  &if ( &rv)  ($map->{timestamp})++; ( &rv); });
	}' unless defined(&vm_map_lock_try);
	eval 'sub vm_map_lock {
	    local($map) = @_;
    	    eval q(; { \'int\'  &error;  &if ( ($map->{flags}) &  &VM_MAP_INTRSAFE) {  &simple_lock( ($map->{lock}->{lk_interlock})); ; }  &try_again:  &simple_lock( ($map->{flags_lock}));  &while ( ($map->{flags}) &  &VM_MAP_BUSY) {  ($map->{flags}) |=  &VM_MAP_WANTLOCK;  &ltsleep( ($map->{flags}),  &PVM,  &vmmapbsy, 0,  ($map->{flags_lock})); }  &error =  &lockmgr( ($map->{lock}),  &LK_EXCLUSIVE| &LK_SLEEPFAIL| &LK_INTERLOCK,  ($map->{flags_lock}),  &curproc);  &if ( &error) {  &goto  &try_again; } ($map)-> &timestamp++; });
	}' unless defined(&vm_map_lock);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub vm_map_lock_read {
	        local($map) = @_;
    		eval q( &do {  &if ( ($map->{flags}) &  &VM_MAP_INTRSAFE)  &panic(\\"vm_map_lock_read: intrsafe map\\"); ( &void)  &lockmgr(($map)-> &lock,  &LK_SHARED,  &NULL,  &curproc); }  &while (0));
	    }' unless defined(&vm_map_lock_read);
	} else {
	    eval 'sub vm_map_lock_read {
	        local($map) = @_;
    		eval q(( &void)  &lockmgr(($map)-> &lock,  &LK_SHARED,  &NULL,  &curproc));
	    }' unless defined(&vm_map_lock_read);
	}
	eval 'sub vm_map_unlock {
	    local($map) = @_;
    	    eval q( &do {  &if (($map)-> &flags &  &VM_MAP_INTRSAFE)  &simple_unlock(($map)-> ($lock->{lk_interlock}));  &else ( &void)  &lockmgr(($map)-> &lock,  &LK_RELEASE,  &NULL,  &curproc);}  &while (0));
	}' unless defined(&vm_map_unlock);
	eval 'sub vm_map_unlock_read {
	    local($map) = @_;
    	    eval q(( &void)  &lockmgr(($map)-> &lock,  &LK_RELEASE,  &NULL,  &curproc));
	}' unless defined(&vm_map_unlock_read);
	eval 'sub vm_map_downgrade {
	    local($map) = @_;
    	    eval q(( &void)  &lockmgr(($map)-> &lock,  &LK_DOWNGRADE,  &NULL,  &curproc));
	}' unless defined(&vm_map_downgrade);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub vm_map_upgrade {
	        local($map) = @_;
    		eval q( &do {  &if ( &lockmgr(($map)-> &lock,  &LK_UPGRADE,  &NULL,  &curproc) != 0)  &panic(\\"vm_map_upgrade: failed to upgrade lock\\"); }  &while (0));
	    }' unless defined(&vm_map_upgrade);
	} else {
	    eval 'sub vm_map_upgrade {
	        local($map) = @_;
    		eval q(( &void)  &lockmgr(($map)-> &lock,  &LK_UPGRADE,  &NULL,  &curproc));
	    }' unless defined(&vm_map_upgrade);
	}
	eval 'sub vm_map_busy {
	    local($map) = @_;
    	    eval q( &do {  &simple_lock(($map)-> &flags_lock); ($map)-> &flags |=  &VM_MAP_BUSY;  &simple_unlock(($map)-> &flags_lock); }  &while (0));
	}' unless defined(&vm_map_busy);
	eval 'sub vm_map_unbusy {
	    local($map) = @_;
    	    eval q( &do { \'int\'  &oflags;  &simple_lock(($map)-> &flags_lock);  &oflags = ($map)-> &flags; ($map)-> &flags &= ~( &VM_MAP_BUSY| &VM_MAP_WANTLOCK);  &simple_unlock(($map)-> &flags_lock);  &if ( &oflags &  &VM_MAP_WANTLOCK)  &wakeup(($map)-> &flags); }  &while (0));
	}' unless defined(&vm_map_unbusy);
    }
    eval 'sub vm_map_min {
        local($map) = @_;
	    eval q((($map)-> &min_offset));
    }' unless defined(&vm_map_min);
    eval 'sub vm_map_max {
        local($map) = @_;
	    eval q((($map)-> &max_offset));
    }' unless defined(&vm_map_max);
    eval 'sub vm_map_pmap {
        local($map) = @_;
	    eval q((($map)-> &pmap));
    }' unless defined(&vm_map_pmap);
}
1;
