require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__KAME_NETINET_IN_H_INCLUDED_)) {
    die("do not include netinet6/in6.h directly, include netinet/in.h.  see RFC2553");
}
unless(defined(&_NETINET6_IN6_H_)) {
    eval 'sub _NETINET6_IN6_H_ () {1;}' unless defined(&_NETINET6_IN6_H_);
    eval 'sub __KAME__ () {1;}' unless defined(&__KAME__);
    eval 'sub __KAME_VERSION () {"OpenBSD-current";}' unless defined(&__KAME_VERSION);
    eval 'sub IPV6PORT_RESERVED () {1024;}' unless defined(&IPV6PORT_RESERVED);
    eval 'sub IPV6PORT_ANONMIN () {49152;}' unless defined(&IPV6PORT_ANONMIN);
    eval 'sub IPV6PORT_ANONMAX () {65535;}' unless defined(&IPV6PORT_ANONMAX);
    eval 'sub IPV6PORT_RESERVEDMIN () {600;}' unless defined(&IPV6PORT_RESERVEDMIN);
    eval 'sub IPV6PORT_RESERVEDMAX () {( &IPV6PORT_RESERVED-1);}' unless defined(&IPV6PORT_RESERVEDMAX);
    eval 'sub s6_addr () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr);
    if(defined(&_KERNEL)) {
	eval 'sub s6_addr8 () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr8);
	eval 'sub s6_addr16 () { ($__u6_addr->{__u6_addr16});}' unless defined(&s6_addr16);
	eval 'sub s6_addr32 () { ($__u6_addr->{__u6_addr32});}' unless defined(&s6_addr32);
    }
    eval 'sub INET6_ADDRSTRLEN () {46;}' unless defined(&INET6_ADDRSTRLEN);
    unless(defined(&_XOPEN_SOURCE)) {
	eval 'sub SIN6_LEN () {1;}' unless defined(&SIN6_LEN);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6MASK0 () {{{{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}};}' unless defined(&IN6MASK0);
	eval 'sub IN6MASK32 () {{{{ 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK32);
	eval 'sub IN6MASK64 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK64);
	eval 'sub IN6MASK96 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK96);
	eval 'sub IN6MASK128 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff }}};}' unless defined(&IN6MASK128);
    }
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	    eval 'sub IPV6_ADDR_INT32_ONE () {1;}' unless defined(&IPV6_ADDR_INT32_ONE);
	    eval 'sub IPV6_ADDR_INT32_TWO () {2;}' unless defined(&IPV6_ADDR_INT32_TWO);
	    eval 'sub IPV6_ADDR_INT32_MNL () {0xff010000;}' unless defined(&IPV6_ADDR_INT32_MNL);
	    eval 'sub IPV6_ADDR_INT32_MLL () {0xff020000;}' unless defined(&IPV6_ADDR_INT32_MLL);
	    eval 'sub IPV6_ADDR_INT32_SMP () {0xffff;}' unless defined(&IPV6_ADDR_INT32_SMP);
	    eval 'sub IPV6_ADDR_INT16_ULL () {0xfe80;}' unless defined(&IPV6_ADDR_INT16_ULL);
	    eval 'sub IPV6_ADDR_INT16_USL () {0xfec0;}' unless defined(&IPV6_ADDR_INT16_USL);
	    eval 'sub IPV6_ADDR_INT16_MLL () {0xff02;}' unless defined(&IPV6_ADDR_INT16_MLL);
	}
 elsif((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
	    eval 'sub IPV6_ADDR_INT32_ONE () {0x1000000;}' unless defined(&IPV6_ADDR_INT32_ONE);
	    eval 'sub IPV6_ADDR_INT32_TWO () {0x2000000;}' unless defined(&IPV6_ADDR_INT32_TWO);
	    eval 'sub IPV6_ADDR_INT32_MNL () {0x1ff;}' unless defined(&IPV6_ADDR_INT32_MNL);
	    eval 'sub IPV6_ADDR_INT32_MLL () {0x2ff;}' unless defined(&IPV6_ADDR_INT32_MLL);
	    eval 'sub IPV6_ADDR_INT32_SMP () {0xffff0000;}' unless defined(&IPV6_ADDR_INT32_SMP);
	    eval 'sub IPV6_ADDR_INT16_ULL () {0x80fe;}' unless defined(&IPV6_ADDR_INT16_ULL);
	    eval 'sub IPV6_ADDR_INT16_USL () {0xc0fe;}' unless defined(&IPV6_ADDR_INT16_USL);
	    eval 'sub IPV6_ADDR_INT16_MLL () {0x2ff;}' unless defined(&IPV6_ADDR_INT16_MLL);
	}
    }
    eval 'sub IN6ADDR_ANY_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6ADDR_ANY_INIT);
    eval 'sub IN6ADDR_LOOPBACK_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LOOPBACK_INIT);
    eval 'sub IN6ADDR_NODELOCAL_ALLNODES_INIT () {{{{ 0xff, 0x1, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_NODELOCAL_ALLNODES_INIT);
    eval 'sub IN6ADDR_LINKLOCAL_ALLNODES_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLNODES_INIT);
    eval 'sub IN6ADDR_LINKLOCAL_ALLROUTERS_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x2 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLROUTERS_INIT);
    if(defined(&_KERNEL)) {
	eval 'sub IN6_ARE_ADDR_EQUAL {
	    local($a, $b) = @_;
    	    eval q(( &bcmp(($a)-> $s6_addr[0], ($b)-> $s6_addr[0], $sizeof{\'struct in6_addr\'}) == 0));
	}' unless defined(&IN6_ARE_ADDR_EQUAL);
    } else {
	eval 'sub IN6_ARE_ADDR_EQUAL {
	    local($a, $b) = @_;
    	    eval q(( &memcmp(($a)-> $s6_addr[0], ($b)-> $s6_addr[0], $sizeof{\'struct in6_addr\'}) == 0));
	}' unless defined(&IN6_ARE_ADDR_EQUAL);
    }
    eval 'sub IN6_IS_ADDR_UNSPECIFIED {
        local($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) == 0)));
    }' unless defined(&IN6_IS_ADDR_UNSPECIFIED);
    eval 'sub IN6_IS_ADDR_LOOPBACK {
        local($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) ==  &ntohl(1))));
    }' unless defined(&IN6_IS_ADDR_LOOPBACK);
    eval 'sub IN6_IS_ADDR_V4COMPAT {
        local($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) != 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[12]) !=  &ntohl(1))));
    }' unless defined(&IN6_IS_ADDR_V4COMPAT);
    eval 'sub IN6_IS_ADDR_V4MAPPED {
        local($a) = @_;
	    eval q(((*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[0]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[4]) == 0)  && (*( &const  &u_int32_t *)( &const  &void *)(($a)-> $s6_addr[8]) ==  &ntohl(0xffff))));
    }' unless defined(&IN6_IS_ADDR_V4MAPPED);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_ADDR_SCOPE_NODELOCAL () {0x1;}' unless defined(&IPV6_ADDR_SCOPE_NODELOCAL);
	eval 'sub IPV6_ADDR_SCOPE_LINKLOCAL () {0x2;}' unless defined(&IPV6_ADDR_SCOPE_LINKLOCAL);
	eval 'sub IPV6_ADDR_SCOPE_SITELOCAL () {0x5;}' unless defined(&IPV6_ADDR_SCOPE_SITELOCAL);
	eval 'sub IPV6_ADDR_SCOPE_ORGLOCAL () {0x8;}' unless defined(&IPV6_ADDR_SCOPE_ORGLOCAL);
	eval 'sub IPV6_ADDR_SCOPE_GLOBAL () {0xe;}' unless defined(&IPV6_ADDR_SCOPE_GLOBAL);
    } else {
	eval 'sub __IPV6_ADDR_SCOPE_NODELOCAL () {0x1;}' unless defined(&__IPV6_ADDR_SCOPE_NODELOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_LINKLOCAL () {0x2;}' unless defined(&__IPV6_ADDR_SCOPE_LINKLOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_SITELOCAL () {0x5;}' unless defined(&__IPV6_ADDR_SCOPE_SITELOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_ORGLOCAL () {0x8;}' unless defined(&__IPV6_ADDR_SCOPE_ORGLOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_GLOBAL () {0xe;}' unless defined(&__IPV6_ADDR_SCOPE_GLOBAL);
    }
    eval 'sub IN6_IS_ADDR_LINKLOCAL {
        local($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0x80)));
    }' unless defined(&IN6_IS_ADDR_LINKLOCAL);
    eval 'sub IN6_IS_ADDR_SITELOCAL {
        local($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0xc0)));
    }' unless defined(&IN6_IS_ADDR_SITELOCAL);
    eval 'sub IN6_IS_ADDR_MULTICAST {
        local($a) = @_;
	    eval q((($a)-> $s6_addr[0] == 0xff));
    }' unless defined(&IN6_IS_ADDR_MULTICAST);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_ADDR_MC_SCOPE {
	    local($a) = @_;
    	    eval q((($a)-> $s6_addr[1] & 0xf));
	}' unless defined(&IPV6_ADDR_MC_SCOPE);
    } else {
	eval 'sub __IPV6_ADDR_MC_SCOPE {
	    local($a) = @_;
    	    eval q((($a)-> $s6_addr[1] & 0xf));
	}' unless defined(&__IPV6_ADDR_MC_SCOPE);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6_IS_ADDR_MC_NODELOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_NODELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_NODELOCAL);
	eval 'sub IN6_IS_ADDR_MC_LINKLOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_LINKLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_LINKLOCAL);
	eval 'sub IN6_IS_ADDR_MC_SITELOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_SITELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_SITELOCAL);
	eval 'sub IN6_IS_ADDR_MC_ORGLOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_ORGLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_ORGLOCAL);
	eval 'sub IN6_IS_ADDR_MC_GLOBAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_GLOBAL)));
	}' unless defined(&IN6_IS_ADDR_MC_GLOBAL);
    } else {
	eval 'sub IN6_IS_ADDR_MC_NODELOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_NODELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_NODELOCAL);
	eval 'sub IN6_IS_ADDR_MC_LINKLOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_LINKLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_LINKLOCAL);
	eval 'sub IN6_IS_ADDR_MC_SITELOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_SITELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_SITELOCAL);
	eval 'sub IN6_IS_ADDR_MC_ORGLOCAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_ORGLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_ORGLOCAL);
	eval 'sub IN6_IS_ADDR_MC_GLOBAL {
	    local($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_GLOBAL)));
	}' unless defined(&IN6_IS_ADDR_MC_GLOBAL);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6_IS_SCOPE_LINKLOCAL {
	    local($a) = @_;
    	    eval q((( &IN6_IS_ADDR_LINKLOCAL($a)) || ( &IN6_IS_ADDR_MC_LINKLOCAL($a))));
	}' unless defined(&IN6_IS_SCOPE_LINKLOCAL);
	eval 'sub IFA6_IS_DEPRECATED {
	    local($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_pltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_second - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_pltime})));
	}' unless defined(&IFA6_IS_DEPRECATED);
	eval 'sub IFA6_IS_INVALID {
	    local($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_vltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_second - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_vltime})));
	}' unless defined(&IFA6_IS_INVALID);
    }
    unless(defined(&_XOPEN_SOURCE)) {
    }
    eval 'sub IPV6_OPTIONS () {1;}' unless defined(&IPV6_OPTIONS);
    eval 'sub IPV6_SOCKOPT_RESERVED1 () {3;}' unless defined(&IPV6_SOCKOPT_RESERVED1);
    eval 'sub IPV6_UNICAST_HOPS () {4;}' unless defined(&IPV6_UNICAST_HOPS);
    eval 'sub IPV6_RECVOPTS () {5;}' unless defined(&IPV6_RECVOPTS);
    eval 'sub IPV6_RECVRETOPTS () {6;}' unless defined(&IPV6_RECVRETOPTS);
    eval 'sub IPV6_RECVDSTADDR () {7;}' unless defined(&IPV6_RECVDSTADDR);
    eval 'sub IPV6_RETOPTS () {8;}' unless defined(&IPV6_RETOPTS);
    eval 'sub IPV6_MULTICAST_IF () {9;}' unless defined(&IPV6_MULTICAST_IF);
    eval 'sub IPV6_MULTICAST_HOPS () {10;}' unless defined(&IPV6_MULTICAST_HOPS);
    eval 'sub IPV6_MULTICAST_LOOP () {11;}' unless defined(&IPV6_MULTICAST_LOOP);
    eval 'sub IPV6_JOIN_GROUP () {12;}' unless defined(&IPV6_JOIN_GROUP);
    eval 'sub IPV6_LEAVE_GROUP () {13;}' unless defined(&IPV6_LEAVE_GROUP);
    eval 'sub IPV6_PORTRANGE () {14;}' unless defined(&IPV6_PORTRANGE);
    eval 'sub ICMP6_FILTER () {18;}' unless defined(&ICMP6_FILTER);
    eval 'sub IPV6_PKTINFO () {19;}' unless defined(&IPV6_PKTINFO);
    eval 'sub IPV6_HOPLIMIT () {20;}' unless defined(&IPV6_HOPLIMIT);
    eval 'sub IPV6_NEXTHOP () {21;}' unless defined(&IPV6_NEXTHOP);
    eval 'sub IPV6_HOPOPTS () {22;}' unless defined(&IPV6_HOPOPTS);
    eval 'sub IPV6_DSTOPTS () {23;}' unless defined(&IPV6_DSTOPTS);
    eval 'sub IPV6_RTHDR () {24;}' unless defined(&IPV6_RTHDR);
    eval 'sub IPV6_PKTOPTIONS () {25;}' unless defined(&IPV6_PKTOPTIONS);
    eval 'sub IPV6_CHECKSUM () {26;}' unless defined(&IPV6_CHECKSUM);
    eval 'sub IPV6_V6ONLY () {27;}' unless defined(&IPV6_V6ONLY);
    if(0) {
	eval 'sub IPV6_IPSEC_POLICY () {28;}' unless defined(&IPV6_IPSEC_POLICY);
    }
    eval 'sub IPV6_FAITH () {29;}' unless defined(&IPV6_FAITH);
    eval 'sub IPV6_USE_MIN_MTU () {42;}' unless defined(&IPV6_USE_MIN_MTU);
    eval 'sub IPV6_AUTH_LEVEL () {53;}' unless defined(&IPV6_AUTH_LEVEL);
    eval 'sub IPV6_ESP_TRANS_LEVEL () {54;}' unless defined(&IPV6_ESP_TRANS_LEVEL);
    eval 'sub IPV6_ESP_NETWORK_LEVEL () {55;}' unless defined(&IPV6_ESP_NETWORK_LEVEL);
    eval 'sub IPSEC6_OUTSA () {56;}' unless defined(&IPSEC6_OUTSA);
    eval 'sub IPV6_IPCOMP_LEVEL () {60;}' unless defined(&IPV6_IPCOMP_LEVEL);
    eval 'sub IPV6_RTHDR_LOOSE () {0;}' unless defined(&IPV6_RTHDR_LOOSE);
    eval 'sub IPV6_RTHDR_STRICT () {1;}' unless defined(&IPV6_RTHDR_STRICT);
    eval 'sub IPV6_RTHDR_TYPE_0 () {0;}' unless defined(&IPV6_RTHDR_TYPE_0);
    eval 'sub IPV6_DEFAULT_MULTICAST_HOPS () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_HOPS);
    eval 'sub IPV6_DEFAULT_MULTICAST_LOOP () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_LOOP);
    eval 'sub IPV6_PORTRANGE_DEFAULT () {0;}' unless defined(&IPV6_PORTRANGE_DEFAULT);
    eval 'sub IPV6_PORTRANGE_HIGH () {1;}' unless defined(&IPV6_PORTRANGE_HIGH);
    eval 'sub IPV6_PORTRANGE_LOW () {2;}' unless defined(&IPV6_PORTRANGE_LOW);
    unless(defined(&_XOPEN_SOURCE)) {
	eval 'sub IPV6PROTO_MAXID () {( &IPPROTO_PIM + 1);}' unless defined(&IPV6PROTO_MAXID);
	eval 'sub CTL_IPV6PROTO_NAMES () {{ { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "tcp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "udp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "ip6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "ipsec6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "icmp6",  &CTLTYPE_NODE }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "pim6",  &CTLTYPE_NODE }, };}' unless defined(&CTL_IPV6PROTO_NAMES);
	eval 'sub IPV6CTL_FORWARDING () {1;}' unless defined(&IPV6CTL_FORWARDING);
	eval 'sub IPV6CTL_SENDREDIRECTS () {2;}' unless defined(&IPV6CTL_SENDREDIRECTS);
	eval 'sub IPV6CTL_DEFHLIM () {3;}' unless defined(&IPV6CTL_DEFHLIM);
	if(defined(&notyet)) {
	    eval 'sub IPV6CTL_DEFMTU () {4;}' unless defined(&IPV6CTL_DEFMTU);
	}
	eval 'sub IPV6CTL_FORWSRCRT () {5;}' unless defined(&IPV6CTL_FORWSRCRT);
	eval 'sub IPV6CTL_STATS () {6;}' unless defined(&IPV6CTL_STATS);
	eval 'sub IPV6CTL_MRTSTATS () {7;}' unless defined(&IPV6CTL_MRTSTATS);
	eval 'sub IPV6CTL_MRTPROTO () {8;}' unless defined(&IPV6CTL_MRTPROTO);
	eval 'sub IPV6CTL_MAXFRAGPACKETS () {9;}' unless defined(&IPV6CTL_MAXFRAGPACKETS);
	eval 'sub IPV6CTL_SOURCECHECK () {10;}' unless defined(&IPV6CTL_SOURCECHECK);
	eval 'sub IPV6CTL_SOURCECHECK_LOGINT () {11;}' unless defined(&IPV6CTL_SOURCECHECK_LOGINT);
	eval 'sub IPV6CTL_ACCEPT_RTADV () {12;}' unless defined(&IPV6CTL_ACCEPT_RTADV);
	eval 'sub IPV6CTL_KEEPFAITH () {13;}' unless defined(&IPV6CTL_KEEPFAITH);
	eval 'sub IPV6CTL_LOG_INTERVAL () {14;}' unless defined(&IPV6CTL_LOG_INTERVAL);
	eval 'sub IPV6CTL_HDRNESTLIMIT () {15;}' unless defined(&IPV6CTL_HDRNESTLIMIT);
	eval 'sub IPV6CTL_DAD_COUNT () {16;}' unless defined(&IPV6CTL_DAD_COUNT);
	eval 'sub IPV6CTL_AUTO_FLOWLABEL () {17;}' unless defined(&IPV6CTL_AUTO_FLOWLABEL);
	eval 'sub IPV6CTL_DEFMCASTHLIM () {18;}' unless defined(&IPV6CTL_DEFMCASTHLIM);
	if(defined(&notdef)) {
	    eval 'sub IPV6CTL_GIF_HLIM () {19;}' unless defined(&IPV6CTL_GIF_HLIM);
	}
	eval 'sub IPV6CTL_KAME_VERSION () {20;}' unless defined(&IPV6CTL_KAME_VERSION);
	eval 'sub IPV6CTL_USE_DEPRECATED () {21;}' unless defined(&IPV6CTL_USE_DEPRECATED);
	eval 'sub IPV6CTL_RR_PRUNE () {22;}' unless defined(&IPV6CTL_RR_PRUNE);
	eval 'sub IPV6CTL_V6ONLY () {24;}' unless defined(&IPV6CTL_V6ONLY);
	eval 'sub IPV6CTL_MAXFRAGS () {41;}' unless defined(&IPV6CTL_MAXFRAGS);
	eval 'sub IPV6CTL_MAXID () {42;}' unless defined(&IPV6CTL_MAXID);
	eval 'sub IPV6CTL_NAMES () {{ { 0, 0}, { "forwarding",  &CTLTYPE_INT }, { "redirect",  &CTLTYPE_INT }, { "hlim",  &CTLTYPE_INT }, { "mtu",  &CTLTYPE_INT }, { "forwsrcrt",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { "mrtproto",  &CTLTYPE_INT }, { "maxfragpackets",  &CTLTYPE_INT }, { "sourcecheck",  &CTLTYPE_INT }, { "sourcecheck_logint",  &CTLTYPE_INT }, { "accept_rtadv",  &CTLTYPE_INT }, { "keepfaith",  &CTLTYPE_INT }, { "log_interval",  &CTLTYPE_INT }, { "hdrnestlimit",  &CTLTYPE_INT }, { "dad_count",  &CTLTYPE_INT }, { "auto_flowlabel",  &CTLTYPE_INT }, { "defmcasthlim",  &CTLTYPE_INT }, { 0, 0}, { "kame_version",  &CTLTYPE_STRING }, { "use_deprecated",  &CTLTYPE_INT }, { "rr_prune",  &CTLTYPE_INT }, { 0, 0}, { "v6only",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "maxfrags",  &CTLTYPE_INT }, };}' unless defined(&IPV6CTL_NAMES);
	eval 'sub IPV6CTL_VARS () {{  &NULL,  &ip6_forwarding,  &ip6_sendredirects,  &ip6_defhlim,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &ip6_maxfragpackets,  &NULL,  &NULL,  &ip6_accept_rtadv,  &ip6_keepfaith,  &ip6_log_interval,  &ip6_hdrnestlimit,  &ip6_dad_count,  &ip6_auto_flowlabel,  &ip6_defmcasthlim,  &NULL,  &NULL,  &ip6_use_deprecated,  &ip6_rr_prune,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &NULL,  &ip6_maxfrags, };}' unless defined(&IPV6CTL_VARS);
    }
    if(defined(&_KERNEL)) {
	eval 'sub satosin6 {
	    local($sa) = @_;
    	    eval q((($sa)));
	}' unless defined(&satosin6);
	eval 'sub sin6tosa {
	    local($sin6) = @_;
    	    eval q((($sin6)));
	}' unless defined(&sin6tosa);
	eval 'sub ifatoia6 {
	    local($ifa) = @_;
    	    eval q((($ifa)));
	}' unless defined(&ifatoia6);
    }
    if(0) {
    }
}
1;
