require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&GDT_MAXBUS)) {
    sub GDT_MAXBUS () {	6;}
}
unless(defined(&GDT_MAX_HDRIVES)) {
    sub GDT_MAX_HDRIVES () {	35;}
}
unless(defined(&GDT_MAXID)) {
    sub GDT_MAXID () {	127;}
}
unless(defined(&GDT_MAXOFFSETS)) {
    sub GDT_MAXOFFSETS () {	128;}
}
unless(defined(&GDT_MAXSG)) {
    sub GDT_MAXSG () {	128;}
}
unless(defined(&GDT_PROTOCOL_VERSION)) {
    sub GDT_PROTOCOL_VERSION () {	1;}
}
unless(defined(&GDT_LINUX_OS)) {
    sub GDT_LINUX_OS () {	8;}
}
unless(defined(&GDT_SCATTER_GATHER)) {
    sub GDT_SCATTER_GATHER () {	1;}
}
unless(defined(&GDT_SECS32)) {
    sub GDT_SECS32 () {	0x1f;}
}
unless(defined(&GDT_LOCALBOARD)) {
    sub GDT_LOCALBOARD () {	0;}
}
unless(defined(&GDT_MAXCMDS)) {
    sub GDT_MAXCMDS () {	124;}
}
unless(defined(&GDT_SECTOR_SIZE)) {
    sub GDT_SECTOR_SIZE () {	0x200;}
}
unless(defined(&GDT_MPR_MAGIC)) {
    sub GDT_MPR_MAGIC () {	0xc0ffee11;}
}
unless(defined(&GDT_IC_HEADER_BYTES)) {
    sub GDT_IC_HEADER_BYTES () {	48;}
}
unless(defined(&GDT_IC_QUEUE_BYTES)) {
    sub GDT_IC_QUEUE_BYTES () {	4;}
}
unless(defined(&GDT_DPMEM_COMMAND_OFFSET)) {
    sub GDT_DPMEM_COMMAND_OFFSET () {	( &GDT_IC_HEADER_BYTES +  &GDT_IC_QUEUE_BYTES *  &GDT_MAXOFFSETS);}
}
if(1) {
    eval 'sub GDT_MAXCYLS () {1024;}' unless defined(&GDT_MAXCYLS);
    eval 'sub GDT_HEADS () {64;}' unless defined(&GDT_HEADS);
    eval 'sub GDT_SECS () {32;}' unless defined(&GDT_SECS);
    eval 'sub GDT_MEDHEADS () {127;}' unless defined(&GDT_MEDHEADS);
    eval 'sub GDT_MEDSECS () {63;}' unless defined(&GDT_MEDSECS);
    eval 'sub GDT_BIGHEADS () {255;}' unless defined(&GDT_BIGHEADS);
    eval 'sub GDT_BIGSECS () {63;}' unless defined(&GDT_BIGSECS);
}
unless(defined(&GDT_INIT)) {
    sub GDT_INIT () {	0;}
}
unless(defined(&GDT_READ)) {
    sub GDT_READ () {	1;}
}
unless(defined(&GDT_WRITE)) {
    sub GDT_WRITE () {	2;}
}
unless(defined(&GDT_INFO)) {
    sub GDT_INFO () {	3;}
}
unless(defined(&GDT_FLUSH)) {
    sub GDT_FLUSH () {	4;}
}
unless(defined(&GDT_IOCTL)) {
    sub GDT_IOCTL () {	5;}
}
unless(defined(&GDT_DEVTYPE)) {
    sub GDT_DEVTYPE () {	9;}
}
unless(defined(&GDT_MOUNT)) {
    sub GDT_MOUNT () {	10;}
}
unless(defined(&GDT_UNMOUNT)) {
    sub GDT_UNMOUNT () {	11;}
}
unless(defined(&GDT_SET_FEAT)) {
    sub GDT_SET_FEAT () {	12;}
}
unless(defined(&GDT_GET_FEAT)) {
    sub GDT_GET_FEAT () {	13;}
}
unless(defined(&GDT_WRITE_THR)) {
    sub GDT_WRITE_THR () {	16;}
}
unless(defined(&GDT_READ_THR)) {
    sub GDT_READ_THR () {	17;}
}
unless(defined(&GDT_EXT_INFO)) {
    sub GDT_EXT_INFO () {	18;}
}
unless(defined(&GDT_RESET)) {
    sub GDT_RESET () {	19;}
}
unless(defined(&GDT_RESERVE)) {
    sub GDT_RESERVE () {	14;}
}
unless(defined(&GDT_RELEASE)) {
    sub GDT_RELEASE () {	15;}
}
unless(defined(&GDT_RESERVE_ALL)) {
    sub GDT_RESERVE_ALL () {	16;}
}
unless(defined(&GDT_RELEASE_ALL)) {
    sub GDT_RELEASE_ALL () {	17;}
}
unless(defined(&GDT_RESET_BUS)) {
    sub GDT_RESET_BUS () {	18;}
}
unless(defined(&GDT_SCAN_START)) {
    sub GDT_SCAN_START () {	19;}
}
unless(defined(&GDT_SCAN_END)) {
    sub GDT_SCAN_END () {	20;}
}
unless(defined(&GDT_SCSI_DR_INFO)) {
    sub GDT_SCSI_DR_INFO () {	0x;}
}
unless(defined(&GDT_SCSI_CHAN_CNT)) {
    sub GDT_SCSI_CHAN_CNT () {	0x5;}
}
unless(defined(&GDT_SCSI_DR_LIST)) {
    sub GDT_SCSI_DR_LIST () {	0x6;}
}
unless(defined(&GDT_SCSI_DEF_CNT)) {
    sub GDT_SCSI_DEF_CNT () {	0x15;}
}
unless(defined(&GDT_DSK_STATISTICS)) {
    sub GDT_DSK_STATISTICS () {	0x4b;}
}
unless(defined(&GDT_IOCHAN_DESC)) {
    sub GDT_IOCHAN_DESC () {	0x5d;}
}
unless(defined(&GDT_IOCHAN_RAW_DESC)) {
    sub GDT_IOCHAN_RAW_DESC () {	0x5e;}
}
unless(defined(&GDT_L_CTRL_PATTERN)) {
    sub GDT_L_CTRL_PATTERN () {	0x20000000;}
}
unless(defined(&GDT_ARRAY_INFO)) {
    sub GDT_ARRAY_INFO () {	0x12;}
}
unless(defined(&GDT_ARRAY_DRV_LIST)) {
    sub GDT_ARRAY_DRV_LIST () {	0xf;}
}
unless(defined(&GDT_LA_CTRL_PATTERN)) {
    sub GDT_LA_CTRL_PATTERN () {	0x10000000;}
}
unless(defined(&GDT_CACHE_DRV_CNT)) {
    sub GDT_CACHE_DRV_CNT () {	0x1;}
}
unless(defined(&GDT_CACHE_DRV_LIST)) {
    sub GDT_CACHE_DRV_LIST () {	0x2;}
}
unless(defined(&GDT_CACHE_INFO)) {
    sub GDT_CACHE_INFO () {	0x4;}
}
unless(defined(&GDT_CACHE_CONFIG)) {
    sub GDT_CACHE_CONFIG () {	0x5;}
}
unless(defined(&GDT_CACHE_DRV_INFO)) {
    sub GDT_CACHE_DRV_INFO () {	0x7;}
}
unless(defined(&GDT_BOARD_FEATURES)) {
    sub GDT_BOARD_FEATURES () {	0x15;}
}
unless(defined(&GDT_BOARD_INFO)) {
    sub GDT_BOARD_INFO () {	0x28;}
}
unless(defined(&GDT_HOST_GET)) {
    sub GDT_HOST_GET () {	0x10001;}
}
unless(defined(&GDT_IO_CHANNEL)) {
    sub GDT_IO_CHANNEL () {	0x20000;}
}
unless(defined(&GDT_INVALID_CHANNEL)) {
    sub GDT_INVALID_CHANNEL () {	0xffff;}
}
unless(defined(&GDTIOCTL_MASK)) {
    sub GDTIOCTL_MASK () {	(ord('J') << 8);}
}
unless(defined(&GDTIOCTL_GENERAL)) {
    sub GDTIOCTL_GENERAL () {	( &GDTIOCTL_MASK | 0);}
}
unless(defined(&GDTIOCTL_DRVERS)) {
    sub GDTIOCTL_DRVERS () {	( &GDTIOCTL_MASK | 1);}
}
unless(defined(&GDTIOCTL_CTRTYPE)) {
    sub GDTIOCTL_CTRTYPE () {	( &GDTIOCTL_MASK | 2);}
}
unless(defined(&GDTIOCTL_CTRCNT)) {
    sub GDTIOCTL_CTRCNT () {	( &GDTIOCTL_MASK | 5);}
}
unless(defined(&GDTIOCTL_LOCKDRV)) {
    sub GDTIOCTL_LOCKDRV () {	( &GDTIOCTL_MASK | 6);}
}
unless(defined(&GDTIOCTL_LOCKCHN)) {
    sub GDTIOCTL_LOCKCHN () {	( &GDTIOCTL_MASK | 7);}
}
unless(defined(&GDTIOCTL_EVENT)) {
    sub GDTIOCTL_EVENT () {	( &GDTIOCTL_MASK | 8);}
}
unless(defined(&GDT_S_OK)) {
    sub GDT_S_OK () {	1;}
}
unless(defined(&GDT_S_BSY)) {
    sub GDT_S_BSY () {	7;}
}
unless(defined(&GDT_S_RAW_SCSI)) {
    sub GDT_S_RAW_SCSI () {	12;}
}
unless(defined(&GDT_S_RAW_ILL)) {
    sub GDT_S_RAW_ILL () {	0xff;}
}
unless(defined(&GDT_S_NO_STATUS)) {
    sub GDT_S_NO_STATUS () {	0x1000;}
}
unless(defined(&GDT_SCSIRAWSERVICE)) {
    sub GDT_SCSIRAWSERVICE () {	3;}
}
unless(defined(&GDT_CACHESERVICE)) {
    sub GDT_CACHESERVICE () {	9;}
}
unless(defined(&GDT_SCREENSERVICE)) {
    sub GDT_SCREENSERVICE () {	11;}
}
unless(defined(&GDT_SG_PTR)) {
    sub GDT_SG_PTR () {	0x;}
}
unless(defined(&GDT_SG_LEN)) {
    sub GDT_SG_LEN () {	0x4;}
}
unless(defined(&GDT_SG_SZ)) {
    sub GDT_SG_SZ () {	0x8;}
}
unless(defined(&GDT_CACHE_DEVICENO)) {
    sub GDT_CACHE_DEVICENO () {	0x;}
}
unless(defined(&GDT_CACHE_BLOCKNO)) {
    sub GDT_CACHE_BLOCKNO () {	0x2;}
}
unless(defined(&GDT_CACHE_BLOCKCNT)) {
    sub GDT_CACHE_BLOCKCNT () {	0x6;}
}
unless(defined(&GDT_CACHE_DESTADDR)) {
    sub GDT_CACHE_DESTADDR () {	0xa;}
}
unless(defined(&GDT_CACHE_SG_CANZ)) {
    sub GDT_CACHE_SG_CANZ () {	0xe;}
}
unless(defined(&GDT_CACHE_SG_LST)) {
    sub GDT_CACHE_SG_LST () {	0x12;}
}
unless(defined(&GDT_CACHE_SZ)) {
    sub GDT_CACHE_SZ () {	(0x12 +  &GDT_MAXSG *  &GDT_SG_SZ);}
}
unless(defined(&GDT_IOCTL_PARAM_SIZE)) {
    sub GDT_IOCTL_PARAM_SIZE () {	0x;}
}
unless(defined(&GDT_IOCTL_SUBFUNC)) {
    sub GDT_IOCTL_SUBFUNC () {	0x2;}
}
unless(defined(&GDT_IOCTL_CHANNEL)) {
    sub GDT_IOCTL_CHANNEL () {	0x6;}
}
unless(defined(&GDT_IOCTL_P_PARAM)) {
    sub GDT_IOCTL_P_PARAM () {	0xa;}
}
unless(defined(&GDT_IOCTL_SZ)) {
    sub GDT_IOCTL_SZ () {	0xe;}
}
unless(defined(&GDT_SCREEN_MSG_HANDLE)) {
    sub GDT_SCREEN_MSG_HANDLE () {	0x2;}
}
unless(defined(&GDT_SCREEN_MSG_ADDR)) {
    sub GDT_SCREEN_MSG_ADDR () {	0x6;}
}
unless(defined(&GDT_SCREEN_SZ)) {
    sub GDT_SCREEN_SZ () {	0xa;}
}
unless(defined(&GDT_RAW_DIRECTION)) {
    sub GDT_RAW_DIRECTION () {	0x2;}
}
unless(defined(&GDT_RAW_MDISC_TIME)) {
    sub GDT_RAW_MDISC_TIME () {	0x6;}
}
unless(defined(&GDT_RAW_MCON_TIME)) {
    sub GDT_RAW_MCON_TIME () {	0xa;}
}
unless(defined(&GDT_RAW_SDATA)) {
    sub GDT_RAW_SDATA () {	0xe;}
}
unless(defined(&GDT_RAW_SDLEN)) {
    sub GDT_RAW_SDLEN () {	0x12;}
}
unless(defined(&GDT_RAW_CLEN)) {
    sub GDT_RAW_CLEN () {	0x16;}
}
unless(defined(&GDT_RAW_CMD)) {
    sub GDT_RAW_CMD () {	0x1a;}
}
unless(defined(&GDT_RAW_TARGET)) {
    sub GDT_RAW_TARGET () {	0x26;}
}
unless(defined(&GDT_RAW_LUN)) {
    sub GDT_RAW_LUN () {	0x27;}
}
unless(defined(&GDT_RAW_BUS)) {
    sub GDT_RAW_BUS () {	0x28;}
}
unless(defined(&GDT_RAW_PRIORITY)) {
    sub GDT_RAW_PRIORITY () {	0x29;}
}
unless(defined(&GDT_RAW_SENSE_LEN)) {
    sub GDT_RAW_SENSE_LEN () {	0x2a;}
}
unless(defined(&GDT_RAW_SENSE_DATA)) {
    sub GDT_RAW_SENSE_DATA () {	0x2e;}
}
unless(defined(&GDT_RAW_SG_RANZ)) {
    sub GDT_RAW_SG_RANZ () {	0x36;}
}
unless(defined(&GDT_RAW_SG_LST)) {
    sub GDT_RAW_SG_LST () {	0x3a;}
}
unless(defined(&GDT_RAW_SZ)) {
    sub GDT_RAW_SZ () {	(0x3e +  &GDT_MAXSG *  &GDT_SG_SZ);}
}
unless(defined(&GDT_CMD_BOARDNODE)) {
    sub GDT_CMD_BOARDNODE () {	0x;}
}
unless(defined(&GDT_CMD_COMMANDINDEX)) {
    sub GDT_CMD_COMMANDINDEX () {	0x4;}
}
unless(defined(&GDT_CMD_OPCODE)) {
    sub GDT_CMD_OPCODE () {	0x8;}
}
unless(defined(&GDT_CMD_UNION)) {
    sub GDT_CMD_UNION () {	0xa;}
}
unless(defined(&GDT_CMD_UNION_SZ)) {
    sub GDT_CMD_UNION_SZ () {	 &GDT_RAW_SZ;}
}
unless(defined(&GDT_CMD_SZ)) {
    sub GDT_CMD_SZ () {	(0xa +  &GDT_CMD_UNION_SZ);}
}
unless(defined(&GDT_OFFSET)) {
    sub GDT_OFFSET () {	0x;}
}
unless(defined(&GDT_SERV_ID)) {
    sub GDT_SERV_ID () {	0x2;}
}
unless(defined(&GDT_COMM_Q_SZ)) {
    sub GDT_COMM_Q_SZ () {	0x4;}
}
unless(defined(&GDT_S_CMD_INDX)) {
    sub GDT_S_CMD_INDX () {	0x;}
}
unless(defined(&GDT_S_STATUS)) {
    sub GDT_S_STATUS () {	0x1;}
}
unless(defined(&GDT_S_INFO)) {
    sub GDT_S_INFO () {	0x4;}
}
unless(defined(&GDT_SEMA0)) {
    sub GDT_SEMA0 () {	0x14;}
}
unless(defined(&GDT_CMD_INDEX)) {
    sub GDT_CMD_INDEX () {	0x18;}
}
unless(defined(&GDT_STATUS)) {
    sub GDT_STATUS () {	0x1c;}
}
unless(defined(&GDT_SERVICE)) {
    sub GDT_SERVICE () {	0x1e;}
}
unless(defined(&GDT_DPR_INFO)) {
    sub GDT_DPR_INFO () {	0x20;}
}
unless(defined(&GDT_COMM_QUEUE)) {
    sub GDT_COMM_QUEUE () {	0x28;}
}
unless(defined(&GDT_DPR_CMD)) {
    sub GDT_DPR_CMD () {	(0x30 +  &GDT_MAXOFFSETS *  &GDT_COMM_Q_SZ);}
}
unless(defined(&GDT_DPR_IF_SZ)) {
    sub GDT_DPR_IF_SZ () {	 &GDT_DPR_CMD;}
}
unless(defined(&GDT_IOC_VERSION)) {
    sub GDT_IOC_VERSION () {	0x;}
}
unless(defined(&GDT_IOC_LIST_ENTRIES)) {
    sub GDT_IOC_LIST_ENTRIES () {	0x4;}
}
unless(defined(&GDT_IOC_FIRST_CHAN)) {
    sub GDT_IOC_FIRST_CHAN () {	0x5;}
}
unless(defined(&GDT_IOC_LAST_CHAN)) {
    sub GDT_IOC_LAST_CHAN () {	0x6;}
}
unless(defined(&GDT_IOC_CHAN_COUNT)) {
    sub GDT_IOC_CHAN_COUNT () {	0x7;}
}
unless(defined(&GDT_IOC_LIST_OFFSET)) {
    sub GDT_IOC_LIST_OFFSET () {	0x8;}
}
unless(defined(&GDT_IOC_HDR_SZ)) {
    sub GDT_IOC_HDR_SZ () {	0xc;}
}
unless(defined(&GDT_IOC_NEWEST)) {
    sub GDT_IOC_NEWEST () {	0xffffffff;}
}
unless(defined(&GDT_IOC_ADDRESS)) {
    sub GDT_IOC_ADDRESS () {	0x;}
}
unless(defined(&GDT_IOC_TYPE)) {
    sub GDT_IOC_TYPE () {	0x4;}
}
unless(defined(&GDT_IOC_LOCAL_NO)) {
    sub GDT_IOC_LOCAL_NO () {	0x5;}
}
unless(defined(&GDT_IOC_FEATURES)) {
    sub GDT_IOC_FEATURES () {	0x6;}
}
unless(defined(&GDT_IOC_SZ)) {
    sub GDT_IOC_SZ () {	0x8;}
}
unless(defined(&GDT_RAWIOC_PROC_ID)) {
    sub GDT_RAWIOC_PROC_ID () {	0x;}
}
unless(defined(&GDT_RAWIOC_PROC_DEFECT)) {
    sub GDT_RAWIOC_PROC_DEFECT () {	0x1;}
}
unless(defined(&GDT_RAWIOC_SZ)) {
    sub GDT_RAWIOC_SZ () {	0x4;}
}
unless(defined(&GDT_GETCH_CHANNEL_NO)) {
    sub GDT_GETCH_CHANNEL_NO () {	0x;}
}
unless(defined(&GDT_GETCH_DRIVE_CNT)) {
    sub GDT_GETCH_DRIVE_CNT () {	0x4;}
}
unless(defined(&GDT_GETCH_SIOP_ID)) {
    sub GDT_GETCH_SIOP_ID () {	0x8;}
}
unless(defined(&GDT_GETCH_SIOP_STATE)) {
    sub GDT_GETCH_SIOP_STATE () {	0x9;}
}
unless(defined(&GDT_GETCH_SZ)) {
    sub GDT_GETCH_SZ () {	0xa;}
}
unless(defined(&GDT_CPAR_VERSION)) {
    sub GDT_CPAR_VERSION () {	0x;}
}
unless(defined(&GDT_CPAR_STATE)) {
    sub GDT_CPAR_STATE () {	0x4;}
}
unless(defined(&GDT_CPAR_STRATEGY)) {
    sub GDT_CPAR_STRATEGY () {	0x6;}
}
unless(defined(&GDT_CPAR_WRITE_BACK)) {
    sub GDT_CPAR_WRITE_BACK () {	0x8;}
}
unless(defined(&GDT_CPAR_BLOCK_SIZE)) {
    sub GDT_CPAR_BLOCK_SIZE () {	0xa;}
}
unless(defined(&GDT_CPAR_SZ)) {
    sub GDT_CPAR_SZ () {	0xc;}
}
unless(defined(&GDT_CSTAT_CSIZE)) {
    sub GDT_CSTAT_CSIZE () {	0x;}
}
unless(defined(&GDT_CSTAT_READ_CNT)) {
    sub GDT_CSTAT_READ_CNT () {	0x4;}
}
unless(defined(&GDT_CSTAT_WRITE_CNT)) {
    sub GDT_CSTAT_WRITE_CNT () {	0x8;}
}
unless(defined(&GDT_CSTAT_TR_HITS)) {
    sub GDT_CSTAT_TR_HITS () {	0xc;}
}
unless(defined(&GDT_CSTAT_SEC_HITS)) {
    sub GDT_CSTAT_SEC_HITS () {	0x10;}
}
unless(defined(&GDT_CSTAT_SEC_MISS)) {
    sub GDT_CSTAT_SEC_MISS () {	0x14;}
}
unless(defined(&GDT_CSTAT_SZ)) {
    sub GDT_CSTAT_SZ () {	0x18;}
}
unless(defined(&GDT_CINFO_CPAR)) {
    sub GDT_CINFO_CPAR () {	0x;}
}
unless(defined(&GDT_CINFO_CSTAT)) {
    sub GDT_CINFO_CSTAT () {	 &GDT_CPAR_SZ;}
}
unless(defined(&GDT_CINFO_SZ)) {
    sub GDT_CINFO_SZ () {	( &GDT_CPAR_SZ +  &GDT_CSTAT_SZ);}
}
unless(defined(&GDT_BINFO_SER_NO)) {
    sub GDT_BINFO_SER_NO () {	0x;}
}
unless(defined(&GDT_BINFO_OEM_ID)) {
    sub GDT_BINFO_OEM_ID () {	0x4;}
}
unless(defined(&GDT_BINFO_EP_FLAGS)) {
    sub GDT_BINFO_EP_FLAGS () {	0x6;}
}
unless(defined(&GDT_BINFO_PROC_ID)) {
    sub GDT_BINFO_PROC_ID () {	0x8;}
}
unless(defined(&GDT_BINFO_MEMSIZE)) {
    sub GDT_BINFO_MEMSIZE () {	0xc;}
}
unless(defined(&GDT_BINFO_MEM_BANKS)) {
    sub GDT_BINFO_MEM_BANKS () {	0x10;}
}
unless(defined(&GDT_BINFO_CHAN_TYPE)) {
    sub GDT_BINFO_CHAN_TYPE () {	0x11;}
}
unless(defined(&GDT_BINFO_CHAN_COUNT)) {
    sub GDT_BINFO_CHAN_COUNT () {	0x12;}
}
unless(defined(&GDT_BINFO_RDONGLE_PRES)) {
    sub GDT_BINFO_RDONGLE_PRES () {	0x13;}
}
unless(defined(&GDT_BINFO_EPR_FW_VER)) {
    sub GDT_BINFO_EPR_FW_VER () {	0x14;}
}
unless(defined(&GDT_BINFO_UPD_FW_VER)) {
    sub GDT_BINFO_UPD_FW_VER () {	0x18;}
}
unless(defined(&GDT_BINFO_UPD_REVISION)) {
    sub GDT_BINFO_UPD_REVISION () {	0x1c;}
}
unless(defined(&GDT_BINFO_TYPE_STRING)) {
    sub GDT_BINFO_TYPE_STRING () {	0x20;}
}
unless(defined(&GDT_BINFO_RAID_STRING)) {
    sub GDT_BINFO_RAID_STRING () {	0x30;}
}
unless(defined(&GDT_BINFO_UPDATE_PRES)) {
    sub GDT_BINFO_UPDATE_PRES () {	0x40;}
}
unless(defined(&GDT_BINFO_XOR_PRES)) {
    sub GDT_BINFO_XOR_PRES () {	0x41;}
}
unless(defined(&GDT_BINFO_PROM_TYPE)) {
    sub GDT_BINFO_PROM_TYPE () {	0x42;}
}
unless(defined(&GDT_BINFO_PROM_COUNT)) {
    sub GDT_BINFO_PROM_COUNT () {	0x43;}
}
unless(defined(&GDT_BINFO_DUP_PRES)) {
    sub GDT_BINFO_DUP_PRES () {	0x44;}
}
unless(defined(&GDT_BINFO_CHAN_PRES)) {
    sub GDT_BINFO_CHAN_PRES () {	0x48;}
}
unless(defined(&GDT_BINFO_MEM_PRES)) {
    sub GDT_BINFO_MEM_PRES () {	0x4c;}
}
unless(defined(&GDT_BINFO_FT_BUS_SYSTEM)) {
    sub GDT_BINFO_FT_BUS_SYSTEM () {	0x50;}
}
unless(defined(&GDT_BINFO_SUBTYPE_VALID)) {
    sub GDT_BINFO_SUBTYPE_VALID () {	0x51;}
}
unless(defined(&GDT_BINFO_BOARD_SUBTYPE)) {
    sub GDT_BINFO_BOARD_SUBTYPE () {	0x52;}
}
unless(defined(&GDT_BINFO_RAMPAR_PRES)) {
    sub GDT_BINFO_RAMPAR_PRES () {	0x53;}
}
unless(defined(&GDT_BINFO_SZ)) {
    sub GDT_BINFO_SZ () {	0x54;}
}
unless(defined(&GDT_BFEAT_CHAINING)) {
    sub GDT_BFEAT_CHAINING () {	0x;}
}
unless(defined(&GDT_BFEAT_STRIPING)) {
    sub GDT_BFEAT_STRIPING () {	0x1;}
}
unless(defined(&GDT_BFEAT_MIRRORING)) {
    sub GDT_BFEAT_MIRRORING () {	0x2;}
}
unless(defined(&GDT_BFEAT_RAID)) {
    sub GDT_BFEAT_RAID () {	0x3;}
}
unless(defined(&GDT_BFEAT_SZ)) {
    sub GDT_BFEAT_SZ () {	0x4;}
}
unless(defined(&GDT_ASYNCINDEX)) {
    sub GDT_ASYNCINDEX () {	0;}
}
unless(defined(&GDT_SPEZINDEX)) {
    sub GDT_SPEZINDEX () {	1;}
}
1;
