<?php
/*
 * $Horde: kronolith/day.php,v 1.36.2.5 2003/04/04 19:23:53 chuck Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/DayView.php';

$month = Horde::getFormData('month');
$day = Horde::getFormData('mday');
$year = Horde::getFormData('year');
$timestamp = Horde::getFormData('timestamp');
$dayOb = &new Kronolith_DayView($month, $day, $year, $timestamp);
$title = $dayOb->getTime($prefs->getValue('date_format'));
$js_onLoad = null;

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require KRONOLITH_TEMPLATES . '/javascript/print.inc';
} else {
    $print_link = Kronolith::addParameter('day.php', 'month=' . $month);
    $print_link = Kronolith::addParameter($print_link, 'mday=' . $day);
    $print_link = Kronolith::addParameter($print_link, 'year=' . $year);
    $print_link = Kronolith::addParameter($print_link, 'timestamp=' . $timestamp);
    $print_link = Kronolith::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        include KRONOLITH_TEMPLATES . '/javascript/open_print_win.js';
    }

    require KRONOLITH_BASE . '/menu.php';
}

$dayOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';
