import gtk
from pynicotine.utils import _

class MainWindow:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.MainWindow = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.MainWindow.set_default_size(800, 600)
            self.MainWindow.set_title(_("Nicotine"))
            self.MainWindow.set_position(gtk.WIN_POS_CENTER)
            self.MainWindow.add_accel_group(self.accel_group)
            self.MainWindow.show()
            self.MainWindow.connect("selection_get", self.OnSelectionGet)
            self.MainWindow.connect("focus_in_event", self.OnFocusIn)
            self.MainWindow.connect("focus_out_event", self.OnFocusOut)

        self.vbox1 = gtk.VBox(gtk.FALSE, 0)
        self.vbox1.show()
        self.vbox1.set_spacing(0)

        self.menubar1 = gtk.MenuBar()
        self.menubar1.show()

        self.file1 = gtk.MenuItem(_("File"))
        self.file1.show()

        self.file1_menu = gtk.Menu()

        self.connect1 = gtk.MenuItem(_("Connect"))
        self.connect1.show()
        self.connect1.connect("activate", self.OnConnect)
        self.connect1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("c"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.connect1)

        self.disconnect1 = gtk.MenuItem(_("Disconnect"))
        self.disconnect1.show()
        self.disconnect1.connect("activate", self.OnDisconnect)
        self.disconnect1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("d"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.disconnect1)

        self.awayreturn1 = gtk.MenuItem(_("Away/Return"))
        self.awayreturn1.show()
        self.awayreturn1.connect("activate", self.OnAway)
        self.awayreturn1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("a"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.awayreturn1)

        self.check_privileges1 = gtk.MenuItem(_("Check privileges"))
        self.check_privileges1.show()
        self.check_privileges1.connect("activate", self.OnCheckPrivileges)

        self.file1_menu.append(self.check_privileges1)

        self.scheidingslijn1 = gtk.MenuItem()
        self.scheidingslijn1.show()

        self.file1_menu.append(self.scheidingslijn1)

        self.show_debug_info1 = gtk.CheckMenuItem(_("Show debug info"))
        self.show_debug_info1.show()
        self.show_debug_info1.connect("activate", self.OnShowDebug)

        self.file1_menu.append(self.show_debug_info1)

        self.scheidingslijn8 = gtk.MenuItem()
        self.scheidingslijn8.show()

        self.file1_menu.append(self.scheidingslijn8)

        self.hide_log_window1 = gtk.CheckMenuItem(_("Hide log window"))
        self.hide_log_window1.show()
        self.hide_log_window1.connect("activate", self.OnHideLog)
        self.hide_log_window1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("h"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.hide_log_window1)

        self.hide_room_list1 = gtk.CheckMenuItem(_("Hide room list"))
        self.hide_room_list1.show()
        self.hide_room_list1.connect("activate", self.OnHideRoomList)
        self.hide_room_list1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("r"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.hide_room_list1)

        self.scheidingslijn5 = gtk.MenuItem()
        self.scheidingslijn5.show()

        self.file1_menu.append(self.scheidingslijn5)

        self.settings1 = gtk.MenuItem(_("Settings"))
        self.settings1.show()
        self.settings1.connect("activate", self.OnSettings)

        self.file1_menu.append(self.settings1)

        self.scheidingslijn6 = gtk.MenuItem()
        self.scheidingslijn6.show()

        self.file1_menu.append(self.scheidingslijn6)

        self.rescan1 = gtk.MenuItem(_("Rescan shares"))
        self.rescan1.show()
        self.rescan1.connect("activate", self.OnRescan)

        self.file1_menu.append(self.rescan1)

        self.browse_my_shares1 = gtk.MenuItem(_("Browse my shares"))
        self.browse_my_shares1.show()
        self.browse_my_shares1.connect("activate", self.OnBrowseMyShares)

        self.file1_menu.append(self.browse_my_shares1)

        self.scheidingslijn2 = gtk.MenuItem()
        self.scheidingslijn2.show()

        self.file1_menu.append(self.scheidingslijn2)

        self.exit1 = gtk.MenuItem(_("Exit"))
        self.exit1.show()
        self.exit1.connect("activate", self.OnExit)
        self.exit1.add_accelerator("activate", self.accel_group, gtk.gdk.keyval_from_name("x"), gtk.gdk.MOD1_MASK, gtk.ACCEL_VISIBLE)

        self.file1_menu.append(self.exit1)

        self.file1.set_submenu(self.file1_menu)

        self.menubar1.append(self.file1)

        self.help1 = gtk.MenuItem(_("Help"))
        self.help1.show()

        self.help1_menu = gtk.Menu()

        self.about_chatroom_commands1 = gtk.MenuItem(_("About chat room commands"))
        self.about_chatroom_commands1.show()
        self.about_chatroom_commands1.connect("activate", self.OnAboutChatroomCommands)

        self.help1_menu.append(self.about_chatroom_commands1)

        self.about_private_chat_command1 = gtk.MenuItem(_("About private chat commands"))
        self.about_private_chat_command1.show()
        self.about_private_chat_command1.connect("activate", self.OnAboutPrivateChatCommands)

        self.help1_menu.append(self.about_private_chat_command1)

        self.scheidingslijn4 = gtk.MenuItem()
        self.scheidingslijn4.show()

        self.help1_menu.append(self.scheidingslijn4)

        self.abour_search_filters1 = gtk.MenuItem(_("About search filters"))
        self.abour_search_filters1.show()
        self.abour_search_filters1.connect("activate", self.OnAboutFilters)

        self.help1_menu.append(self.abour_search_filters1)

        self.scheidingslijn3 = gtk.MenuItem()
        self.scheidingslijn3.show()

        self.help1_menu.append(self.scheidingslijn3)

        self.check_latest1 = gtk.MenuItem(_("Check latest"))
        self.check_latest1.show()
        self.check_latest1.connect("activate", self.OnCheckLatest)

        self.help1_menu.append(self.check_latest1)

        self.scheidingslijn7 = gtk.MenuItem()
        self.scheidingslijn7.show()

        self.help1_menu.append(self.scheidingslijn7)

        self.about_nicotine1 = gtk.MenuItem(_("About Nicotine"))
        self.about_nicotine1.show()
        self.about_nicotine1.connect("activate", self.OnAbout)

        self.help1_menu.append(self.about_nicotine1)

        self.help1.set_submenu(self.help1_menu)

        self.menubar1.append(self.help1)

        self.vbox1.pack_start(self.menubar1, gtk.FALSE, gtk.FALSE, 0)

        self.vpaned1 = gtk.VPaned()
        self.vpaned1.show()

        self.notebook1 = gtk.Notebook()
        self.notebook1.set_size_request(0, 0)
        self.notebook1.set_tab_pos(gtk.POS_TOP)
        self.notebook1.set_scrollable(gtk.TRUE)
        self.notebook1.show()
        self.notebook1.connect("switch_page", self.OnSwitchPage)

        self.hpaned1 = gtk.HPaned()
        self.hpaned1.show()

        self.ChatNotebook = self.get_custom_widget("ChatNotebook", "", "", 0, 0)
        self.ChatNotebook.show()
        self.hpaned1.pack1(self.ChatNotebook, gtk.TRUE, gtk.TRUE)

        self.ChatTabLabel = self.get_custom_widget("ChatTabLabel", _("ImageLabel"), _("Chat rooms"), 0, 0)
        self.ChatTabLabel.show()
        self.PrivatechatNotebook = self.get_custom_widget("PrivatechatNotebook", "", "", 0, 0)
        self.PrivatechatNotebook.show()
        self.PrivateChatTabLabel = self.get_custom_widget("PrivateChatTabLabel", _("ImageLabel"), _("Private chat"), 0, 0)
        self.PrivateChatTabLabel.show()
        self.scrolledwindow4 = gtk.ScrolledWindow()
        self.scrolledwindow4.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow4.show()
        self.scrolledwindow4.set_shadow_type(gtk.SHADOW_NONE)

        self.viewport1 = gtk.Viewport()
        self.viewport1.show()
        self.viewport1.set_shadow_type(gtk.SHADOW_IN)

        self.scrolledwindow7 = gtk.ScrolledWindow()
        self.scrolledwindow7.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow7.show()
        self.scrolledwindow7.set_shadow_type(gtk.SHADOW_NONE)

        self.DownloadList = gtk.TreeView()
        self.DownloadList.show()
        self.DownloadList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow7.add(self.DownloadList)

        self.viewport1.add(self.scrolledwindow7)

        self.scrolledwindow4.add(self.viewport1)

        self.custom3 = self.get_custom_widget("custom3", _("ImageLabel"), _("Downloads"), 0, 0)
        self.custom3.show()
        self.scrolledwindow8 = gtk.ScrolledWindow()
        self.scrolledwindow8.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow8.show()
        self.scrolledwindow8.set_shadow_type(gtk.SHADOW_NONE)

        self.UploadList = gtk.TreeView()
        self.UploadList.show()
        self.UploadList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow8.add(self.UploadList)

        self.custom4 = self.get_custom_widget("custom4", _("ImageLabel"), _("Uploads"), 0, 0)
        self.custom4.show()
        self.vbox3 = gtk.VBox(gtk.FALSE, 0)
        self.vbox3.show()
        self.vbox3.set_spacing(0)

        self.hbox2 = gtk.HBox(gtk.FALSE, 0)
        self.hbox2.show()
        self.hbox2.set_spacing(0)

        self.combo1 = gtk.Combo()
        self.combo1.show()

        self.SearchEntry = self.combo1.entry
        self.SearchEntry.set_text("")
        self.SearchEntry.set_editable(gtk.TRUE)
        self.SearchEntry.show()
        self.SearchEntry.connect("activate", self.OnSearch)

        self.combo_list1 = self.combo1.list
        self.combo_list1.show()

        self.hbox2.pack_start(self.combo1, gtk.TRUE, gtk.TRUE, 0)

        self.GlobalRadio = gtk.RadioButton()
        self.GlobalRadio.set_label(_("Global"))
        self.GlobalRadio.show()

        self.hbox2.pack_start(self.GlobalRadio, gtk.FALSE, gtk.FALSE, 0)

        self.RoomsRadio = gtk.RadioButton(self.GlobalRadio)
        self.RoomsRadio.set_label(_("Rooms"))
        self.RoomsRadio.show()

        self.hbox2.pack_start(self.RoomsRadio, gtk.FALSE, gtk.FALSE, 0)

        self.BuddiesRadio = gtk.RadioButton(self.GlobalRadio)
        self.BuddiesRadio.set_label(_("Buddies"))
        self.BuddiesRadio.show()

        self.hbox2.pack_start(self.BuddiesRadio, gtk.FALSE, gtk.FALSE, 0)

        self.SearchButton = gtk.Button()
        self.SearchButton.set_label(_("Search"))
        self.SearchButton.show()
        self.SearchButton.connect("clicked", self.OnSearch)

        self.hbox2.pack_start(self.SearchButton, gtk.FALSE, gtk.FALSE, 0)

        self.vbox3.pack_start(self.hbox2, gtk.FALSE, gtk.TRUE, 0)

        self.SearchNotebook = self.get_custom_widget("SearchNotebook", "", "", 0, 0)
        self.SearchNotebook.show()
        self.vbox3.pack_start(self.SearchNotebook, gtk.TRUE, gtk.TRUE, 0)

        self.SearchTabLabel = self.get_custom_widget("SearchTabLabel", _("ImageLabel"), _("Search files"), 0, 0)
        self.SearchTabLabel.show()
        self.UserInfoNotebook = self.get_custom_widget("UserInfoNotebook", "", "", 0, 0)
        self.UserInfoNotebook.show()
        self.UserInfoTabLabel = self.get_custom_widget("UserInfoTabLabel", _("ImageLabel"), _("User info"), 0, 0)
        self.UserInfoTabLabel.show()
        self.UserBrowseNotebook = self.get_custom_widget("UserBrowseNotebook", "", "", 0, 0)
        self.UserBrowseNotebook.show()
        self.UserBrowseTabLabel = self.get_custom_widget("UserBrowseTabLabel", _("ImageLabel"), _("User browse"), 0, 0)
        self.UserBrowseTabLabel.show()
        self.interests = gtk.VBox(gtk.FALSE, 10)
        self.interests.show()
        self.interests.set_spacing(10)
        self.interests.set_border_width(10)

        self.hbox12 = gtk.HBox(gtk.FALSE, 5)
        self.hbox12.show()
        self.hbox12.set_spacing(5)

        self.button19 = gtk.Button()
        self.button19.set_label(_("Similar users"))
        self.button19.show()
        self.button19.connect("clicked", self.OnSimilarUsersClicked)

        self.hbox12.pack_end(self.button19, gtk.FALSE, gtk.FALSE, 0)

        self.button18 = gtk.Button()
        self.button18.set_label(_("Recommendations"))
        self.button18.show()
        self.button18.connect("clicked", self.OnRecommendationsClicked)

        self.hbox12.pack_end(self.button18, gtk.FALSE, gtk.FALSE, 0)

        self.button17 = gtk.Button()
        self.button17.set_label(_("Global recommendations"))
        self.button17.show()
        self.button17.connect("clicked", self.OnGlobalRecommendationsClicked)

        self.hbox12.pack_end(self.button17, gtk.FALSE, gtk.FALSE, 0)

        self.interests.pack_start(self.hbox12, gtk.FALSE, gtk.TRUE, 0)

        self.hbox11 = gtk.HBox(gtk.FALSE, 5)
        self.hbox11.show()
        self.hbox11.set_spacing(5)

        self.hpaned3 = gtk.HPaned()
        self.hpaned3.show()

        self.vbox13 = gtk.VBox(gtk.TRUE, 10)
        self.vbox13.set_size_request(200, -1)
        self.vbox13.show()
        self.vbox13.set_spacing(10)

        self.vbox14 = gtk.VBox(gtk.FALSE, 5)
        self.vbox14.show()
        self.vbox14.set_spacing(5)

        self.scrolledwindow23 = gtk.ScrolledWindow()
        self.scrolledwindow23.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow23.show()
        self.scrolledwindow23.set_shadow_type(gtk.SHADOW_IN)

        self.LikesList = gtk.TreeView()
        self.LikesList.show()
        self.LikesList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow23.add(self.LikesList)

        self.vbox14.pack_start(self.scrolledwindow23, gtk.TRUE, gtk.TRUE, 0)

        self.button15 = gtk.Button(None, gtk.STOCK_ADD)
        self.button15.show()
        self.button15.connect("clicked", self.OnAddThingILike)

        self.vbox14.pack_start(self.button15, gtk.FALSE, gtk.FALSE, 0)

        self.vbox13.pack_start(self.vbox14, gtk.TRUE, gtk.TRUE, 0)

        self.vbox15 = gtk.VBox(gtk.FALSE, 5)
        self.vbox15.show()
        self.vbox15.set_spacing(5)

        self.scrolledwindow24 = gtk.ScrolledWindow()
        self.scrolledwindow24.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow24.show()
        self.scrolledwindow24.set_shadow_type(gtk.SHADOW_IN)

        self.DislikesList = gtk.TreeView()
        self.DislikesList.show()
        self.DislikesList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow24.add(self.DislikesList)

        self.vbox15.pack_start(self.scrolledwindow24, gtk.TRUE, gtk.TRUE, 0)

        self.button16 = gtk.Button(None, gtk.STOCK_ADD)
        self.button16.show()
        self.button16.connect("clicked", self.OnAddThingIDislike)

        self.vbox15.pack_start(self.button16, gtk.FALSE, gtk.FALSE, 0)

        self.vbox13.pack_start(self.vbox15, gtk.TRUE, gtk.TRUE, 0)

        self.hpaned3.pack1(self.vbox13, gtk.FALSE, gtk.TRUE)

        self.hpaned4 = gtk.HPaned()
        self.hpaned4.show()

        self.scrolledwindow26 = gtk.ScrolledWindow()
        self.scrolledwindow26.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow26.show()
        self.scrolledwindow26.set_shadow_type(gtk.SHADOW_IN)

        self.RecommendationsList = gtk.TreeView()
        self.RecommendationsList.show()
        self.RecommendationsList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow26.add(self.RecommendationsList)

        self.hpaned4.pack1(self.scrolledwindow26, gtk.TRUE, gtk.TRUE)

        self.scrolledwindow27 = gtk.ScrolledWindow()
        self.scrolledwindow27.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow27.show()
        self.scrolledwindow27.set_shadow_type(gtk.SHADOW_IN)

        self.RecommendationUsersList = gtk.TreeView()
        self.RecommendationUsersList.show()
        self.RecommendationUsersList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow27.add(self.RecommendationUsersList)

        self.hpaned4.pack2(self.scrolledwindow27, gtk.TRUE, gtk.TRUE)

        self.hpaned3.pack2(self.hpaned4, gtk.TRUE, gtk.TRUE)

        self.hbox11.pack_start(self.hpaned3, gtk.TRUE, gtk.TRUE, 0)

        self.interests.pack_start(self.hbox11, gtk.TRUE, gtk.TRUE, 0)

        self.InterestsTabLabel = self.get_custom_widget("InterestsTabLabel", _("ImageLabel"), _("Interests"), 0, 0)
        self.InterestsTabLabel.show()
        self.vbox4 = gtk.VBox(gtk.FALSE, 5)
        self.vbox4.show()
        self.vbox4.set_spacing(5)
        self.vbox4.set_border_width(10)

        self.scrolledwindow11 = gtk.ScrolledWindow()
        self.scrolledwindow11.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow11.show()
        self.scrolledwindow11.set_shadow_type(gtk.SHADOW_NONE)

        self.UserList = gtk.TreeView()
        self.UserList.show()
        self.UserList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow11.add(self.UserList)

        self.vbox4.pack_start(self.scrolledwindow11, gtk.TRUE, gtk.TRUE, 0)

        self.hbox3 = gtk.HBox(gtk.FALSE, 0)
        self.hbox3.show()
        self.hbox3.set_spacing(0)

        self.label12 = gtk.Label(_("Add: "))
        self.label12.set_padding(0, 0)
        self.label12.show()
        self.hbox3.pack_start(self.label12, gtk.FALSE, gtk.FALSE, 0)

        self.AddUserEntry = gtk.Entry()
        self.AddUserEntry.set_text("")
        self.AddUserEntry.set_editable(gtk.TRUE)
        self.AddUserEntry.show()
        self.AddUserEntry.connect("activate", self.OnAddUser)
        self.hbox3.pack_start(self.AddUserEntry, gtk.TRUE, gtk.TRUE, 0)

        self.vbox4.pack_start(self.hbox3, gtk.FALSE, gtk.TRUE, 0)

        self.custom8 = self.get_custom_widget("custom8", _("ImageLabel"), _("User list"), 0, 0)
        self.custom8.show()
        self.notebook1.append_page(self.hpaned1, self.ChatTabLabel)

        self.notebook1.append_page(self.PrivatechatNotebook, self.PrivateChatTabLabel)

        self.notebook1.append_page(self.scrolledwindow4, self.custom3)

        self.notebook1.append_page(self.scrolledwindow8, self.custom4)

        self.notebook1.append_page(self.vbox3, self.SearchTabLabel)

        self.notebook1.append_page(self.UserInfoNotebook, self.UserInfoTabLabel)

        self.notebook1.append_page(self.UserBrowseNotebook, self.UserBrowseTabLabel)

        self.notebook1.append_page(self.interests, self.InterestsTabLabel)

        self.notebook1.append_page(self.vbox4, self.custom8)

        self.vpaned1.pack1(self.notebook1, gtk.TRUE, gtk.TRUE)

        self.vbox1.pack_start(self.vpaned1, gtk.TRUE, gtk.TRUE, 0)

        self.hbox10 = gtk.HBox(gtk.FALSE, 0)
        self.hbox10.show()
        self.hbox10.set_spacing(0)
        self.hbox10.set_border_width(2)

        self.Statusbar = gtk.Statusbar()
        self.Statusbar.set_has_resize_grip(gtk.FALSE)
        self.Statusbar.show()
        self.Statusbar.set_border_width(1)
        self.hbox10.pack_start(self.Statusbar, gtk.TRUE, gtk.TRUE, 0)

        self.UserStatus = gtk.Statusbar()
        self.UserStatus.set_size_request(100, -1)
        self.UserStatus.set_has_resize_grip(gtk.FALSE)
        self.UserStatus.show()
        self.UserStatus.set_border_width(1)
        self.hbox10.pack_start(self.UserStatus, gtk.FALSE, gtk.TRUE, 0)

        self.DownStatus = gtk.Statusbar()
        self.DownStatus.set_size_request(150, -1)
        self.DownStatus.set_has_resize_grip(gtk.FALSE)
        self.DownStatus.show()
        self.DownStatus.set_border_width(1)
        self.hbox10.pack_start(self.DownStatus, gtk.FALSE, gtk.TRUE, 0)

        self.UpStatus = gtk.Statusbar()
        self.UpStatus.set_size_request(150, -1)
        self.UpStatus.set_has_resize_grip(gtk.FALSE)
        self.UpStatus.show()
        self.UpStatus.set_border_width(1)
        self.hbox10.pack_start(self.UpStatus, gtk.FALSE, gtk.TRUE, 0)

        self.vbox1.pack_start(self.hbox10, gtk.FALSE, gtk.FALSE, 0)


        if create:
            self.MainWindow.add(self.vbox1)

    def OnSelectionGet(self, widget):
        pass

    def OnFocusIn(self, widget):
        pass

    def OnFocusOut(self, widget):
        pass

    def OnConnect(self, widget):
        pass

    def OnDisconnect(self, widget):
        pass

    def OnAway(self, widget):
        pass

    def OnCheckPrivileges(self, widget):
        pass

    def OnShowDebug(self, widget):
        pass

    def OnHideLog(self, widget):
        pass

    def OnHideRoomList(self, widget):
        pass

    def OnSettings(self, widget):
        pass

    def OnRescan(self, widget):
        pass

    def OnBrowseMyShares(self, widget):
        pass

    def OnExit(self, widget):
        pass

    def OnAboutChatroomCommands(self, widget):
        pass

    def OnAboutPrivateChatCommands(self, widget):
        pass

    def OnAboutFilters(self, widget):
        pass

    def OnCheckLatest(self, widget):
        pass

    def OnAbout(self, widget):
        pass

    def OnSwitchPage(self, widget):
        pass

    def OnSearch(self, widget):
        pass

    def OnSimilarUsersClicked(self, widget):
        pass

    def OnRecommendationsClicked(self, widget):
        pass

    def OnGlobalRecommendationsClicked(self, widget):
        pass

    def OnAddThingILike(self, widget):
        pass

    def OnAddThingIDislike(self, widget):
        pass

    def OnAddUser(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class ChatRoomTab:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.ChatRoomTab = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.ChatRoomTab.set_title(_("window1"))
            self.ChatRoomTab.set_position(gtk.WIN_POS_NONE)
            self.ChatRoomTab.add_accel_group(self.accel_group)
            self.ChatRoomTab.show()

        self.Main = gtk.HPaned()
        self.Main.show()

        self.vpaned2 = gtk.VPaned()
        self.vpaned2.show()

        self.scrolledwindow13 = gtk.ScrolledWindow()
        self.scrolledwindow13.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow13.show()
        self.scrolledwindow13.set_shadow_type(gtk.SHADOW_IN)

        self.RoomLog = gtk.TextView()
        self.RoomLog.set_wrap_mode(gtk.WRAP_NONE)
        self.RoomLog.set_cursor_visible(gtk.FALSE)
        self.RoomLog.set_editable(gtk.FALSE)
        self.RoomLog.show()
        self.scrolledwindow13.add(self.RoomLog)

        self.vpaned2.pack1(self.scrolledwindow13, gtk.FALSE, gtk.TRUE)

        self.vbox6 = gtk.VBox(gtk.FALSE, 0)
        self.vbox6.show()
        self.vbox6.set_spacing(0)

        self.scrolledwindow15 = gtk.ScrolledWindow()
        self.scrolledwindow15.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow15.show()
        self.scrolledwindow15.set_shadow_type(gtk.SHADOW_IN)

        self.ChatScroll = gtk.TextView()
        self.ChatScroll.set_wrap_mode(gtk.WRAP_WORD)
        self.ChatScroll.set_cursor_visible(gtk.FALSE)
        self.ChatScroll.set_editable(gtk.FALSE)
        self.ChatScroll.show()
        self.scrolledwindow15.add(self.ChatScroll)

        self.vbox6.pack_start(self.scrolledwindow15, gtk.TRUE, gtk.TRUE, 0)

        self.entry3 = gtk.Entry()
        self.entry3.set_text("")
        self.entry3.set_editable(gtk.TRUE)
        self.entry3.show()
        self.entry3.connect("activate", self.OnEnter)
        self.entry3.connect("key_press_event", self.OnKeyPress)
        self.vbox6.pack_start(self.entry3, gtk.FALSE, gtk.FALSE, 0)

        self.vpaned2.pack2(self.vbox6, gtk.TRUE, gtk.TRUE)

        self.Main.pack1(self.vpaned2, gtk.TRUE, gtk.TRUE)

        self.vbox5 = gtk.VBox(gtk.FALSE, 0)
        self.vbox5.show()
        self.vbox5.set_spacing(0)

        self.scrolledwindow14 = gtk.ScrolledWindow()
        self.scrolledwindow14.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow14.show()
        self.scrolledwindow14.set_shadow_type(gtk.SHADOW_IN)

        self.UserList = gtk.TreeView()
        self.UserList.show()
        self.UserList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow14.add(self.UserList)

        self.vbox5.pack_start(self.scrolledwindow14, gtk.TRUE, gtk.TRUE, 0)

        self.Encoding = gtk.OptionMenu()
        self.Encoding.show()
        self.Encoding.connect("changed", self.OnEncodingChanged)

        self.vbox5.pack_start(self.Encoding, gtk.FALSE, gtk.FALSE, 0)

        self.hbox4 = gtk.HBox(gtk.FALSE, 0)
        self.hbox4.show()
        self.hbox4.set_spacing(0)

        self.Log = gtk.CheckButton()
        self.Log.set_label(_("Log"))
        self.Log.show()
        self.Log.connect("toggled", self.OnLogToggled)
        self.hbox4.pack_start(self.Log, gtk.FALSE, gtk.FALSE, 0)

        self.AutoJoin = gtk.CheckButton()
        self.AutoJoin.set_label(_("Auto-join"))
        self.AutoJoin.show()
        self.AutoJoin.connect("toggled", self.OnAutojoin)
        self.hbox4.pack_start(self.AutoJoin, gtk.FALSE, gtk.FALSE, 0)

        self.Leave = gtk.Button()
        self.Leave.set_label(_("Leave"))
        self.Leave.show()
        self.Leave.connect("clicked", self.OnLeave)

        self.hbox4.pack_end(self.Leave, gtk.FALSE, gtk.FALSE, 0)

        self.vbox5.pack_start(self.hbox4, gtk.FALSE, gtk.TRUE, 0)

        self.Main.pack2(self.vbox5, gtk.FALSE, gtk.TRUE)


        if create:
            self.ChatRoomTab.add(self.Main)

    def OnEnter(self, widget):
        pass

    def OnKeyPress(self, widget):
        pass

    def OnEncodingChanged(self, widget):
        pass

    def OnLogToggled(self, widget):
        pass

    def OnAutojoin(self, widget):
        pass

    def OnLeave(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class PrivateChatTab:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.PrivateChatTab = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.PrivateChatTab.set_title(_("window1"))
            self.PrivateChatTab.set_position(gtk.WIN_POS_NONE)
            self.PrivateChatTab.add_accel_group(self.accel_group)
            self.PrivateChatTab.show()

        self.Main = gtk.VBox(gtk.FALSE, 0)
        self.Main.show()
        self.Main.set_spacing(0)

        self.scrolledwindow16 = gtk.ScrolledWindow()
        self.scrolledwindow16.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow16.show()
        self.scrolledwindow16.set_shadow_type(gtk.SHADOW_IN)

        self.ChatScroll = gtk.TextView()
        self.ChatScroll.set_wrap_mode(gtk.WRAP_WORD)
        self.ChatScroll.set_cursor_visible(gtk.FALSE)
        self.ChatScroll.set_editable(gtk.FALSE)
        self.ChatScroll.show()
        self.scrolledwindow16.add(self.ChatScroll)

        self.Main.pack_start(self.scrolledwindow16, gtk.TRUE, gtk.TRUE, 0)

        self.hbox5 = gtk.HBox(gtk.FALSE, 0)
        self.hbox5.show()
        self.hbox5.set_spacing(0)

        self.ChatLine = gtk.Entry()
        self.ChatLine.set_text("")
        self.ChatLine.set_editable(gtk.TRUE)
        self.ChatLine.show()
        self.ChatLine.connect("activate", self.OnEnter)
        self.ChatLine.connect("key_press_event", self.OnKeyPress)
        self.hbox5.pack_start(self.ChatLine, gtk.TRUE, gtk.TRUE, 0)

        self.Encoding = gtk.OptionMenu()
        self.Encoding.show()
        self.Encoding.connect("changed", self.OnEncodingChanged)

        self.hbox5.pack_start(self.Encoding, gtk.FALSE, gtk.FALSE, 0)

        self.Log = gtk.CheckButton()
        self.Log.set_label(_("Log"))
        self.Log.show()
        self.Log.connect("toggled", self.OnLogToggled)
        self.hbox5.pack_start(self.Log, gtk.FALSE, gtk.FALSE, 0)

        self.button1 = gtk.Button()
        self.button1.set_label(_("Close"))
        self.button1.show()
        self.button1.connect("clicked", self.OnClose)

        self.hbox5.pack_start(self.button1, gtk.FALSE, gtk.FALSE, 0)

        self.Main.pack_start(self.hbox5, gtk.FALSE, gtk.TRUE, 0)


        if create:
            self.PrivateChatTab.add(self.Main)

    def OnEnter(self, widget):
        pass

    def OnKeyPress(self, widget):
        pass

    def OnEncodingChanged(self, widget):
        pass

    def OnLogToggled(self, widget):
        pass

    def OnClose(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class SearchTab:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.SearchTab = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.SearchTab.set_title(_("window1"))
            self.SearchTab.set_position(gtk.WIN_POS_NONE)
            self.SearchTab.add_accel_group(self.accel_group)
            self.SearchTab.show()

        self.vbox7 = gtk.VBox(gtk.FALSE, 0)
        self.vbox7.show()
        self.vbox7.set_spacing(0)

        self.hbox6 = gtk.HBox(gtk.FALSE, 5)
        self.hbox6.show()
        self.hbox6.set_spacing(5)

        self.checkbutton1 = gtk.CheckButton()
        self.checkbutton1.set_label(_("Enable filters"))
        self.checkbutton1.show()
        self.checkbutton1.connect("toggled", self.OnToggleFilters)
        self.hbox6.pack_start(self.checkbutton1, gtk.TRUE, gtk.TRUE, 0)

        self.button2 = gtk.Button()
        self.button2.set_label(_("Ignore"))
        self.button2.show()
        self.button2.connect("clicked", self.OnIgnore)

        self.hbox6.pack_start(self.button2, gtk.FALSE, gtk.FALSE, 0)

        self.button3 = gtk.Button()
        self.button3.set_label(_("Close"))
        self.button3.show()
        self.button3.connect("clicked", self.OnClose)

        self.hbox6.pack_start(self.button3, gtk.FALSE, gtk.FALSE, 0)

        self.RememberCheckButton = gtk.CheckButton()
        self.RememberCheckButton.set_label(_("Remember"))
        self.RememberCheckButton.show()
        self.RememberCheckButton.connect("toggled", self.OnToggleRemember)
        self.hbox6.pack_start(self.RememberCheckButton, gtk.FALSE, gtk.FALSE, 0)

        self.vbox7.pack_start(self.hbox6, gtk.FALSE, gtk.TRUE, 0)

        self.Filters = gtk.HBox(gtk.FALSE, 2)
        self.Filters.set_spacing(2)

        self.label13 = gtk.Label(_("Filter in:"))
        self.label13.set_padding(0, 0)
        self.label13.show()
        self.Filters.pack_start(self.label13, gtk.FALSE, gtk.FALSE, 0)

        self.FilterIn = gtk.Combo()
        self.FilterIn.show()

        self.combo_entry1 = self.FilterIn.entry
        self.combo_entry1.set_text("")
        self.combo_entry1.set_editable(gtk.TRUE)
        self.combo_entry1.show()
        self.combo_entry1.connect("activate", self.OnRefilter)

        self.combo_list2 = self.FilterIn.list
        self.combo_list2.show()

        self.Filters.pack_start(self.FilterIn, gtk.TRUE, gtk.TRUE, 0)

        self.label14 = gtk.Label(_("Filter out:"))
        self.label14.set_padding(0, 0)
        self.label14.show()
        self.Filters.pack_start(self.label14, gtk.FALSE, gtk.FALSE, 0)

        self.FilterOut = gtk.Combo()
        self.FilterOut.show()

        self.combo_entry2 = self.FilterOut.entry
        self.combo_entry2.set_text("")
        self.combo_entry2.set_editable(gtk.TRUE)
        self.combo_entry2.show()
        self.combo_entry2.connect("activate", self.OnRefilter)

        self.combo_list3 = self.FilterOut.list
        self.combo_list3.show()

        self.Filters.pack_start(self.FilterOut, gtk.TRUE, gtk.TRUE, 0)

        self.label15 = gtk.Label(_("Size:"))
        self.label15.set_padding(0, 0)
        self.label15.show()
        self.Filters.pack_start(self.label15, gtk.FALSE, gtk.FALSE, 0)

        self.FilterSize = gtk.Combo()
        self.FilterSize.set_size_request(75, -1)
        self.FilterSize.show()

        self.combo_entry3 = self.FilterSize.entry
        self.combo_entry3.set_text("")
        self.combo_entry3.set_editable(gtk.TRUE)
        self.combo_entry3.show()
        self.combo_entry3.connect("activate", self.OnRefilter)

        self.combo_list4 = self.FilterSize.list
        self.combo_list4.show()

        self.Filters.pack_start(self.FilterSize, gtk.FALSE, gtk.TRUE, 0)

        self.label16 = gtk.Label(_("Bitrate"))
        self.label16.set_padding(0, 0)
        self.label16.show()
        self.Filters.pack_start(self.label16, gtk.FALSE, gtk.FALSE, 0)

        self.FilterBitrate = gtk.Combo()
        self.FilterBitrate.set_size_request(75, -1)
        self.FilterBitrate.show()

        self.combo_entry4 = self.FilterBitrate.entry
        self.combo_entry4.set_text("")
        self.combo_entry4.set_editable(gtk.TRUE)
        self.combo_entry4.show()
        self.combo_entry4.connect("activate", self.OnRefilter)

        self.combo_list5 = self.FilterBitrate.list
        self.combo_list5.show()

        self.Filters.pack_start(self.FilterBitrate, gtk.FALSE, gtk.TRUE, 0)

        self.FilterFreeSlot = gtk.CheckButton()
        self.FilterFreeSlot.set_label(_("Free slot"))
        self.FilterFreeSlot.show()
        self.FilterFreeSlot.connect("toggled", self.OnRefilter)
        self.Filters.pack_start(self.FilterFreeSlot, gtk.FALSE, gtk.FALSE, 0)

        self.vbox7.pack_start(self.Filters, gtk.FALSE, gtk.TRUE, 0)

        self.scrolledwindow17 = gtk.ScrolledWindow()
        self.scrolledwindow17.set_policy(gtk.POLICY_ALWAYS, gtk.POLICY_ALWAYS)
        self.scrolledwindow17.show()
        self.scrolledwindow17.set_shadow_type(gtk.SHADOW_IN)

        self.ResultsList = gtk.TreeView()
        self.ResultsList.show()
        self.ResultsList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow17.add(self.ResultsList)

        self.vbox7.pack_start(self.scrolledwindow17, gtk.TRUE, gtk.TRUE, 0)


        if create:
            self.SearchTab.add(self.vbox7)

    def OnToggleFilters(self, widget):
        pass

    def OnIgnore(self, widget):
        pass

    def OnClose(self, widget):
        pass

    def OnToggleRemember(self, widget):
        pass

    def OnRefilter(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class UserInfoTab:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.UserInfoTab = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.UserInfoTab.set_title(_("window1"))
            self.UserInfoTab.set_position(gtk.WIN_POS_NONE)
            self.UserInfoTab.add_accel_group(self.accel_group)
            self.UserInfoTab.show()

        self.Main = gtk.HBox(gtk.FALSE, 0)
        self.Main.show()
        self.Main.set_spacing(0)

        self.vbox8 = gtk.VBox(gtk.FALSE, 0)
        self.vbox8.set_size_request(250, -1)
        self.vbox8.show()
        self.vbox8.set_spacing(0)

        self.frame1 = gtk.Frame()
        self.frame1.show()
        self.frame1.set_shadow_type(gtk.SHADOW_ETCHED_IN)

        self.scrolledwindow18 = gtk.ScrolledWindow()
        self.scrolledwindow18.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow18.show()
        self.scrolledwindow18.set_shadow_type(gtk.SHADOW_IN)

        self.viewport3 = gtk.Viewport()
        self.viewport3.show()
        self.viewport3.set_shadow_type(gtk.SHADOW_IN)

        self.vbox11 = gtk.VBox(gtk.FALSE, 0)
        self.vbox11.show()
        self.vbox11.set_spacing(0)

        self.Encoding = gtk.OptionMenu()
        self.Encoding.show()
        self.Encoding.connect("changed", self.OnEncodingChanged)

        self.vbox11.pack_start(self.Encoding, gtk.FALSE, gtk.FALSE, 0)

        self.descr = gtk.TextView()
        self.descr.set_wrap_mode(gtk.WRAP_WORD)
        self.descr.set_cursor_visible(gtk.FALSE)
        self.descr.set_editable(gtk.FALSE)
        self.descr.show()
        self.vbox11.pack_start(self.descr, gtk.TRUE, gtk.TRUE, 0)

        self.viewport3.add(self.vbox11)

        self.scrolledwindow18.add(self.viewport3)

        self.frame1.add(self.scrolledwindow18)

        self.label17 = gtk.Label(_("Self description:"))
        self.label17.set_padding(0, 0)
        self.label17.show()
        self.frame1.set_label_widget(self.label17)

        self.vbox8.pack_start(self.frame1, gtk.TRUE, gtk.TRUE, 0)

        self.frame2 = gtk.Frame()
        self.frame2.show()
        self.frame2.set_shadow_type(gtk.SHADOW_ETCHED_IN)

        self.vbox10 = gtk.VBox(gtk.FALSE, 10)
        self.vbox10.show()
        self.vbox10.set_spacing(10)
        self.vbox10.set_border_width(10)

        self.uploads = gtk.Label(_("Total uploads allowed: unknown"))
        self.uploads.set_alignment(0, 0.5)
        self.uploads.set_padding(0, 0)
        self.uploads.show()
        self.vbox10.pack_start(self.uploads, gtk.FALSE, gtk.FALSE, 0)

        self.queuesize = gtk.Label(_("Queue size: unknown"))
        self.queuesize.set_alignment(0, 0.5)
        self.queuesize.set_padding(0, 0)
        self.queuesize.show()
        self.vbox10.pack_start(self.queuesize, gtk.FALSE, gtk.FALSE, 0)

        self.slotsavail = gtk.Label(_("Slots available: unknown"))
        self.slotsavail.set_alignment(0, 0.5)
        self.slotsavail.set_padding(0, 0)
        self.slotsavail.show()
        self.vbox10.pack_start(self.slotsavail, gtk.FALSE, gtk.FALSE, 0)

        self.progressbar = gtk.ProgressBar()
        self.progressbar.show()
        self.vbox10.pack_end(self.progressbar, gtk.FALSE, gtk.TRUE, 0)

        self.frame2.add(self.vbox10)

        self.label18 = gtk.Label(_("Information:"))
        self.label18.set_padding(0, 0)
        self.label18.show()
        self.frame2.set_label_widget(self.label18)

        self.vbox8.pack_start(self.frame2, gtk.FALSE, gtk.TRUE, 0)

        self.Main.pack_start(self.vbox8, gtk.FALSE, gtk.TRUE, 0)

        self.frame3 = gtk.Frame()
        self.frame3.show()
        self.frame3.set_shadow_type(gtk.SHADOW_ETCHED_IN)

        self.scrolledwindow19 = gtk.ScrolledWindow()
        self.scrolledwindow19.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow19.show()
        self.scrolledwindow19.set_shadow_type(gtk.SHADOW_NONE)

        self.viewport2 = gtk.Viewport()
        self.viewport2.show()
        self.viewport2.set_shadow_type(gtk.SHADOW_NONE)

        self.image = gtk.Image()
        self.image.set_padding(0, 0)
        self.image.show()
        self.viewport2.add(self.image)

        self.scrolledwindow19.add(self.viewport2)

        self.frame3.add(self.scrolledwindow19)

        self.label19 = gtk.Label(_("Picture:"))
        self.label19.set_padding(0, 0)
        self.label19.show()
        self.frame3.set_label_widget(self.label19)

        self.Main.pack_start(self.frame3, gtk.TRUE, gtk.TRUE, 0)

        self.vbox9 = gtk.VBox(gtk.FALSE, 10)
        self.vbox9.show()
        self.vbox9.set_spacing(10)
        self.vbox9.set_border_width(10)

        self.button4 = gtk.Button()
        self.button4.set_label(_("Private chat"))
        self.button4.show()
        self.button4.connect("clicked", self.OnSendMessage)

        self.vbox9.pack_start(self.button4, gtk.FALSE, gtk.FALSE, 0)

        self.button5 = gtk.Button()
        self.button5.set_label(_("Browse"))
        self.button5.show()
        self.button5.connect("clicked", self.OnBrowseUser)

        self.vbox9.pack_start(self.button5, gtk.FALSE, gtk.FALSE, 0)

        self.button6 = gtk.Button()
        self.button6.set_label(_("Show IP"))
        self.button6.show()
        self.button6.connect("clicked", self.OnShowIPaddress)

        self.vbox9.pack_start(self.button6, gtk.FALSE, gtk.FALSE, 0)

        self.button7 = gtk.Button()
        self.button7.set_label(_("Add to list"))
        self.button7.show()
        self.button7.connect("clicked", self.OnAddToList)

        self.vbox9.pack_start(self.button7, gtk.FALSE, gtk.FALSE, 0)

        self.button8 = gtk.Button()
        self.button8.set_label(_("Ban"))
        self.button8.show()
        self.button8.connect("clicked", self.OnBanUser)

        self.vbox9.pack_start(self.button8, gtk.FALSE, gtk.FALSE, 0)

        self.button14 = gtk.Button()
        self.button14.set_label(_("Ignore"))
        self.button14.show()
        self.button14.connect("clicked", self.OnIgnoreUser)

        self.vbox9.pack_start(self.button14, gtk.FALSE, gtk.FALSE, 0)

        self.button9 = gtk.Button()
        self.button9.set_label(_("Save pic"))
        self.button9.show()
        self.button9.connect("clicked", self.OnSavePicture)

        self.vbox9.pack_start(self.button9, gtk.FALSE, gtk.FALSE, 0)

        self.button10 = gtk.Button()
        self.button10.set_label(_("Close"))
        self.button10.show()
        self.button10.connect("clicked", self.OnClose)

        self.vbox9.pack_end(self.button10, gtk.FALSE, gtk.FALSE, 0)

        self.button11 = gtk.Button()
        self.button11.set_label(_("Refresh"))
        self.button11.show()
        self.button11.connect("clicked", self.OnRefresh)

        self.vbox9.pack_end(self.button11, gtk.FALSE, gtk.FALSE, 0)

        self.Main.pack_start(self.vbox9, gtk.FALSE, gtk.TRUE, 0)


        if create:
            self.UserInfoTab.add(self.Main)

    def OnEncodingChanged(self, widget):
        pass

    def OnSendMessage(self, widget):
        pass

    def OnBrowseUser(self, widget):
        pass

    def OnShowIPaddress(self, widget):
        pass

    def OnAddToList(self, widget):
        pass

    def OnBanUser(self, widget):
        pass

    def OnIgnoreUser(self, widget):
        pass

    def OnSavePicture(self, widget):
        pass

    def OnClose(self, widget):
        pass

    def OnRefresh(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class UserBrowseTab:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.UserBrowseTab = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.UserBrowseTab.set_title(_("window1"))
            self.UserBrowseTab.set_position(gtk.WIN_POS_NONE)
            self.UserBrowseTab.add_accel_group(self.accel_group)
            self.UserBrowseTab.show()

        self.Main = gtk.VBox(gtk.FALSE, 0)
        self.Main.show()
        self.Main.set_spacing(0)

        self.hbox8 = gtk.HBox(gtk.FALSE, 5)
        self.hbox8.show()
        self.hbox8.set_spacing(5)

        self.label20 = gtk.Label(_("Search file and folder names (exact match):"))
        self.label20.set_padding(0, 0)
        self.label20.show()
        self.hbox8.pack_start(self.label20, gtk.FALSE, gtk.FALSE, 0)

        self.entry4 = gtk.Entry()
        self.entry4.set_text("")
        self.entry4.set_editable(gtk.TRUE)
        self.entry4.show()
        self.entry4.connect("activate", self.OnSearch)
        self.hbox8.pack_start(self.entry4, gtk.TRUE, gtk.TRUE, 0)

        self.Encoding = gtk.OptionMenu()
        self.Encoding.show()
        self.Encoding.connect("changed", self.OnEncodingChanged)

        self.menu1 = gtk.Menu()


        self.hbox8.pack_start(self.Encoding, gtk.FALSE, gtk.FALSE, 5)

        self.Main.pack_start(self.hbox8, gtk.FALSE, gtk.TRUE, 0)

        self.hpaned2 = gtk.HPaned()
        self.hpaned2.show()

        self.scrolledwindow21 = gtk.ScrolledWindow()
        self.scrolledwindow21.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow21.set_size_request(250, -1)
        self.scrolledwindow21.show()
        self.scrolledwindow21.set_shadow_type(gtk.SHADOW_IN)

        self.FolderTreeView = gtk.TreeView()
        self.FolderTreeView.show()
        self.FolderTreeView.set_headers_visible(gtk.FALSE)
        self.scrolledwindow21.add(self.FolderTreeView)

        self.hpaned2.pack1(self.scrolledwindow21, gtk.FALSE, gtk.TRUE)

        self.scrolledwindow20 = gtk.ScrolledWindow()
        self.scrolledwindow20.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow20.show()
        self.scrolledwindow20.set_shadow_type(gtk.SHADOW_IN)

        self.FileTreeView = gtk.TreeView()
        self.FileTreeView.show()
        self.FileTreeView.set_headers_visible(gtk.TRUE)
        self.scrolledwindow20.add(self.FileTreeView)

        self.hpaned2.pack2(self.scrolledwindow20, gtk.TRUE, gtk.TRUE)

        self.Main.pack_start(self.hpaned2, gtk.TRUE, gtk.TRUE, 0)

        self.hbox9 = gtk.HBox(gtk.FALSE, 5)
        self.hbox9.show()
        self.hbox9.set_spacing(5)
        self.hbox9.set_border_width(10)

        self.progressbar1 = gtk.ProgressBar()
        self.progressbar1.set_size_request(250, -1)
        self.progressbar1.show()
        self.hbox9.pack_start(self.progressbar1, gtk.FALSE, gtk.FALSE, 0)

        self.button12 = gtk.Button()
        self.button12.set_label(_("Close"))
        self.button12.show()
        self.button12.connect("clicked", self.OnClose)

        self.hbox9.pack_end(self.button12, gtk.FALSE, gtk.FALSE, 0)

        self.button13 = gtk.Button()
        self.button13.set_label(_("Refresh"))
        self.button13.show()
        self.button13.connect("clicked", self.OnRefresh)

        self.hbox9.pack_end(self.button13, gtk.FALSE, gtk.FALSE, 0)

        self.Main.pack_start(self.hbox9, gtk.FALSE, gtk.TRUE, 0)


        if create:
            self.UserBrowseTab.add(self.Main)

    def OnSearch(self, widget):
        pass

    def OnEncodingChanged(self, widget):
        pass

    def OnClose(self, widget):
        pass

    def OnRefresh(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

class RoomList:
    def __init__(self, create = gtk.TRUE, accel_group = None):
        if accel_group is None:
             self.accel_group = gtk.AccelGroup()
        else:
             self.accel_group = accel_group
        if create:
            self.RoomList = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.RoomList.set_title(_("window1"))
            self.RoomList.set_position(gtk.WIN_POS_NONE)
            self.RoomList.add_accel_group(self.accel_group)
            self.RoomList.show()

        self.vbox2 = gtk.VBox(gtk.FALSE, 0)
        self.vbox2.show()
        self.vbox2.set_spacing(0)

        self.scrolledwindow10 = gtk.ScrolledWindow()
        self.scrolledwindow10.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.scrolledwindow10.show()
        self.scrolledwindow10.set_shadow_type(gtk.SHADOW_IN)

        self.RoomsList = gtk.TreeView()
        self.RoomsList.show()
        self.RoomsList.set_headers_visible(gtk.TRUE)
        self.scrolledwindow10.add(self.RoomsList)

        self.vbox2.pack_start(self.scrolledwindow10, gtk.TRUE, gtk.TRUE, 0)

        self.hbox1 = gtk.HBox(gtk.FALSE, 0)
        self.hbox1.show()
        self.hbox1.set_spacing(0)

        self.label10 = gtk.Label(_("Create: "))
        self.label10.set_padding(0, 0)
        self.label10.show()
        self.hbox1.pack_start(self.label10, gtk.FALSE, gtk.FALSE, 0)

        self.CreateRoomEntry = gtk.Entry()
        self.CreateRoomEntry.set_text("")
        self.CreateRoomEntry.set_editable(gtk.TRUE)
        self.CreateRoomEntry.show()
        self.CreateRoomEntry.connect("activate", self.OnCreateRoom)
        self.hbox1.pack_start(self.CreateRoomEntry, gtk.TRUE, gtk.TRUE, 0)

        self.vbox2.pack_start(self.hbox1, gtk.FALSE, gtk.TRUE, 0)


        if create:
            self.RoomList.add(self.vbox2)

    def OnCreateRoom(self, widget):
        pass

    def get_custom_widget(self, id, string1, string2, int1, int2):
        w = gtk.Label(_("(custom widget: %s)") % id)
        return w

