# Copyright (c) 2003 Hyriand. All rights reserved.
#
import gtk

from transferlist import TransferList
from utils import PopupMenu
from pynicotine import slskmessages

from pynicotine.utils import _

class Downloads(TransferList):
	def __init__(self, frame):
		TransferList.__init__(self, frame, frame.DownloadList)

		self.popup_menu = popup = PopupMenu(frame)
		popup.setup(
			(_("Get place in queue"), self.OnGetPlaceInQueue),
			("", None),
			(_("Copy URL"), self.OnCopyURL),
			(_("Copy folder URL"), self.OnCopyDirURL),
			("", None),
			(_("Send message"), popup.OnSendMessage),
			(_("Show IP address"), popup.OnShowIPaddress),
			(_("Get user info"), popup.OnGetUserInfo),
			(_("Browse files"), popup.OnBrowseUser),
			("$" + _("Add user to list"), popup.OnAddToList),
			("$" + _("Ban this user"), popup.OnBanUser),
			("$" + _("Ignore this user"), popup.OnIgnoreUser),
			("", None),
			(_("Abort"), self.OnAbortTransfer),
			(_("Abort and remove file(s)"), self.OnAbortRemoveTransfer),
			(_("Retry"), self.OnRetryTransfer),
			(_("Clear"), self.OnClearTransfer),
			("", None),
			(_("Clear finished/aborted"), self.OnClearFinishedAborted),
			(_("Clear finished"), self.OnClearFinished),
			(_("Clear aborted"), self.OnClearAborted),
			(_("Clear queued"), self.OnClearQueued),
		)
		frame.DownloadList.connect("button_press_event", self.OnPopupMenu)
	
	def OnPopupMenu(self, widget, event):
		if event.button != 3:
			return gtk.FALSE
		
		self.selected_transfers = []
		self.selected_users = []
		self.widget.get_selection().selected_foreach(self.SelectedTransfersCallback)

		items = self.popup_menu.get_children()

		if len(self.selected_users) == 0:
			items[0].set_sensitive(gtk.FALSE)
		else:
			items[0].set_sensitive(gtk.TRUE)
		
		act = gtk.FALSE
		if len(self.selected_transfers) == 1:
			act = gtk.TRUE
		items[2].set_sensitive(act)
		items[3].set_sensitive(act)

		act = gtk.FALSE
		if len(self.selected_users) == 1:
			user = self.selected_users[0]
			self.popup_menu.set_user(user)
			act = gtk.TRUE
			items[9].set_active(user in [i[0] for i in self.frame.np.config.sections["server"]["userlist"]])
			items[10].set_active(user in self.frame.np.config.sections["server"]["banlist"])
			items[11].set_active(user in self.frame.np.config.sections["server"]["ignorelist"])
			
		for i in range(5, 12):
			items[i].set_sensitive(act)
		
		act = len(self.selected_transfers) and gtk.TRUE or gtk.FALSE
		for i in range(13, 17):
			items[i].set_sensitive(act)
		
		self.popup_menu.popup(None, None, None, event.button, event.time)
		
		widget.emit_stop_by_name("button_press_event")
		return gtk.TRUE
		
	def update(self, transfer = None):
		TransferList.update(self, transfer)
		if transfer is None and self.frame.np.transfers is not None:
			self.frame.np.transfers.SaveDownloads()

	def OnGetPlaceInQueue(self, widget):
		for i in self.selected_transfers:
			if i.status != "Queued":
				continue
			self.frame.np.ProcessRequestToPeer(i.user, slskmessages.PlaceInQueueRequest(None, i.filename))

	def OnRetryTransfer(self, widget):
		for transfer in self.selected_transfers:
			if transfer.status in ["Finished", "Old"]:
				continue
			self.frame.np.transfers.AbortTransfer(transfer)
			transfer.req = None
			self.frame.np.transfers.getFile(transfer.user, transfer.filename, transfer.path, transfer)
		self.frame.np.transfers.SaveDownloads()

	def OnAbortRemoveTransfer(self, widget):
		self.OnAbortTransfer(widget, gtk.TRUE)
