<?php
/*
 * $Horde: kronolith/viewevent.php,v 1.1.2.5 2003/02/13 00:48:05 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$event = $calendar->getEventObject(Horde::getFormData('eventID'));
if (!$event) {
    if (($url = Horde::getFormData('url')) === null) {
        $url = $prefs->getValue('defaultview') . '.php';
        if ($url == '.php') {
            $url = 'month.php';
        }
        $url = Horde::applicationUrl($url, true);
    }
    header('Location: ' . $url);
}

$category = $event->getCategory();
$description = $event->getDescription();
$location = $event->getLocation();

if ($conf['metadata']['keywords']) {
    include_once KRONOLITH_BASE . '/config/keywords.php';
    $keyword_list = array();
    foreach ($keywords as $cat => $list) {
        $sub_list = array();
        foreach ($list as $entry) {
            if ($event->hasKeyword($entry)) {
                $sub_list[] = htmlspecialchars($entry);
            }
        }
        if (count($sub_list)) {
            $keyword_list[$cat] = $sub_list;
        }
    }
}

if ($timestamp = Horde::getFormData('timestamp')) {
	$month = date('n', $timestamp);
	$year = date('Y', $timestamp);
} else {
	$month = Horde::getFormData('month', date('n'));
	$year = Horde::getFormData('year', date('Y'));
}

$title = sprintf(_("View %s"), $event->getTitle());
$js_onLoad = null;

require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
require KRONOLITH_TEMPLATES . '/view/view.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
