'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.4/tcllib-1.4/modules/math/fuzzy.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::fuzzy" n 1.0 math "Math"
.BS
.SH "NAME"
math::fuzzy \- Fuzzy comparison of floating-point numbers
.SH "SYNOPSIS"
\fB::math::fuzzy::teq\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tne\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tge\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tle\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tlt\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tgt\fR \fIvalue1\fR \fIvalue2\fR\fR
.sp
\fB::math::fuzzy::tfloor\fR \fIvalue\fR\fR
.sp
\fB::math::fuzzy::tceil\fR \fIvalue\fR\fR
.sp
\fB::math::fuzzy::tround\fR \fIvalue\fR\fR
.sp
\fB::math::fuzzy::troundn\fR \fIvalue\fR \fIndigits\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The package Fuzzy is meant to solve common problems with floating-point
numbers in a systematic way:
.IP \(bu
Comparing two numbers that are "supposed" to be identical, like
1.0 and 2.1/(1.2+0.9) is not guaranteed to give the
intuitive result.
.IP \(bu
Rounding a number that is halfway two integer numbers can cause
strange errors, like int(100.0*2.8) != 28 but 27
.PP
The Fuzzy package is meant to help sorting out this type of problems
by defining "fuzzy" comparison procedures for floating-point numbers.
It does so by allowing for a small margin that is determined
automatically - the margin is three times the "epsilon" value, that is
three times the smallest number \fIeps\fR such that 1.0 and 1.0+$eps
canbe distinguished. In Tcl, which uses double precision floating-point
numbers, this is typically 1.1e-16.
.SH "PROCEDURES"
Effectively the package provides the following procedures:
.TP
\fB::math::fuzzy::teq\fR \fIvalue1\fR \fIvalue2\fR\fR
Compares two floating-point numbers and returns 1 if their values
fall within a small range. Otherwise it returns 0.
.TP
\fB::math::fuzzy::tne\fR \fIvalue1\fR \fIvalue2\fR\fR
Returns the negation, that is, if the difference is larger than
the margin, it returns 1.
.TP
\fB::math::fuzzy::tge\fR \fIvalue1\fR \fIvalue2\fR\fR
Compares two floating-point numbers and returns 1 if their values
either fall within a small range or if the first number is larger
than the second. Otherwise it returns 0.
.TP
\fB::math::fuzzy::tle\fR \fIvalue1\fR \fIvalue2\fR\fR
Returns 1 if the two numbers are equal according to
[teq] or if the first is smaller than the second.
.TP
\fB::math::fuzzy::tlt\fR \fIvalue1\fR \fIvalue2\fR\fR
Returns the opposite of [tge].
.TP
\fB::math::fuzzy::tgt\fR \fIvalue1\fR \fIvalue2\fR\fR
Returns the opposite of [tle].
.TP
\fB::math::fuzzy::tfloor\fR \fIvalue\fR\fR
Returns the integer number that is lower or equal
to the given floating-point number, within a well-defined
tolerance.
.TP
\fB::math::fuzzy::tceil\fR \fIvalue\fR\fR
Returns the integer number that is greater or equal to the given
floating-point number, within a well-defined tolerance.
.TP
\fB::math::fuzzy::tround\fR \fIvalue\fR\fR
Rounds the floating-point number off.
.TP
\fB::math::fuzzy::troundn\fR \fIvalue\fR \fIndigits\fR\fR
Rounds the floating-point number off to the
specified number of decimals (Pro memorie).
Usage:
.nf
if { [teq $x $y] } { puts "x == y" }
if { [tne $x $y] } { puts "x != y" }
if { [tge $x $y] } { puts "x >= y" }
if { [tgt $x $y] } { puts "x > y" }
if { [tlt $x $y] } { puts "x < y" }
if { [tle $x $y] } { puts "x <= y" }

set fx      [tfloor $x]
set fc      [tceil  $x]
set rounded [tround $x]
set roundn  [troundn $x $nodigits]
.fi
.SH "TEST CASES"
The problems that can occur with floating-point numbers are illustrated
by the test cases in the file "fuzzy.test":
.IP \(bu
Several test case use the ordinary comparisons, and they
fail invariably to produce understandable results
.IP \(bu
One test case uses [expr] without braces ({ and }). It too
fails.
The conclusion from this is that any expression should be surrounded by
braces, because otherwise very awkward things can happen if you need
accuracy. Furthermore, accuracy and understandable results are
enhanced by using these "tolerant" or fuzzy comparisons.
.PP
Note that besides the Tcl-only package, there is also a C-based version.
.SH "REFERENCES"
Original implementation in Fortran by dr. H.D. Knoble (Penn State
University).
.PP
P. E. Hagerty, "More on Fuzzy Floor and Ceiling,"
APL QUOTE QUAD 8(4):20-24, June 1978. Note that TFLOOR=FL5 took five
years of refereed evolution (publication).
.PP
L. M. Breed, "Definitions for Fuzzy Floor and Ceiling",
APL QUOTE QUAD 8(3):16-23, March 1978.
.PP
D. Knuth, Art of Computer Programming,
Vol. 1, Problem 1.2.4-5.
.SH "KEYWORDS"
floating-point, math, rounding