require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PCIIDE_NUM_CHANNELS)) {
    sub PCIIDE_NUM_CHANNELS () {	2;}
}
unless(defined(&PCIIDE_REG_CMD_BASE)) {
    sub PCIIDE_REG_CMD_BASE {
	local($chan) = @_;
	eval q((0x10 + (8* ($chan))));
    }
}
unless(defined(&PCIIDE_REG_CTL_BASE)) {
    sub PCIIDE_REG_CTL_BASE {
	local($chan) = @_;
	eval q((0x14 + (8* ($chan))));
    }
}
unless(defined(&PCIIDE_REG_BUS_MASTER_DMA)) {
    sub PCIIDE_REG_BUS_MASTER_DMA () {	0x20;}
}
unless(defined(&PCIIDE_CHANSTATUS_EN)) {
    sub PCIIDE_CHANSTATUS_EN () {	0x40;}
}
unless(defined(&PCIIDE_CHAN_EN)) {
    sub PCIIDE_CHAN_EN {
	local($chan) = @_;
	eval q((0x20 >> ($chan)));
    }
}
unless(defined(&PCIIDE_INTERFACE_PCI)) {
    sub PCIIDE_INTERFACE_PCI {
	local($chan) = @_;
	eval q((0x1 << (2* ($chan))));
    }
}
unless(defined(&PCIIDE_INTERFACE_SETTABLE)) {
    sub PCIIDE_INTERFACE_SETTABLE {
	local($chan) = @_;
	eval q((0x2 << (2* ($chan))));
    }
}
unless(defined(&PCIIDE_INTERFACE_BUS_MASTER_DMA)) {
    sub PCIIDE_INTERFACE_BUS_MASTER_DMA () {	0x80;}
}
unless(defined(&PCIIDE_COMPAT_CMD_BASE)) {
    sub PCIIDE_COMPAT_CMD_BASE {
	local($chan) = @_;
	eval q((($chan) == 0? 0x1f0 : 0x170));
    }
}
unless(defined(&PCIIDE_COMPAT_CMD_SIZE)) {
    sub PCIIDE_COMPAT_CMD_SIZE () {	8;}
}
unless(defined(&PCIIDE_COMPAT_CTL_BASE)) {
    sub PCIIDE_COMPAT_CTL_BASE {
	local($chan) = @_;
	eval q((($chan) == 0? 0x3f6 : 0x376));
    }
}
unless(defined(&PCIIDE_COMPAT_CTL_SIZE)) {
    sub PCIIDE_COMPAT_CTL_SIZE () {	1;}
}
unless(defined(&PCIIDE_COMPAT_IRQ)) {
    sub PCIIDE_COMPAT_IRQ {
	local($chan) = @_;
	eval q((($chan) == 0? 14: 15));
    }
}
unless(defined(&PCIIDE_CHANNEL_NAME)) {
    sub PCIIDE_CHANNEL_NAME {
	local($chan) = @_;
	eval q((($chan) == 0? \"channel 0\" : \"channel 1\"));
    }
}
unless(defined(&IDEDMA_SCH_OFFSET)) {
    sub IDEDMA_SCH_OFFSET () {	0x8;}
}
unless(defined(&IDEDMA_CMD)) {
    sub IDEDMA_CMD {
	local($chan) = @_;
	eval q((0x +  &IDEDMA_SCH_OFFSET * ($chan)));
    }
}
unless(defined(&IDEDMA_CMD_WRITE)) {
    sub IDEDMA_CMD_WRITE () {	0x8;}
}
unless(defined(&IDEDMA_CMD_START)) {
    sub IDEDMA_CMD_START () {	0x1;}
}
unless(defined(&IDEDMA_CTL)) {
    sub IDEDMA_CTL {
	local($chan) = @_;
	eval q((0x2 +  &IDEDMA_SCH_OFFSET * ($chan)));
    }
}
unless(defined(&IDEDMA_CTL_DRV_DMA)) {
    sub IDEDMA_CTL_DRV_DMA {
	local($d) = @_;
	eval q((0x20 << ($d)));
    }
}
unless(defined(&IDEDMA_CTL_INTR)) {
    sub IDEDMA_CTL_INTR () {	0x4;}
}
unless(defined(&IDEDMA_CTL_ERR)) {
    sub IDEDMA_CTL_ERR () {	0x2;}
}
unless(defined(&IDEDMA_CTL_ACT)) {
    sub IDEDMA_CTL_ACT () {	0x1;}
}
unless(defined(&IDEDMA_TBL)) {
    sub IDEDMA_TBL {
	local($chan) = @_;
	eval q((0x4 +  &IDEDMA_SCH_OFFSET * ($chan)));
    }
}
unless(defined(&IDEDMA_TBL_MASK)) {
    sub IDEDMA_TBL_MASK () {	0xfffffffc;}
}
unless(defined(&IDEDMA_TBL_ALIGN)) {
    sub IDEDMA_TBL_ALIGN () {	0x10000;}
}
unless(defined(&IDEDMA_BYTE_COUNT_MASK)) {
    sub IDEDMA_BYTE_COUNT_MASK () {	0xffff;}
}
unless(defined(&IDEDMA_BYTE_COUNT_EOT)) {
    sub IDEDMA_BYTE_COUNT_EOT () {	0x80000000;}
}
unless(defined(&IDEDMA_BYTE_COUNT_MAX)) {
    sub IDEDMA_BYTE_COUNT_MAX () {	0x10000;}
}
unless(defined(&IDEDMA_BYTE_COUNT_ALIGN)) {
    sub IDEDMA_BYTE_COUNT_ALIGN () {	0x10000;}
}
unless(defined(&NIDEDMA_TABLES)) {
    sub NIDEDMA_TABLES () {	( &MAXPHYS/ &PAGE_SIZE + 1);}
}
1;
