require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_M88K_PARAM_H_)) {
    eval 'sub _M88K_PARAM_H_ () {1;}' unless defined(&_M88K_PARAM_H_);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub _MACHINE_ARCH () { &m88k;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"m88k";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_M88K;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {15;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub NPTEPG () {( &PAGE_SIZE / ($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub SINCR () {1;}' unless defined(&SINCR);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub UADDR () {0xeee00000;}' unless defined(&UADDR);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    require 'machine/intr.ph';
    if(defined(&_KERNEL)) {
	eval 'sub DELAY {
	    local($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
    }
    eval 'sub CPU_88100 () {0x100;}' unless defined(&CPU_88100);
    eval 'sub CPU_88110 () {0x110;}' unless defined(&CPU_88110);
}
1;
