require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&MEMORY_WAIT_TIME)) {
    sub MEMORY_WAIT_TIME () {	1000;}
}
unless(defined(&SMC_IOSIZE)) {
    sub SMC_IOSIZE () {	16;}
}
unless(defined(&BANK_SELECT_REG_W)) {
    sub BANK_SELECT_REG_W () {	0xe;}
}
unless(defined(&BSR_DETECT_MASK)) {
    sub BSR_DETECT_MASK () {	0xff00;}
}
unless(defined(&BSR_DETECT_VALUE)) {
    sub BSR_DETECT_VALUE () {	0x3300;}
}
unless(defined(&TXMIT_CONTROL_REG_W)) {
    sub TXMIT_CONTROL_REG_W () {	0x;}
}
unless(defined(&TCR_ENABLE)) {
    sub TCR_ENABLE () {	0x1;}
}
unless(defined(&TCR_LOOP)) {
    sub TCR_LOOP () {	0x2;}
}
unless(defined(&TCR_FORCOL)) {
    sub TCR_FORCOL () {	0x4;}
}
unless(defined(&TCR_PAD_ENABLE)) {
    sub TCR_PAD_ENABLE () {	0x80;}
}
unless(defined(&TCR_NOCRC)) {
    sub TCR_NOCRC () {	0x100;}
}
unless(defined(&TCR_MON_CSN)) {
    sub TCR_MON_CSN () {	0x400;}
}
unless(defined(&TCR_FDUPLX)) {
    sub TCR_FDUPLX () {	0x800;}
}
unless(defined(&TCR_STP_SQET)) {
    sub TCR_STP_SQET () {	0x1000;}
}
unless(defined(&TCR_EPH_LOOP)) {
    sub TCR_EPH_LOOP () {	0x2000;}
}
unless(defined(&EPH_STATUS_REG_W)) {
    sub EPH_STATUS_REG_W () {	0x2;}
}
unless(defined(&EPHSR_TX_SUC)) {
    sub EPHSR_TX_SUC () {	0x1;}
}
unless(defined(&EPHSR_SNGLCOL)) {
    sub EPHSR_SNGLCOL () {	0x2;}
}
unless(defined(&EPHSR_MULCOL)) {
    sub EPHSR_MULCOL () {	0x4;}
}
unless(defined(&EPHSR_LTX_MULT)) {
    sub EPHSR_LTX_MULT () {	0x8;}
}
unless(defined(&EPHSR_16COL)) {
    sub EPHSR_16COL () {	0x10;}
}
unless(defined(&EPHSR_SQET)) {
    sub EPHSR_SQET () {	0x20;}
}
unless(defined(&EPHSR_LTX_BRD)) {
    sub EPHSR_LTX_BRD () {	0x40;}
}
unless(defined(&EPHSR_DEFR)) {
    sub EPHSR_DEFR () {	0x80;}
}
unless(defined(&EPHSR_LATCOL)) {
    sub EPHSR_LATCOL () {	0x200;}
}
unless(defined(&EPHSR_LOST_CAR)) {
    sub EPHSR_LOST_CAR () {	0x400;}
}
unless(defined(&EPHSR_EXC_DEF)) {
    sub EPHSR_EXC_DEF () {	0x800;}
}
unless(defined(&EPHSR_CTR_ROL)) {
    sub EPHSR_CTR_ROL () {	0x1000;}
}
unless(defined(&EPHSR_RX_OVRN)) {
    sub EPHSR_RX_OVRN () {	0x2000;}
}
unless(defined(&EPHSR_LINK_OK)) {
    sub EPHSR_LINK_OK () {	0x4000;}
}
unless(defined(&EPHSR_TXUNRN)) {
    sub EPHSR_TXUNRN () {	0x8000;}
}
unless(defined(&RECV_CONTROL_REG_W)) {
    sub RECV_CONTROL_REG_W () {	0x4;}
}
unless(defined(&RCR_RX_ABORT)) {
    sub RCR_RX_ABORT () {	0x1;}
}
unless(defined(&RCR_PROMISC)) {
    sub RCR_PROMISC () {	0x2;}
}
unless(defined(&RCR_ALMUL)) {
    sub RCR_ALMUL () {	0x4;}
}
unless(defined(&RCR_ENABLE)) {
    sub RCR_ENABLE () {	0x100;}
}
unless(defined(&RCR_STRIP_CRC)) {
    sub RCR_STRIP_CRC () {	0x200;}
}
unless(defined(&RCR_GAIN_BITS)) {
    sub RCR_GAIN_BITS () {	0xc00;}
}
unless(defined(&RCR_FILT_CAR)) {
    sub RCR_FILT_CAR () {	0x4000;}
}
unless(defined(&RCR_SOFTRESET)) {
    sub RCR_SOFTRESET () {	0x8000;}
}
unless(defined(&COUNTER_REG_W)) {
    sub COUNTER_REG_W () {	0x6;}
}
unless(defined(&ECR_COLN_MASK)) {
    sub ECR_COLN_MASK () {	0xf;}
}
unless(defined(&ECR_MCOLN_MASK)) {
    sub ECR_MCOLN_MASK () {	0xf0;}
}
unless(defined(&ECR_DTX_MASK)) {
    sub ECR_DTX_MASK () {	0xf00;}
}
unless(defined(&ECR_EXDTX_MASK)) {
    sub ECR_EXDTX_MASK () {	0xf000;}
}
unless(defined(&MEM_INFO_REG_W)) {
    sub MEM_INFO_REG_W () {	0x8;}
}
unless(defined(&MIR_FREE_MASK)) {
    sub MIR_FREE_MASK () {	0xff00;}
}
unless(defined(&MIR_TOTAL_MASK)) {
    sub MIR_TOTAL_MASK () {	0xff;}
}
unless(defined(&MEM_CFG_REG_W)) {
    sub MEM_CFG_REG_W () {	0xa;}
}
unless(defined(&MCR_TXRSV_MASK)) {
    sub MCR_TXRSV_MASK () {	0x1f;}
}
unless(defined(&CONFIG_REG_W)) {
    sub CONFIG_REG_W () {	0x;}
}
unless(defined(&CR_INT_SEL0)) {
    sub CR_INT_SEL0 () {	0x2;}
}
unless(defined(&CR_INT_SEL1)) {
    sub CR_INT_SEL1 () {	0x4;}
}
unless(defined(&CR_DIS_LINK)) {
    sub CR_DIS_LINK () {	0x40;}
}
unless(defined(&CR_16BIT)) {
    sub CR_16BIT () {	0x80;}
}
unless(defined(&CR_AUI_SELECT)) {
    sub CR_AUI_SELECT () {	0x100;}
}
unless(defined(&CR_SET_SQLCH)) {
    sub CR_SET_SQLCH () {	0x200;}
}
unless(defined(&CR_FULL_STEP)) {
    sub CR_FULL_STEP () {	0x400;}
}
unless(defined(&CR_NOW_WAIT_ST)) {
    sub CR_NOW_WAIT_ST () {	0x1000;}
}
unless(defined(&BASE_ADDR_REG_W)) {
    sub BASE_ADDR_REG_W () {	0x2;}
}
unless(defined(&IAR_ADDR0_REG_W)) {
    sub IAR_ADDR0_REG_W () {	0x4;}
}
unless(defined(&IAR_ADDR1_REG_W)) {
    sub IAR_ADDR1_REG_W () {	0x6;}
}
unless(defined(&IAR_ADDR2_REG_W)) {
    sub IAR_ADDR2_REG_W () {	0x8;}
}
unless(defined(&GENERAL_REG_W)) {
    sub GENERAL_REG_W () {	0xa;}
}
unless(defined(&CONTROL_REG_W)) {
    sub CONTROL_REG_W () {	0xc;}
}
unless(defined(&CTR_STORE)) {
    sub CTR_STORE () {	0x1;}
}
unless(defined(&CTR_RELOAD)) {
    sub CTR_RELOAD () {	0x2;}
}
unless(defined(&CTR_EEPROM_SEL)) {
    sub CTR_EEPROM_SEL () {	0x4;}
}
unless(defined(&CTR_TE_ENABLE)) {
    sub CTR_TE_ENABLE () {	0x20;}
}
unless(defined(&CTR_CR_ENABLE)) {
    sub CTR_CR_ENABLE () {	0x40;}
}
unless(defined(&CTR_LE_ENABLE)) {
    sub CTR_LE_ENABLE () {	0x80;}
}
unless(defined(&CTR_AUTO_RELEASE)) {
    sub CTR_AUTO_RELEASE () {	0x800;}
}
unless(defined(&CTR_POWERDOWN)) {
    sub CTR_POWERDOWN () {	0x2000;}
}
unless(defined(&CTR_RCV_BAD)) {
    sub CTR_RCV_BAD () {	0x4000;}
}
unless(defined(&MMU_CMD_REG_W)) {
    sub MMU_CMD_REG_W () {	0x;}
}
unless(defined(&MMUCR_BUSY)) {
    sub MMUCR_BUSY () {	0x1;}
}
unless(defined(&MMUCR_NOP)) {
    sub MMUCR_NOP () {	0x;}
}
unless(defined(&MMUCR_ALLOC)) {
    sub MMUCR_ALLOC () {	0x20;}
}
unless(defined(&MMUCR_RESET)) {
    sub MMUCR_RESET () {	0x40;}
}
unless(defined(&MMUCR_REMOVE)) {
    sub MMUCR_REMOVE () {	0x60;}
}
unless(defined(&MMUCR_RELEASE)) {
    sub MMUCR_RELEASE () {	0x80;}
}
unless(defined(&MMUCR_FREEPKT)) {
    sub MMUCR_FREEPKT () {	0xa0;}
}
unless(defined(&MMUCR_ENQUEUE)) {
    sub MMUCR_ENQUEUE () {	0xc0;}
}
unless(defined(&MMUCR_RESETTX)) {
    sub MMUCR_RESETTX () {	0xe0;}
}
unless(defined(&PACKET_NUM_REG_B)) {
    sub PACKET_NUM_REG_B () {	0x2;}
}
unless(defined(&ALLOC_RESULT_REG_B)) {
    sub ALLOC_RESULT_REG_B () {	0x3;}
}
unless(defined(&ARR_FAILED)) {
    sub ARR_FAILED () {	0x80;}
}
unless(defined(&FIFO_PORTS_REG_W)) {
    sub FIFO_PORTS_REG_W () {	0x4;}
}
unless(defined(&FIFO_REMPTY)) {
    sub FIFO_REMPTY () {	0x8000;}
}
unless(defined(&FIFO_TEMPTY)) {
    sub FIFO_TEMPTY () {	0x80;}
}
unless(defined(&FIFO_RX_MASK)) {
    sub FIFO_RX_MASK () {	0x7f00;}
}
unless(defined(&FIFO_TX_MASK)) {
    sub FIFO_TX_MASK () {	0x7f;}
}
unless(defined(&POINTER_REG_W)) {
    sub POINTER_REG_W () {	0x6;}
}
unless(defined(&PTR_READ)) {
    sub PTR_READ () {	0x2000;}
}
unless(defined(&PTR_AUTOINC)) {
    sub PTR_AUTOINC () {	0x4000;}
}
unless(defined(&PTR_RCV)) {
    sub PTR_RCV () {	0x8000;}
}
unless(defined(&DATA_REG_W)) {
    sub DATA_REG_W () {	0x8;}
}
unless(defined(&DATA_REG_B)) {
    sub DATA_REG_B () {	0x8;}
}
unless(defined(&DATA_1_REG_B)) {
    sub DATA_1_REG_B () {	0x8;}
}
unless(defined(&DATA_2_REG_B)) {
    sub DATA_2_REG_B () {	0xa;}
}
unless(defined(&INTR_STAT_REG_B)) {
    sub INTR_STAT_REG_B () {	0xc;}
}
unless(defined(&INTR_ACK_REG_B)) {
    sub INTR_ACK_REG_B () {	0xc;}
}
unless(defined(&INTR_MASK_REG_B)) {
    sub INTR_MASK_REG_B () {	0xd;}
}
unless(defined(&IM_RCV_INT)) {
    sub IM_RCV_INT () {	0x1;}
}
unless(defined(&IM_TX_INT)) {
    sub IM_TX_INT () {	0x2;}
}
unless(defined(&IM_TX_EMPTY_INT)) {
    sub IM_TX_EMPTY_INT () {	0x4;}
}
unless(defined(&IM_ALLOC_INT)) {
    sub IM_ALLOC_INT () {	0x8;}
}
unless(defined(&IM_RX_OVRN_INT)) {
    sub IM_RX_OVRN_INT () {	0x10;}
}
unless(defined(&IM_EPH_INT)) {
    sub IM_EPH_INT () {	0x20;}
}
unless(defined(&IM_ERCV_INT)) {
    sub IM_ERCV_INT () {	0x40;}
}
unless(defined(&MULTICAST1_REG_W)) {
    sub MULTICAST1_REG_W () {	0x;}
}
unless(defined(&MULTICAST2_REG_W)) {
    sub MULTICAST2_REG_W () {	0x2;}
}
unless(defined(&MULTICAST3_REG_W)) {
    sub MULTICAST3_REG_W () {	0x4;}
}
unless(defined(&MULTICAST4_REG_W)) {
    sub MULTICAST4_REG_W () {	0x6;}
}
unless(defined(&MGMT_REG_W)) {
    sub MGMT_REG_W () {	0x8;}
}
unless(defined(&REVISION_REG_W)) {
    sub REVISION_REG_W () {	0xa;}
}
unless(defined(&RR_REV)) {
    sub RR_REV {
	local($x) = @_;
	eval q((($x) & 0xf));
    }
}
unless(defined(&RR_ID)) {
    sub RR_ID {
	local($x) = @_;
	eval q(((($x) >> 4) & 0xf));
    }
}
unless(defined(&ERCV_REG_W)) {
    sub ERCV_REG_W () {	0xc;}
}
unless(defined(&CHIP_9190)) {
    sub CHIP_9190 () {	3;}
}
unless(defined(&CHIP_9194)) {
    sub CHIP_9194 () {	4;}
}
unless(defined(&CHIP_9195)) {
    sub CHIP_9195 () {	5;}
}
unless(defined(&CHIP_91100)) {
    sub CHIP_91100 () {	7;}
}
unless(defined(&RS_MULTICAST)) {
    sub RS_MULTICAST () {	0x1;}
}
unless(defined(&RS_HASH_MASK)) {
    sub RS_HASH_MASK () {	0x7e;}
}
unless(defined(&RS_TOOSHORT)) {
    sub RS_TOOSHORT () {	0x400;}
}
unless(defined(&RS_TOOLONG)) {
    sub RS_TOOLONG () {	0x800;}
}
unless(defined(&RS_ODDFRAME)) {
    sub RS_ODDFRAME () {	0x1000;}
}
unless(defined(&RS_BADCRC)) {
    sub RS_BADCRC () {	0x2000;}
}
unless(defined(&RS_ALGNERR)) {
    sub RS_ALGNERR () {	0x8000;}
}
unless(defined(&RS_ERRORS)) {
    sub RS_ERRORS () {	( &RS_ALGNERR |  &RS_BADCRC |  &RS_TOOLONG |  &RS_TOOSHORT);}
}
unless(defined(&RLEN_MASK)) {
    sub RLEN_MASK () {	0x7ff;}
}
unless(defined(&CTLB_CRC)) {
    sub CTLB_CRC () {	0x10;}
}
unless(defined(&CTLB_ODD)) {
    sub CTLB_ODD () {	0x20;}
}
1;
