require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC7XXX_INLINE_H_)) {
    eval 'sub _AIC7XXX_INLINE_H_ () {1;}' unless defined(&_AIC7XXX_INLINE_H_);
    eval 'sub ahc_sg_virt_to_bus {
        local($scb,$sg) = @_;
	    eval q({ \'int\'  &sg_index;  &sg_index = $sg -  ($scb->{sg_list[1]}); ( ($scb->{sg_list_phys}) + ( &sg_index * $sizeof{ ($scb->{sg_list})})); });
    }' unless defined(&ahc_sg_virt_to_bus);
    eval 'sub ahc_hscb_busaddr {
        local($ahc,$index) = @_;
	    eval q({ ( ($ahc->{scb_data}->{hscb_busaddr})  + ($sizeof{\'struct hardware_scb\'} * $index)); });
    }' unless defined(&ahc_hscb_busaddr);
    eval 'sub ahc_sync_scb {
        local($ahc,$scb,$op) = @_;
	    eval q({  &ahc_dmamap_sync($ahc,  ($ahc->{parent_dmat}),  ($ahc->{scb_data}->{h$scb_dmamap}), ( ($scb->{h$scb}) -  ($ahc->{scb_data}->{h$scbs})) * $sizeof{ ($scb->{h$scb})}, $sizeof{ ($scb->{h$scb})}, $op); });
    }' unless defined(&ahc_sync_scb);
    eval 'sub ahc_sync_sglist {
        local($ahc,$scb,$op) = @_;
	    eval q({  &if ( ($scb->{sg_count}) == 0) ;  &ahc_dmamap_sync($ahc,  ($ahc->{parent_dmat}),  ($scb->{sg_map}->{sg_dmamap}), ( ($scb->{sg_list}) -  ($scb->{sg_map}->{sg_vaddr})) * $sizeof{\'struct ahc_dma_seg\'}, $sizeof{\'struct ahc_dma_seg\'} *  ($scb->{sg_count}), $op); });
    }' unless defined(&ahc_sync_sglist);
    eval 'sub ahc_targetcmd_offset {
        local($ahc,$index) = @_;
	    eval q({ ((( &uint8_t *) ($ahc->{targetcmds[$index]})) -  ($ahc->{qoutfifo})); });
    }' unless defined(&ahc_targetcmd_offset);
    eval 'sub ahc_name {
        local($ahc) = @_;
	    eval q({ ( ($ahc->{name})); });
    }' unless defined(&ahc_name);
    eval 'sub ahc_inw {
        local($ahc,$port) = @_;
	    eval q({ (( &ahc_inb($ahc, $port+1) << 8) |  &ahc_inb($ahc, $port)); });
    }' unless defined(&ahc_inw);
    eval 'sub ahc_outw {
        local($ahc,$port,$value) = @_;
	    eval q({  &ahc_outb($ahc, $port, $value & 0xff);  &ahc_outb($ahc, $port+1, ($value >> 8) & 0xff); });
    }' unless defined(&ahc_outw);
    eval 'sub ahc_inl {
        local($ahc,$port) = @_;
	    eval q({ (( &ahc_inb($ahc, $port)) | ( &ahc_inb($ahc, $port+1) << 8) | ( &ahc_inb($ahc, $port+2) << 16) | ( &ahc_inb($ahc, $port+3) << 24)); });
    }' unless defined(&ahc_inl);
    eval 'sub ahc_outl {
        local($ahc,$port,$value) = @_;
	    eval q({  &ahc_outb($ahc, $port, ($value) & 0xff);  &ahc_outb($ahc, $port+1, (($value) >> 8) & 0xff);  &ahc_outb($ahc, $port+2, (($value) >> 16) & 0xff);  &ahc_outb($ahc, $port+3, (($value) >> 24) & 0xff); });
    }' unless defined(&ahc_outl);
    eval 'sub ahc_inq {
        local($ahc,$port) = @_;
	    eval q({ (( &ahc_inb($ahc, $port)) | ( &ahc_inb($ahc, $port+1) << 8) | ( &ahc_inb($ahc, $port+2) << 16) | ( &ahc_inb($ahc, $port+3) << 24) | ((( &uint64_t) &ahc_inb($ahc, $port+4)) << 32) | ((( &uint64_t) &ahc_inb($ahc, $port+5)) << 40) | ((( &uint64_t) &ahc_inb($ahc, $port+6)) << 48) | ((( &uint64_t) &ahc_inb($ahc, $port+7)) << 56)); });
    }' unless defined(&ahc_inq);
    eval 'sub ahc_outq {
        local($ahc,$port,$value) = @_;
	    eval q({  &ahc_outb($ahc, $port, $value & 0xff);  &ahc_outb($ahc, $port+1, ($value >> 8) & 0xff);  &ahc_outb($ahc, $port+2, ($value >> 16) & 0xff);  &ahc_outb($ahc, $port+3, ($value >> 24) & 0xff);  &ahc_outb($ahc, $port+4, ($value >> 32) & 0xff);  &ahc_outb($ahc, $port+5, ($value >> 40) & 0xff);  &ahc_outb($ahc, $port+6, ($value >> 48) & 0xff);  &ahc_outb($ahc, $port+7, ($value >> 56) & 0xff); });
    }' unless defined(&ahc_outq);
    eval 'sub ahc_lookup_scb {
        local($ahc,$tag) = @_;
	    eval q({ \'struct scb\'*  &scb;  &scb =  ($ahc->{scb_data}->{scbindex[$tag]});  &if ( &scb !=  &NULL)  &ahc_sync_scb($ahc,  &scb,  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE); ( &scb); });
    }' unless defined(&ahc_lookup_scb);
    eval 'sub ahc_swap_with_next_hscb {
        local($ahc,$scb) = @_;
	    eval q({ \'struct hardware_scb\' * &q_hscb; \'u_int\'  &saved_tag;  &q_hscb =  ($ahc->{next_queued_scb}->{h$scb});  &saved_tag =  ($q_hscb->{tag});  &memcpy( &q_hscb,  ($scb->{h$scb}), $sizeof{ ($scb->{h$scb})});  &if (( ($scb->{flags}) &  &SCB_CDB32_PTR) != 0) {  ($q_hscb->{shared_data}->{cdb_ptr}) =  &ahc_htole32( &ahc_hscb_busaddr($ahc,  ($q_hscb->{tag})) +  &offsetof(\'struct hardware_scb\',  &cdb32)); }  ($q_hscb->{tag}) =  &saved_tag;  ($q_hscb->{next}) =  ($scb->{h$scb}->{tag});  ($ahc->{next_queued_scb}->{h$scb}) =  ($scb->{h$scb});  ($scb->{h$scb}) =  &q_hscb;  ($ahc->{scb_data}->{scbindex[$scb}->{h$scb}->{tag]}) = $scb; });
    }' unless defined(&ahc_swap_with_next_hscb);
    eval 'sub ahc_get_sense_buf {
        local($ahc,$scb) = @_;
	    eval q({ \'int\'  &offset;  &offset = $scb -  ($ahc->{scb_data}->{scbarray}); ( ($ahc->{scb_data}->{sense[&offset]})); });
    }' unless defined(&ahc_get_sense_buf);
    eval 'sub ahc_get_sense_bufaddr {
        local($ahc,$scb) = @_;
	    eval q({ \'int\'  &offset;  &offset = $scb -  ($ahc->{scb_data}->{scbarray}); ( ($ahc->{scb_data}->{sense_busaddr})  + ( &offset * $sizeof{\'struct scsi_sense_data\'})); });
    }' unless defined(&ahc_get_sense_bufaddr);
    eval 'sub ahc_sync_qoutfifo {
        local($ahc,$op) = @_;
	    eval q({  &ahc_dmamap_sync($ahc,  ($ahc->{parent_dmat}),  ($ahc->{shared_data_dmamap}), 0, 256, $op); });
    }' unless defined(&ahc_sync_qoutfifo);
    eval 'sub ahc_sync_qinfifo {
        local($ahc,$op) = @_;
	    eval q({  &ahc_dmamap_sync($ahc,  ($ahc->{parent_dmat}),  ($ahc->{shared_data_dmamap}), 256, 256, $op); });
    }' unless defined(&ahc_sync_qinfifo);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub ahc_sync_tqinfifo {
        local($ahc,$op) = @_;
	    eval q({ });
    }' unless defined(&ahc_sync_tqinfifo);
    eval 'sub AHC_RUN_QOUTFIFO () {0x1;}' unless defined(&AHC_RUN_QOUTFIFO);
    eval 'sub AHC_RUN_TQINFIFO () {0x2;}' unless defined(&AHC_RUN_TQINFIFO);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub ahc_check_cmdcmpltqueues {
        local($ahc) = @_;
	    eval q({ \'u_int\'  &retval;  &retval = 0;  &ahc_dmamap_sync($ahc,  ($ahc->{parent_dmat})  ,  ($ahc->{shared_data_dmamap}),  ($ahc->{qoutfifonext}), 1,  &BUS_DMASYNC_POSTREAD);  &if ( ($ahc->{qoutfifo[$ahc}->{qoutfifonext]}) !=  &SCB_LIST_NULL)  &retval |=  &AHC_RUN_QOUTFIFO; ( &retval); });
    }' unless defined(&ahc_check_cmdcmpltqueues);
    if(defined(&AHC_TARGET_MODE)) {
    }
    if((defined(&AHC_PCI_CONFIG) ? &AHC_PCI_CONFIG : 0) > 0) {
    }
}
1;
