require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC79XX_OPENBSD_H_)) {
    eval 'sub _AIC79XX_OPENBSD_H_ () {1;}' unless defined(&_AIC79XX_OPENBSD_H_);
    require 'pci.ph';
    require 'sys/param.ph';
    require 'sys/kernel.ph';
    require 'sys/systm.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/queue.ph';
    eval 'sub AIC_PCI_CONFIG () {1;}' unless defined(&AIC_PCI_CONFIG);
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'scsi/scsiconf.ph';
    require 'uvm/uvm_extern.ph';
    if(defined(&DEBUG)) {
	eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
    } else {
	eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
    }
    eval 'sub SCSI_IS_SCSIBUS_B {
        local($ahd, $sc_link) = @_;
	    eval q((0));
    }' unless defined(&SCSI_IS_SCSIBUS_B);
    eval 'sub SCSI_CHANNEL {
        local($ahd, $sc_link) = @_;
	    eval q((ord(\'A\')));
    }' unless defined(&SCSI_CHANNEL);
    eval 'sub SCSI_SCSI_ID {
        local($ahd, $sc_link) = @_;
	    eval q(( ($ahd->{our_id})));
    }' unless defined(&SCSI_SCSI_ID);
    eval 'sub BUILD_SCSIID {
        local($ahd, $sc_link, $target_id, $our_id) = @_;
	    eval q((((($target_id) <<  &TID_SHIFT) &  &TID) | ($our_id)));
    }' unless defined(&BUILD_SCSIID);
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    local($type, $member) = @_;
    	    eval q((((($type *)0)->$member)));
	}' unless defined(&offsetof);
    }
    eval 'sub ahd_dmamap_sync {
        local($ahc, $dma_tag, $dmamap, $offset, $len, $op) = @_;
	    eval q( &bus_dmamap_sync($dma_tag, $dmamap, $offset, $len, $op));
    }' unless defined(&ahd_dmamap_sync);
    eval 'sub AHD_NSEG () {( &roundup( &btoc( &MAXPHYS) + 1, 16));}' unless defined(&AHD_NSEG);
    eval 'sub ahd_htobe16 {
        local($x) = @_;
	    eval q( &htobe16($x));
    }' unless defined(&ahd_htobe16);
    eval 'sub ahd_htobe32 {
        local($x) = @_;
	    eval q( &htobe32($x));
    }' unless defined(&ahd_htobe32);
    eval 'sub ahd_htobe64 {
        local($x) = @_;
	    eval q( &htobe64($x));
    }' unless defined(&ahd_htobe64);
    eval 'sub ahd_htole16 {
        local($x) = @_;
	    eval q( &htole16($x));
    }' unless defined(&ahd_htole16);
    eval 'sub ahd_htole32 {
        local($x) = @_;
	    eval q( &htole32($x));
    }' unless defined(&ahd_htole32);
    eval 'sub ahd_htole64 {
        local($x) = @_;
	    eval q( &htole64($x));
    }' unless defined(&ahd_htole64);
    eval 'sub ahd_be16toh {
        local($x) = @_;
	    eval q( &be16toh($x));
    }' unless defined(&ahd_be16toh);
    eval 'sub ahd_be32toh {
        local($x) = @_;
	    eval q( &be32toh($x));
    }' unless defined(&ahd_be32toh);
    eval 'sub ahd_be64toh {
        local($x) = @_;
	    eval q( &be64toh($x));
    }' unless defined(&ahd_be64toh);
    eval 'sub ahd_le16toh {
        local($x) = @_;
	    eval q( &letoh16($x));
    }' unless defined(&ahd_le16toh);
    eval 'sub ahd_le32toh {
        local($x) = @_;
	    eval q( &letoh32($x));
    }' unless defined(&ahd_le32toh);
    eval 'sub ahd_le64toh {
        local($x) = @_;
	    eval q( &letoh64($x));
    }' unless defined(&ahd_le64toh);
    if((defined(&AHD_REG_PRETTY_PRINT) ? &AHD_REG_PRETTY_PRINT : 0)) {
	eval 'sub AIC_DEBUG_REGISTERS () {1;}' unless defined(&AIC_DEBUG_REGISTERS);
    } else {
	eval 'sub AIC_DEBUG_REGISTERS () {0;}' unless defined(&AIC_DEBUG_REGISTERS);
    }
    require 'dev/ic/aic79xx.ph';
    eval 'sub ahd_timer_init () { &callout_init;}' unless defined(&ahd_timer_init);
    eval 'sub ahd_timer_stop () { &callout_stop;}' unless defined(&ahd_timer_stop);
    eval 'sub ahd_inb {
        local($ahd, $port) = @_;
	    eval q( &bus_space_read_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff));
    }' unless defined(&ahd_inb);
    eval 'sub ahd_outb {
        local($ahd, $port, $value) = @_;
	    eval q( &bus_space_write_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff, $value));
    }' unless defined(&ahd_outb);
    eval 'sub ahd_inw_atomic {
        local($ahd, $port) = @_;
	    eval q( &ahd_le16toh( &bus_space_read_2(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port) & 0xff)));
    }' unless defined(&ahd_inw_atomic);
    eval 'sub ahd_outw_atomic {
        local($ahd, $port, $value) = @_;
	    eval q( &bus_space_write_2(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff),  &ahd_htole16($value)));
    }' unless defined(&ahd_outw_atomic);
    eval 'sub ahd_outsb {
        local($ahd, $port, $valp, $count) = @_;
	    eval q( &bus_space_write_multi_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff), $valp, $count));
    }' unless defined(&ahd_outsb);
    eval 'sub ahd_insb {
        local($ahd, $port, $valp, $count) = @_;
	    eval q( &bus_space_read_multi_1(($ahd)-> $tags[($port) >> 8], ($ahd)-> $bshs[($port) >> 8], ($port & 0xff), $valp, $count));
    }' unless defined(&ahd_insb);
    eval 'sub ahd_delay () { &DELAY;}' unless defined(&ahd_delay);
    eval("sub AHD_POWER_STATE_D0 () { 0; }") unless defined(&AHD_POWER_STATE_D0);
    eval("sub AHD_POWER_STATE_D1 () { 1; }") unless defined(&AHD_POWER_STATE_D1);
    eval("sub AHD_POWER_STATE_D2 () { 2; }") unless defined(&AHD_POWER_STATE_D2);
    eval("sub AHD_POWER_STATE_D3 () { 3; }") unless defined(&AHD_POWER_STATE_D3);
    eval 'sub ahd_platform_init () {1;}' unless defined(&ahd_platform_init);
    eval 'sub SIU_TASKMGMT_NONE () {0x;}' unless defined(&SIU_TASKMGMT_NONE);
    eval 'sub SIU_TASKMGMT_ABORT_TASK () {0x1;}' unless defined(&SIU_TASKMGMT_ABORT_TASK);
    eval 'sub SIU_TASKMGMT_ABORT_TASK_SET () {0x2;}' unless defined(&SIU_TASKMGMT_ABORT_TASK_SET);
    eval 'sub SIU_TASKMGMT_CLEAR_TASK_SET () {0x4;}' unless defined(&SIU_TASKMGMT_CLEAR_TASK_SET);
    eval 'sub SIU_TASKMGMT_LUN_RESET () {0x8;}' unless defined(&SIU_TASKMGMT_LUN_RESET);
    eval 'sub SIU_TASKMGMT_TARGET_RESET () {0x20;}' unless defined(&SIU_TASKMGMT_TARGET_RESET);
    eval 'sub SIU_TASKMGMT_CLEAR_ACA () {0x40;}' unless defined(&SIU_TASKMGMT_CLEAR_ACA);
}
1;
