/*	$OpenBSD: vt220l8x8.h,v 1.1 2001/03/18 04:30:24 nate Exp $ */
/* 	$NetBSD: vt220l8x8.h,v 1.3 2000/01/05 18:44:25 ad Exp $	*/

/*
 * Copyright (c) 1992, 1995 Hellmuth Michaelis and Joerg Wunsch
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by
 *	Hellmuth Michaelis and Joerg Wunsch
 * 4. The name authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Translated into a wsfont form by Shin Takemura in Nov 2, 1999.
 */

extern u_char vt220l8x8_data[];

struct wsdisplay_font vt220l8x8 = {
	"vt220l",			/* typeface name */
	0,				/* index */
	'\0',				/* firstchar */
	256,				/* numchars */
	WSDISPLAY_FONTENC_IBM,		/* encoding */
	8,				/* width */
	8,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	vt220l8x8_data			/* data */
};

static u_char vt220l8x8_data[] = {
	/* code 0 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 1 */
	0x7e, /* ..############.. */
	0x81, /* ##............## */
	0xa5, /* ##..##....##..## */
	0x81, /* ##............## */
	0xbd, /* ##..########..## */
	0x99, /* ##....####....## */
	0x81, /* ##............## */
	0x7e, /* ..############.. */

	/* code 2 */
	0x7e, /* ..############.. */
	0xff, /* ################ */
	0xdb, /* ####..####..#### */
	0xff, /* ################ */
	0xc3, /* ####........#### */
	0xe7, /* ######....###### */
	0xff, /* ################ */
	0x7e, /* ..############.. */

	/* code 3 */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x00, /* ................ */

	/* code 4 */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x00, /* ................ */

	/* code 5 */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0x10, /* ......##........ */
	0x38, /* ....######...... */

	/* code 6 */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x10, /* ......##........ */
	0x38, /* ....######...... */

	/* code 7 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 8 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xe7, /* ######....###### */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0xe7, /* ######....###### */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 9 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */

	/* code 10 */
	0xff, /* ################ */
	0xc3, /* ####........#### */
	0x99, /* ##....####....## */
	0xbd, /* ##..########..## */
	0xbd, /* ##..########..## */
	0x99, /* ##....####....## */
	0xc3, /* ####........#### */
	0xff, /* ################ */

	/* code 11 */
	0x1f, /* ......########## */
	0x07, /* ..........###### */
	0x0d, /* ........####..## */
	0x79, /* ..########....## */
	0xcd, /* ####....####..## */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */

	/* code 12 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */

	/* code 13 */
	0x38, /* ....######...... */
	0x3c, /* ....########.... */
	0x36, /* ....####..####.. */
	0x32, /* ....####....##.. */
	0x34, /* ....####..##.... */
	0x70, /* ..######........ */
	0xf0, /* ########........ */
	0xe0, /* ######.......... */

	/* code 14 */
	0x7f, /* ..############## */
	0x63, /* ..####......#### */
	0x7f, /* ..############## */
	0x63, /* ..####......#### */
	0x63, /* ..####......#### */
	0x67, /* ..####....###### */
	0xe6, /* ######....####.. */
	0xc0, /* ####............ */

	/* code 15 */
	0x18, /* ......####...... */
	0xdb, /* ####..####..#### */
	0x3c, /* ....########.... */
	0xe7, /* ######....###### */
	0xe7, /* ######....###### */
	0x3c, /* ....########.... */
	0xdb, /* ####..####..#### */
	0x18, /* ......####...... */

	/* code 16 */
	0x80, /* ##.............. */
	0xe0, /* ######.......... */
	0xf8, /* ##########...... */
	0xfe, /* ##############.. */
	0xf8, /* ##########...... */
	0xe0, /* ######.......... */
	0x80, /* ##.............. */
	0x00, /* ................ */

	/* code 17 */
	0x02, /* ............##.. */
	0x0e, /* ........######.. */
	0x3e, /* ....##########.. */
	0xfe, /* ##############.. */
	0x3e, /* ....##########.. */
	0x0e, /* ........######.. */
	0x02, /* ............##.. */
	0x00, /* ................ */

	/* code 18 */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */

	/* code 19 */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x00, /* ................ */
	0x66, /* ..####....####.. */
	0x00, /* ................ */

	/* code 20 */
	0x7f, /* ..############## */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0x7b, /* ..########..#### */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x00, /* ................ */

	/* code 21 */
	0x7e, /* ..############.. */
	0xc3, /* ####........#### */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x3f, /* ....############ */
	0xc3, /* ####........#### */
	0x7e, /* ..############.. */

	/* code 22 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 23 */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0xff, /* ################ */

	/* code 24 */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 25 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 26 */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0xfe, /* ##############.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 27 */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xfe, /* ##############.. */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 28 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 29 */
	0x00, /* ................ */
	0x24, /* ....##....##.... */
	0x66, /* ..####....####.. */
	0xff, /* ################ */
	0x66, /* ..####....####.. */
	0x24, /* ....##....##.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 30 */
	0x00, /* ................ */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 31 */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 32 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 33 */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 34 */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 35 */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */

	/* code 36 */
	0x30, /* ....####........ */
	0x7c, /* ..##########.... */
	0xc0, /* ####............ */
	0x7c, /* ..##########.... */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 37 */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xcc, /* ####....####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x66, /* ..####....####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 38 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0xce, /* ####....######.. */
	0x7b, /* ..########..#### */
	0x00, /* ................ */

	/* code 39 */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 40 */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 41 */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 42 */
	0x00, /* ................ */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0xfe, /* ##############.. */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 43 */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 44 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */

	/* code 45 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 46 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 47 */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0x80, /* ##.............. */
	0x00, /* ................ */

	/* code 48 */
	0x7c, /* ..##########.... */
	0xce, /* ####....######.. */
	0xde, /* ####..########.. */
	0xf6, /* ########..####.. */
	0xe6, /* ######....####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 49 */
	0x30, /* ....####........ */
	0x70, /* ..######........ */
	0xb0, /* ##..####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 50 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0x0c, /* ........####.... */
	0x38, /* ....######...... */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 51 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0x0c, /* ........####.... */
	0x38, /* ....######...... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 52 */
	0x1c, /* ......######.... */
	0x3c, /* ....########.... */
	0x6c, /* ..####..####.... */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0x0c, /* ........####.... */
	0x1e, /* ......########.. */
	0x00, /* ................ */

	/* code 53 */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0xf8, /* ##########...... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 54 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xc0, /* ####............ */
	0xf8, /* ##########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 55 */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 56 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 57 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 58 */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 59 */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */

	/* code 60 */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 61 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 62 */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 63 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 64 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xde, /* ####..########.. */
	0xde, /* ####..########.. */
	0xde, /* ####..########.. */
	0xc0, /* ####............ */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 65 */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 66 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 67 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 68 */
	0xf8, /* ##########...... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0xf8, /* ##########...... */
	0x00, /* ................ */

	/* code 69 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x62, /* ..####......##.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 70 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 71 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xce, /* ####....######.. */
	0x66, /* ..####....####.. */
	0x3e, /* ....##########.. */
	0x00, /* ................ */

	/* code 72 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 73 */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 74 */
	0x1e, /* ......########.. */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 75 */
	0xe6, /* ######....####.. */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x70, /* ..######........ */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 76 */
	0xf0, /* ########........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x62, /* ..####......##.. */
	0x66, /* ..####....####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 77 */
	0xc6, /* ####......####.. */
	0xee, /* ######..######.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 78 */
	0xc6, /* ####......####.. */
	0xe6, /* ######....####.. */
	0xf6, /* ########..####.. */
	0xde, /* ####..########.. */
	0xce, /* ####....######.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 79 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 80 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 81 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xdc, /* ####..######.... */
	0x78, /* ..########...... */
	0x1c, /* ......######.... */
	0x00, /* ................ */

	/* code 82 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 83 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 84 */
	0xfc, /* ############.... */
	0xb4, /* ##..####..##.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 85 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 86 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 87 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 88 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 89 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 90 */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0x98, /* ##....####...... */
	0x30, /* ....####........ */
	0x64, /* ..####....##.... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 91 */
	0x78, /* ..########...... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 92 */
	0xc0, /* ####............ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x06, /* ..........####.. */
	0x02, /* ............##.. */
	0x00, /* ................ */

	/* code 93 */
	0x78, /* ..########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 94 */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 95 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */

	/* code 96 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 97 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 98 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 99 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xc0, /* ####............ */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 100 */
	0x1c, /* ......######.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 101 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 102 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x60, /* ..####.......... */
	0xf8, /* ##########...... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 103 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0xf8, /* ##########...... */

	/* code 104 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x6c, /* ..####..####.... */
	0x76, /* ..######..####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 105 */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 106 */
	0x0c, /* ........####.... */
	0x00, /* ................ */
	0x1c, /* ......######.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */

	/* code 107 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 108 */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 109 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 110 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 111 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 112 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */

	/* code 113 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0x1e, /* ......########.. */

	/* code 114 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0x76, /* ..######..####.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 115 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc0, /* ####............ */
	0x7c, /* ..##########.... */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 116 */
	0x10, /* ......##........ */
	0x30, /* ....####........ */
	0x7c, /* ..##########.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x36, /* ....####..####.. */
	0x1c, /* ......######.... */
	0x00, /* ................ */

	/* code 117 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 118 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 119 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */

	/* code 120 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 121 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0xf8, /* ##########...... */

	/* code 122 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x98, /* ##....####...... */
	0x30, /* ....####........ */
	0x64, /* ..####....##.... */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 123 */
	0x1c, /* ......######.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xe0, /* ######.......... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x1c, /* ......######.... */
	0x00, /* ................ */

	/* code 124 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 125 */
	0xe0, /* ######.......... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x1c, /* ......######.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xe0, /* ######.......... */
	0x00, /* ................ */

	/* code 126 */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 127 */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 128 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xc0, /* ####............ */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x78, /* ..########...... */

	/* code 129 */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 130 */
	0x1c, /* ......######.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 131 */
	0x7e, /* ..############.. */
	0xc3, /* ####........#### */
	0x3c, /* ....########.... */
	0x06, /* ..........####.. */
	0x3e, /* ....##########.. */
	0x66, /* ..####....####.. */
	0x3f, /* ....############ */
	0x00, /* ................ */

	/* code 132 */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 133 */
	0xe0, /* ######.......... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 134 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 135 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x38, /* ....######...... */

	/* code 136 */
	0x7e, /* ..############.. */
	0xc3, /* ####........#### */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x7e, /* ..############.. */
	0x60, /* ..####.......... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 137 */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 138 */
	0xe0, /* ######.......... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 139 */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 140 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0x38, /* ....######...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 141 */
	0xe0, /* ######.......... */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 142 */
	0xc6, /* ####......####.. */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 143 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 144 */
	0x1c, /* ......######.... */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x60, /* ..####.......... */
	0x78, /* ..########...... */
	0x60, /* ..####.......... */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 145 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7f, /* ..############## */
	0x0c, /* ........####.... */
	0x7f, /* ..############## */
	0xcc, /* ####....####.... */
	0x7f, /* ..############## */
	0x00, /* ................ */

	/* code 146 */
	0x3e, /* ....##########.. */
	0x6c, /* ..####..####.... */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xce, /* ####....######.. */
	0x00, /* ................ */

	/* code 147 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 148 */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 149 */
	0x00, /* ................ */
	0xe0, /* ######.......... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 150 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 151 */
	0x00, /* ................ */
	0xe0, /* ######.......... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 152 */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0xf8, /* ##########...... */

	/* code 153 */
	0xc3, /* ####........#### */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 154 */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 155 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 156 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x64, /* ..####....##.... */
	0xf0, /* ########........ */
	0x60, /* ..####.......... */
	0xe6, /* ######....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 157 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */

	/* code 158 */
	0xf8, /* ##########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xfa, /* ##########..##.. */
	0xc6, /* ####......####.. */
	0xcf, /* ####....######## */
	0xc6, /* ####......####.. */
	0xc7, /* ####......###### */

	/* code 159 */
	0x0e, /* ........######.. */
	0x1b, /* ......####..#### */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xd8, /* ####..####...... */
	0x70, /* ..######........ */

	/* code 160 */
	0x1c, /* ......######.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 161 */
	0x38, /* ....######...... */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 162 */
	0x00, /* ................ */
	0x1c, /* ......######.... */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 163 */
	0x00, /* ................ */
	0x1c, /* ......######.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 164 */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 165 */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xec, /* ######..####.... */
	0xfc, /* ############.... */
	0xdc, /* ####..######.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 166 */
	0x3c, /* ....########.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x3e, /* ....##########.. */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 167 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 168 */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 169 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 170 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 171 */
	0xc3, /* ####........#### */
	0xc6, /* ####......####.. */
	0xcc, /* ####....####.... */
	0xde, /* ####..########.. */
	0x33, /* ....####....#### */
	0x66, /* ..####....####.. */
	0xcc, /* ####....####.... */
	0x0f, /* ........######## */

	/* code 172 */
	0xc3, /* ####........#### */
	0xc6, /* ####......####.. */
	0xcc, /* ####....####.... */
	0xdb, /* ####..####..#### */
	0x37, /* ....####..###### */
	0x6f, /* ..####..######## */
	0xcf, /* ####....######## */
	0x03, /* ............#### */

	/* code 173 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 174 */
	0x00, /* ................ */
	0x33, /* ....####....#### */
	0x66, /* ..####....####.. */
	0xcc, /* ####....####.... */
	0x66, /* ..####....####.. */
	0x33, /* ....####....#### */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 175 */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0x66, /* ..####....####.. */
	0x33, /* ....####....#### */
	0x66, /* ..####....####.. */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 176 */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */

	/* code 177 */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */

	/* code 178 */
	0xdb, /* ####..####..#### */
	0x77, /* ..######..###### */
	0xdb, /* ####..####..#### */
	0xee, /* ######..######.. */
	0xdb, /* ####..####..#### */
	0x77, /* ..######..###### */
	0xdb, /* ####..####..#### */
	0xee, /* ######..######.. */

	/* code 179 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 180 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 181 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 182 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 183 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 184 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 185 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x06, /* ..........####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 186 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 187 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x06, /* ..........####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 188 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x06, /* ..........####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 189 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 190 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 191 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 192 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 193 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 194 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 195 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 196 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 197 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 198 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 199 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 200 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x30, /* ....####........ */
	0x3f, /* ....############ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 201 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3f, /* ....############ */
	0x30, /* ....####........ */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 202 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf7, /* ########..###### */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 203 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xf7, /* ########..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 204 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x30, /* ....####........ */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 205 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 206 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf7, /* ########..###### */
	0x00, /* ................ */
	0xf7, /* ########..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 207 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 208 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 209 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 210 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 211 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x3f, /* ....############ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 212 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 213 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 214 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3f, /* ....############ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 215 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xff, /* ################ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 216 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 217 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 218 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 219 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 220 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 221 */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */

	/* code 222 */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */

	/* code 223 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 224 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0xc8, /* ####....##...... */
	0xdc, /* ####..######.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 225 */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xf8, /* ##########...... */
	0xcc, /* ####....####.... */
	0xf8, /* ##########...... */
	0xc0, /* ####............ */
	0xc0, /* ####............ */

	/* code 226 */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x00, /* ................ */

	/* code 227 */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */

	/* code 228 */
	0xfc, /* ############.... */
	0xcc, /* ####....####.... */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xcc, /* ####....####.... */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 229 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0x70, /* ..######........ */
	0x00, /* ................ */

	/* code 230 */
	0x00, /* ................ */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */

	/* code 231 */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 232 */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0xfc, /* ############.... */

	/* code 233 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 234 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xee, /* ######..######.. */
	0x00, /* ................ */

	/* code 235 */
	0x1c, /* ......######.... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 236 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0x7e, /* ..############.. */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 237 */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x7e, /* ..############.. */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0x7e, /* ..############.. */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */

	/* code 238 */
	0x3c, /* ....########.... */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0xc0, /* ####............ */
	0x60, /* ..####.......... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 239 */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 240 */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 241 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 242 */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 243 */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 244 */
	0x0e, /* ........######.. */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 245 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0x70, /* ..######........ */

	/* code 246 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 247 */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 248 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 249 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 250 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 251 */
	0x0f, /* ........######## */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xec, /* ######..####.... */
	0x6c, /* ..####..####.... */
	0x3c, /* ....########.... */
	0x1c, /* ......######.... */

	/* code 252 */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 253 */
	0x70, /* ..######........ */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x78, /* ..########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 254 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 255 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
};
