require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM_DB_MACHDEP_H_)) {
    eval 'sub _ARM_DB_MACHDEP_H_ () {1;}' unless defined(&_ARM_DB_MACHDEP_H_);
    require 'uvm/uvm_extern.ph';
    require 'arm/armreg.ph';
    require 'machine/frame.ph';
    require 'machine/trap.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    if(defined(&__PROG26)) {
	eval 'sub PC_REGS {
	    local($regs) = @_;
    	    eval q((( &db_addr_t)($regs)-> &tf_r15 &  &R15_PC));
	}' unless defined(&PC_REGS);
	eval 'sub PC_ADVANCE {
	    local($regs) = @_;
    	    eval q((($regs)-> &tf_r15 += 4));
	}' unless defined(&PC_ADVANCE);
    } else {
	eval 'sub PC_REGS {
	    local($regs) = @_;
    	    eval q((( &db_addr_t)($regs)-> &tf_pc));
	}' unless defined(&PC_REGS);
    }
    eval 'sub BKPT_INST () {( &KERNEL_BREAKPOINT);}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {( &INSN_SIZE);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        local($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub T_BREAKPOINT () {(1);}' unless defined(&T_BREAKPOINT);
    eval 'sub IS_BREAKPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((0));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub inst_trap_return {
        local($ins) = @_;
	    eval q((0));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        local($ins) = @_;
	    eval q(((($ins) & 0xe108000) == 0x8108000 || (($ins) & 0xff0fff0) == 0x1a0f000));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        local($ins) = @_;
	    eval q(((($ins) & 0xf000000) == 0xb000000));
    }' unless defined(&inst_call);
    eval 'sub inst_branch {
        local($ins) = @_;
	    eval q(((($ins) & 0xf000000) == 0xa000000 || (($ins) & 0xfdffff0) == 0x79ff100));
    }' unless defined(&inst_branch);
    eval 'sub inst_load {
        local($ins) = @_;
	    eval q((0));
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        local($ins) = @_;
	    eval q((0));
    }' unless defined(&inst_store);
    eval 'sub inst_unconditional_flow_transfer {
        local($ins) = @_;
	    eval q((((($ins) &  &INSN_COND_MASK) ==  &INSN_COND_AL)  && ( &inst_branch($ins) ||  &inst_call($ins) ||  &inst_return($ins))));
    }' unless defined(&inst_unconditional_flow_transfer);
    eval 'sub getreg_val () {(0);}' unless defined(&getreg_val);
    eval 'sub next_instr_address {
        local($pc, $bd) = @_;
	    eval q((($bd) ? ($pc) : (($pc) +  &INSN_SIZE)));
    }' unless defined(&next_instr_address);
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
    eval 'sub branch_taken {
        local($ins, $pc, $fun, $regs) = @_;
	    eval q( &db_branch_taken(($ins), ($pc), ($regs)));
    }' unless defined(&branch_taken);
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub DB_ELFSIZE () {32;}' unless defined(&DB_ELFSIZE);
    eval 'sub DB_NO_AOUT () {1;}' unless defined(&DB_NO_AOUT);
}
1;
